/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.qa.impl;

import com.tydic.se.search.qa.impl.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorProcessPool {
    private static final Logger log = LoggerFactory.getLogger(ExecutorProcessPool.class);
    private static ExecutorProcessPool pool = new ExecutorProcessPool();
    private ExecutorService cacheExcecutor = ExecutorServiceFactory.getInstance().createCachedThreadPool();
    private ExecutorService fixedExcecutor = ExecutorServiceFactory.getInstance().createFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private ExecutorService customExcecutor = ExecutorServiceFactory.getInstance().createCustomThreadPool();

    private ExecutorProcessPool() {
    }

    public static ExecutorProcessPool getInstance() {
        return pool;
    }

    public void executeByCacheThread(Runnable task) {
        this.cacheExcecutor.execute(task);
        this.log("cache ", (ThreadPoolExecutor)this.cacheExcecutor);
    }

    public void executeByFixedThread(Runnable task) {
        this.fixedExcecutor.execute(task);
        this.log("fixed", (ThreadPoolExecutor)this.fixedExcecutor);
    }

    public void executeByCustomThread(Runnable task) {
        this.customExcecutor.execute(task);
        this.log("custom", (ThreadPoolExecutor)this.customExcecutor);
    }

    public void executeByCustomThread(Runnable task, ExecutorService executorService) {
        executorService.execute(task);
        this.log("custom", (ThreadPoolExecutor)executorService);
    }

    public void log(String name, ThreadPoolExecutor tpe) {
        String status = "[Thread] " + name + " activeCount: " + tpe.getActiveCount() + " ; CompletedTaskCount: " + tpe.getCompletedTaskCount() + " ; Queue Size: " + tpe.getQueue().size() + "; taskCount: " + tpe.getTaskCount();
        log.warn(status);
    }

    public static void shutdownAll() {
        ExecutorProcessPool.pool.cacheExcecutor.shutdown();
        ExecutorProcessPool.pool.fixedExcecutor.shutdown();
        ExecutorProcessPool.pool.customExcecutor.shutdown();
    }
}

