/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.tydic.se.search.sort.config.SearchSortConfig;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

@Service
public class SearchRelevanceFieldBuilder
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SearchRelevanceFieldBuilder.class);
    private static final String LONG_ACCURATE_FIELDS_STR_FIELD = "es.accurate.fields";
    private static final String ACCURATE_FIELDS_STR_FIELD = "es.accurate.fields";
    private static final String NULL = "null";
    @Autowired
    @Qualifier(value="searchSortConfig")
    private SearchSortConfig searchSortConfig;
    @Value(value="${es.accurate.fields:null}")
    private String longAccurateFieldsStr;
    @Value(value="${es.accurate.text.fields:null}")
    private String accurateFieldsStr;

    public void run(String ... args) {
        if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceFieldMatching()) || NULL.equals(this.searchSortConfig.getRelevanceFieldMatching())) {
            this.longAccurateFieldsStr2relevanceFieldMatching(this.longAccurateFieldsStr);
        }
        if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceChineseFieldMatching()) || NULL.equals(this.searchSortConfig.getRelevanceChineseFieldMatching())) {
            this.accurateFieldsStr2relevanceChineseFieldMatching(this.accurateFieldsStr);
        }
    }

    @ApolloConfigChangeListener
    private void onChangeToAll(ConfigChangeEvent changeEvent) {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change;
            if (key.equals("es.accurate.fields")) {
                change = changeEvent.getChange(key);
                if (!StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceFieldMatching())) {
                    this.longAccurateFieldsStr2relevanceFieldMatching(change.getNewValue());
                }
            }
            if (!key.equals("es.accurate.fields")) continue;
            change = changeEvent.getChange(key);
            if (StringUtils.isNotBlank((CharSequence)this.searchSortConfig.getRelevanceChineseFieldMatching())) continue;
            this.accurateFieldsStr2relevanceChineseFieldMatching(change.getNewValue());
        }
    }

    private void longAccurateFieldsStr2relevanceFieldMatching(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> esNewFields.add(SearchSortUtils.lineToHump((String)esField)));
            log.info("relevanceFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchSortConfig.setRelevanceFieldMatching(String.join((CharSequence)",", esNewFields));
        }
    }

    private void accurateFieldsStr2relevanceChineseFieldMatching(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> {
                esField = esField.replace(".keyword", "");
                esNewFields.add(SearchSortUtils.lineToHump((String)esField));
            });
            log.info("relevanceChineseFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchSortConfig.setRelevanceChineseFieldMatching(String.join((CharSequence)",", esNewFields));
        }
    }
}

