/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeSkuPropertiesBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.ability.bo.SeEntityCacheRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.impl.steps.api.SearchCategoryParseFilterService;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.SeQueryBuilder;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityRelevanceSortService;
import com.tydic.se.search.sort.bo.SearchCategoryRelevanceBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="seQueryService")
public class SeQueryServiceImpl
implements SeQueryService {
    private static final Logger log = LoggerFactory.getLogger(SeQueryServiceImpl.class);
    @Autowired
    private SeQueryBuilder seQueryBuilder;
    @Autowired
    private SeEntityCache seEntityCache;
    @Autowired
    private SearchStepRelevanceService searchStepRelevanceService;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityRelevanceSortService searchCommodityRelevanceSortService;
    @Autowired
    private SearchCategoryParseFilterService searchCategoryParseFilterService;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @SearchLinkLog(desc="\u5b8c\u6574\u53ec\u56de")
    public ExecuteSearchRspBO search(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.executeSearch(executeSearchReqBO);
    }

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        return this.seQueryBuilder.simpleSearch(executeSearchReqBO);
    }

    public SeEntityCacheRspBO refreshCache() {
        JSONObject seEntityCacheBO = this.seEntityCache.init();
        SeEntityCacheRspBO rspBO = new SeEntityCacheRspBO();
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        rspBO.setData(seEntityCacheBO);
        return rspBO;
    }

    public ExecuteSearchRspBO categoryList(ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setIsAggregation(Boolean.valueOf(true));
        ExecuteSearchRspBO executeSearchRspBO = this.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        executeSearchRspBO.setResult(null);
        executeSearchRspBO.setQueryBody(null);
        SearchCategoryRelevanceBo searchCategoryRelevanceBo = new SearchCategoryRelevanceBo();
        searchCategoryRelevanceBo.setSkuList(this.searchCategoryParseFilterService.getSeQuerySkuBoList(executeSearchRspBO, executeSearchReqBO));
        searchCategoryRelevanceBo.setSearchSortMsgBo(this.searchCommodityBaseService.initParameterCategory(executeSearchReqBO));
        if ("L0".equals(executeSearchReqBO.getSearchType()) || "L1".equals(executeSearchReqBO.getSearchType()) || "L4".equals(executeSearchReqBO.getSearchType())) {
            log.info("{}{}\u67e5\u8be2\u7ea7\u522b\u4e3a\uff1a{}\uff0c\u8df3\u8fc7\u9ed8\u8ba4\u6392\u5e8f\uff01", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", executeSearchReqBO.getSearchType()});
        } else if (StringUtils.isNotBlank((CharSequence)executeSearchReqBO.getQueryStr())) {
            searchCategoryRelevanceBo.setSkuList(this.searchStepRelevanceService.categoryRelevanceSort(searchCategoryRelevanceBo));
        } else {
            log.info("\u7a7a\u641c\u8df3\u8fc7\u57fa\u7840\u6392\u5e8f!");
        }
        LinkedHashSet<SeSkuPropertiesBO> skuPropertiesList = new LinkedHashSet<SeSkuPropertiesBO>(this.searchCategoryParseFilterService.parseSkuPropertiesList(searchCategoryRelevanceBo.getSkuList(), executeSearchReqBO.getSeChannelType()));
        List<SeQueryFilterBO> queryFilterList = this.searchCategoryParseFilterService.parseQueryFilterList(esResultBO, new ArrayList<SeSkuPropertiesBO>(skuPropertiesList), executeSearchReqBO.getSeChannelType());
        executeSearchRspBO.setQueryFilterList(queryFilterList);
        searchCategoryRelevanceBo.setCategoryFilterMap(this.searchCategoryParseFilterService.getQueryFilterList(executeSearchRspBO));
        List<SeQueryPropertyBO> queryPropertyList = this.searchCategoryParseFilterService.parseQueryPropertyList(new ArrayList<SeSkuPropertiesBO>(skuPropertiesList));
        String propertiesFilter = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).searchFilterProperties;
        if (Objects.equals(propertiesFilter, "1") && !CollectionUtils.isEmpty((Collection)executeSearchReqBO.getQueryPropertyList())) {
            List filterPropertyIds = executeSearchReqBO.getQueryPropertyList().stream().map(SeQueryPropertyBO::getPropertyId).collect(Collectors.toList());
            queryPropertyList.removeIf(seQueryPropertyBO -> filterPropertyIds.contains(seQueryPropertyBO.getPropertyId()));
        }
        executeSearchRspBO.setQueryPropertyList(queryPropertyList);
        executeSearchRspBO = this.searchCommodityRelevanceSortService.categoryRelevanceSort(executeSearchRspBO, executeSearchReqBO, searchCategoryRelevanceBo);
        executeSearchRspBO = this.channelL3CategorySort(executeSearchReqBO, executeSearchRspBO);
        return executeSearchRspBO;
    }

    private ExecuteSearchRspBO channelL3CategorySort(ExecuteSearchReqBO executeSearchReqBO, ExecuteSearchRspBO baseRsp) {
        ExecuteSearchRspBO executeSearchRspBO = (ExecuteSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseRsp), ExecuteSearchRspBO.class);
        try {
            List channelIds;
            String channelL3CategorySort = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get(executeSearchReqBO.getSeChannelType())).getSearchSortL3Category();
            String channelL3CategoryConfig = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get(executeSearchReqBO.getSeChannelType())).getSearchSortL3CategoryConfig();
            if (Objects.equals(channelL3CategorySort, "0")) {
                return executeSearchRspBO;
            }
            if (StringUtils.isBlank((CharSequence)channelL3CategoryConfig)) {
                return executeSearchRspBO;
            }
            List l3CategoryFilterBoList = executeSearchRspBO.getQueryFilterList().stream().filter(seQueryFilterBO -> seQueryFilterBO.getFilterId().equals("l3_category_name")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(l3CategoryFilterBoList)) {
                return executeSearchRspBO;
            }
            if (l3CategoryFilterBoList.size() > 1) {
                log.warn("\u4e09\u7ea7\u76ee\u5f55\u6309\u5e38\u7528\u76ee\u5f55\u6392\u5217\u5728\u524d\u5f02\u5e38\uff01 \u5339\u914d\u5230{}\u4e2al3Category", (Object)l3CategoryFilterBoList.size());
                return executeSearchRspBO;
            }
            try {
                channelIds = ((SeTermsBO)executeSearchReqBO.getMustTermsList().stream().filter(seTermsBO -> "channel_id".equals(seTermsBO.getName())).collect(Collectors.toList()).get(0)).getValueList();
            }
            catch (Exception e) {
                log.error("\u7b5b\u9009\u680f\u9891\u9053Id\u83b7\u53d6\u5f02\u5e38\uff01", (Throwable)e);
                return executeSearchRspBO;
            }
            if (Boolean.FALSE.equals(CollectionUtils.isEmpty((Collection)channelIds))) {
                List filterValues = ((SeQueryFilterBO)l3CategoryFilterBoList.get(0)).getFilterValues();
                LinkedHashSet<String> dealFilterValues = new LinkedHashSet<String>();
                try {
                    String[] l3CategoryConfigList;
                    for (String l3CategoryConfig : l3CategoryConfigList = channelL3CategoryConfig.split(";")) {
                        String[] l3CategoryList;
                        String channel = l3CategoryConfig.split(":")[0];
                        if (!channelIds.contains(channel)) continue;
                        for (String l3Category : l3CategoryList = l3CategoryConfig.split(":")[1].split(",")) {
                            if (!filterValues.contains(l3Category)) continue;
                            dealFilterValues.add(l3Category);
                            filterValues.remove(l3Category);
                        }
                        dealFilterValues.addAll(filterValues);
                        ((SeQueryFilterBO)l3CategoryFilterBoList.get(0)).setFilterValues(new LinkedList(dealFilterValues));
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("\u4e09\u7ea7\u76ee\u5f55\u6309\u5e38\u7528\u76ee\u5f55\u6392\u5217\u5728\u524d\u914d\u7f6e\u5f02\u5e38!", (Throwable)e);
                }
            }
            List othersFilterBoList = executeSearchRspBO.getQueryFilterList().stream().filter(seQueryFilterBO -> !seQueryFilterBO.getFilterId().equals("l3_category_name")).collect(Collectors.toList());
            othersFilterBoList.add(l3CategoryFilterBoList.get(0));
            executeSearchRspBO.setQueryFilterList(othersFilterBoList);
            return executeSearchRspBO;
        }
        catch (Exception e) {
            log.error("\u4e09\u7ea7\u76ee\u5f55\u6309\u5e38\u7528\u76ee\u5f55\u6392\u5217\u5728\u524d \u5185\u90e8\u8c03\u6574\u5f02\u5e38\uff01");
            e.printStackTrace();
            return baseRsp;
        }
    }

    private String parseQueryPropertyName(String name) {
        if ("texture".equals(name)) {
            return "\u6750\u8d28";
        }
        if ("model".equals(name)) {
            return "\u578b\u53f7";
        }
        if ("spec".equals(name)) {
            return "\u8bf4\u660e";
        }
        if ("measure_name".equals(name)) {
            return "\u5355\u4f4d";
        }
        return "\u5176\u5b83";
    }
}

