/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.se.search.ability.SeQueryService;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RefreshCacheTimer {
    private static final Logger log = LoggerFactory.getLogger(RefreshCacheTimer.class);
    @Autowired
    SeQueryService seQueryService;

    @Scheduled(cron="${timing.task.cron:0 */22 0 * * ?}")
    public void timerToNow() {
        String now = DateUtils.dateToStrLong((Date)new Date());
        log.info("{} \u641c\u7d22\u7f13\u5b58 \u5b9a\u65f6\u5237\u65b0\u5f00\u542f\uff01", (Object)now);
        CompletableFuture<Void> runFuture = CompletableFuture.runAsync(() -> {
            log.info("The cache refresh timing task starts");
            this.seQueryService.refreshCache();
            log.info("Cache refresh timing task execution end");
        });
        runFuture.whenComplete((result, e) -> log.error("{} \u641c\u7d22\u7f13\u5b58 \u5f02\u6b65\u6267\u884c\u5f02\u5e38\uff01 ex:{}", new Object[]{now, e.getMessage(), e}));
        log.info("{} \u641c\u7d22\u7f13\u5b58 \u5f02\u6b65\u6267\u884c\uff01", (Object)now);
    }
}

