/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.normalized.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.nlp.bo.AnalysisEsAnalyzeQueryBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.SeQueryBuilder;
import com.tydic.se.search.normalized.AnalyzerTokensService;
import com.tydic.se.search.normalized.bo.AnalyzerTokensBo;
import com.tydic.se.search.normalized.bo.AnalyzerTokensReqBO;
import com.tydic.se.search.normalized.bo.AnalyzerTokensRspBO;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalyzerTokensServiceImpl
implements AnalyzerTokensService {
    private static final Logger log = LoggerFactory.getLogger(AnalyzerTokensServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SeQueryBuilder queryBuilder;

    public AnalyzerTokensRspBO analyzer(AnalyzerTokensReqBO reqBO, Long seChannelType) {
        AnalyzerTokensRspBO rspBO = new AnalyzerTokensRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getTokens())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(new LinkedList());
            return rspBO;
        }
        String analyzer = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esParticipleAnalyzer;
        AnalysisEsAnalyzeQueryBO analysisEsAnalyzeQueryBO = new AnalysisEsAnalyzeQueryBO();
        analysisEsAnalyzeQueryBO.setText(reqBO.getTokens());
        analysisEsAnalyzeQueryBO.setAnalyzer(analyzer);
        String esAnalyze = this.queryBuilder.postEsAnalyze(analysisEsAnalyzeQueryBO, seChannelType);
        if (StringUtils.isBlank((CharSequence)esAnalyze)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List tokensBoList = JSON.parseArray((String)JSON.parseObject((String)esAnalyze).get((Object)"tokens").toString(), AnalyzerTokensBo.class);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(tokensBoList);
        return rspBO;
    }
}

