/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchCommodityRedisDataServiceImpl
implements SearchCommodityRedisDataService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityRedisDataServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public void writerCache(SeSearchRspBO rspB, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String redisUse = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRedisUse;
            String redisCacheNumber = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRedisCacheNumber;
            if (searchSortMsgBo.getRedisEnabled().booleanValue() && Objects.equals(redisUse, "1") && !"null".equals(searchSortMsgBo.getSessionId()) && CollectionUtils.isEmpty((Collection)searchSortMsgBo.getQueryFilterList()) && CollectionUtils.isEmpty((Collection)searchSortMsgBo.getQueryPropertyList()) && !searchSortMsgBo.isSalesPriceJudge()) {
                Set keys = this.cacheClient.getkeys("*" + searchSortMsgBo.getSessionId() + "*");
                List collect = keys.stream().sorted().collect(Collectors.toList());
                if (collect.size() >= Integer.parseInt(redisCacheNumber)) {
                    this.cacheClient.delete((String)collect.get(0));
                }
                rspB.setRecordsTotal(rspB.getSkuList().size());
                rspB.setTotal(searchSortMsgBo.getPageSize());
                Gson s = new Gson();
                String json = s.toJson((Object)rspB);
                if (rspB.getSkuList().size() == 0) {
                    throw new SearchSortException("7204", "\u67e5\u8be2\u4e3a\u7a7a\uff0c\u62d2\u7edd\u5199\u5165\u7f13\u5b58\uff01");
                }
                this.cacheClient.set(searchSortMsgBo.getSessionIdKey(), (Object)json, Integer.parseInt(redisCacheNumber) * 60);
                log.info("{}{}\u67e5\u8be2\u7ed3\u679c\u5199\u5165\u7f13\u5b58\uff01", (Object)">>>\u6392\u5e8f\u540e\u7f6e", (Object)">>>TXT>>>");
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"7776", "\u7f13\u5b58\u5199\u5165\uff01", e});
            throw new SearchSortException("7776", "\u7f13\u5b58\u5199\u5165\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO readCache(SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String json = (String)this.cacheClient.get(searchSortMsgBo.getSessionIdKey());
            return (SeSearchRspBO)JSON.parseObject((String)json, SeSearchRspBO.class);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"7779", "\u7f13\u5b58\u8bfb\u53d6\uff01", e});
            throw new SearchSortException("7779", "\u7f13\u5b58\u8bfb\u53d6\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO dataEncapsulation(SeSearchReqBO reqBO, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            SeSearchRspBO searchEsRspBo = this.readCache(searchSortMsgBo);
            int pageNo = reqBO.getPageNo();
            int pageSize = reqBO.getPageSize();
            if (!CollectionUtils.isEmpty((Collection)searchEsRspBo.getSkuList())) {
                List seQuerySkuBos = searchEsRspBo.getSkuList();
                searchEsRspBo.setSkuList(seQuerySkuBos.subList((pageNo - 1) * pageSize, Math.min(pageNo * pageSize, seQuerySkuBos.size())));
                searchEsRspBo.setTotal(pageSize);
            }
            return searchEsRspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "redis\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", e});
            throw new SearchSortException("9999", "redis\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
        }
    }

    public SeSearchRspBO dataEncapsulation(SeSearchRspBO rspBo, SeSearchReqBO reqBO) {
        try {
            String ES_SEARCH_SIZE = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)reqBO.getSeChannelType())).esConfigSearchSize;
            if (rspBo.getSkuList().size() > Integer.parseInt(ES_SEARCH_SIZE)) {
                rspBo.setSkuList(rspBo.getSkuList().subList(0, Integer.parseInt(ES_SEARCH_SIZE)));
            }
            if (Objects.equals(((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchSortNoPictureMode, "1")) {
                LinkedList<Object> seQuerySkuBoListTmp = new LinkedList<Object>();
                LinkedList<SeQuerySkuBO> seQuerySkuNoPictureBOList = new LinkedList<SeQuerySkuBO>();
                for (SeQuerySkuBO seQuerySkuBO2 : rspBo.getSkuList()) {
                    if (StringUtils.isBlank((CharSequence)seQuerySkuBO2.getPriPicUrl())) {
                        seQuerySkuNoPictureBOList.add(seQuerySkuBO2);
                        continue;
                    }
                    seQuerySkuBoListTmp.add(seQuerySkuBO2);
                }
                seQuerySkuBoListTmp.addAll(seQuerySkuNoPictureBOList);
                rspBo.setSkuList(seQuerySkuBoListTmp);
            }
            int pageNo = reqBO.getPageNo();
            int pageSize = reqBO.getPageSize();
            if (!CollectionUtils.isEmpty((Collection)rspBo.getSkuList())) {
                List seQuerySkuBos = rspBo.getSkuList();
                rspBo.setRecordsTotal(rspBo.getSkuList().size());
                pageNo = Math.min(pageNo, rspBo.getRecordsTotal() / pageSize + 1);
                rspBo.setSkuList(seQuerySkuBos.subList((pageNo - 1) * pageSize, Math.min(pageNo * pageSize, seQuerySkuBos.size())));
                rspBo.getSkuList().forEach(seQuerySkuBO -> {
                    List categoryNames = seQuerySkuBO.getL3CategoryName();
                    if (categoryNames != null && !categoryNames.isEmpty()) {
                        seQuerySkuBO.setCatalogAllName(categoryNames.stream().collect(Collectors.joining("/")));
                    }
                });
                String printCommodityName = ((SearchProcessConfig.ManageConfig)this.searchProcessConfig.getManage().get((Object)reqBO.getSeChannelType())).searchOpenPrintCommodityName;
                if (Objects.equals(printCommodityName, "1")) {
                    SearchSortUtils.printCommodityName((SeSearchRspBO)rspBo);
                }
            } else {
                rspBo.setRecordsTotal(0);
            }
            rspBo.setTotal(rspBo.getRecordsTotal() / pageSize + 1);
            return rspBo;
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", e});
            throw new SearchSortException("9999", "\u8fd4\u56de\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
        }
    }
}

