/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityRelevanceSortService;
import com.tydic.se.search.sort.bo.SearchCategoryRelevanceBo;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepArtificialInterventionService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceBaseService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceCorrelationDataService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceRelevantWeighService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceWeightService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepSmoothParametersSortService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="SearchCommodityRelevanceSortServiceImpl")
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class SearchCommodityRelevanceSortServiceImpl
implements SearchCommodityRelevanceSortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityRelevanceSortServiceImpl.class);
    @Autowired
    private SearchStepRelevanceService searchStepRelevanceService;
    @Autowired
    private SearchStepSmoothParametersSortService searchStepSmoothParametersSortService;
    @Autowired
    private SearchStepArtificialInterventionService searchStepArtificialInterventionService;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchStepRelevanceBaseService searchStepRelevanceBaseService;
    @Autowired
    private SearchStepRelevanceCorrelationDataService searchStepRelevanceCorrelationDataService;
    @Autowired
    private SearchStepRelevanceRelevantWeighService searchStepRelevanceRelevantWeighService;
    @Autowired
    private SearchStepRelevanceWeightService searchStepRelevanceWeightService;

    public SeSearchRspBO relevanceSort(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        try {
            String allUseWeights = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchGlobalProductFiltering;
            if (!Objects.equals(allUseWeights, "1") && rspBo.getReCallType().equals(2)) {
                rspBo.setQueryResultType("1");
                log.warn("{}{}\u5168\u6587\u68c0\u7d22\u4e0d\u9700\u8981\u6267\u884c\u76f8\u5173\u6027\u6392\u5e8f\uff01", (Object)">>>\u76f8\u5173\u6027\u6392\u5e8f", (Object)">>>TXT>>>");
                return rspBo;
            }
            this.searchStepRelevanceService.relevance(rspBo, searchSortMsgBo);
            rspBo = this.searchStepSmoothParametersSortService.smoothParametersSort(rspBo, searchSortMsgBo);
            rspBo = this.searchStepArtificialInterventionService.artificialIntervention(rspBo, searchSortMsgBo);
            return rspBo;
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", e});
            throw new SearchSortException("9999", "\u76f8\u5173\u5ea6\u6392\u5e8f\uff01", (Throwable)e);
        }
    }

    public ExecuteSearchRspBO categoryRelevanceSort(ExecuteSearchRspBO executeSearchRspBO, ExecuteSearchReqBO executeSearchReqBO, SearchCategoryRelevanceBo searchCategoryRelevanceBo) {
        if (ObjectUtils.isEmpty((Object)executeSearchReqBO.getQueryStr())) {
            return executeSearchRspBO;
        }
        String giveUp = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)executeSearchReqBO.getSeChannelType())).searchSortGiveUp;
        if (Objects.equals(giveUp, "0")) {
            return executeSearchRspBO;
        }
        this.searchStepRelevanceService.categoryRelevanceFilter(searchCategoryRelevanceBo, executeSearchReqBO.getSeChannelType());
        Map finalCategoryFilterMap = searchCategoryRelevanceBo.getCategoryFilterMap();
        Set queryFilterList = executeSearchRspBO.getQueryFilterList().stream().peek(seQueryFilterBO -> {
            Set filterValues = seQueryFilterBO.getFilterValues().stream().filter(s -> {
                if (((Integer)((Map)finalCategoryFilterMap.get(seQueryFilterBO.getFilterId())).get(s)).equals(1)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }).collect(Collectors.toSet());
            seQueryFilterBO.setFilterValues(new ArrayList(filterValues));
        }).collect(Collectors.toSet());
        executeSearchRspBO.setQueryFilterList(new ArrayList(queryFilterList));
        return executeSearchRspBO;
    }
}

