/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.ability.bo.recommend.RecProductReqBO;
import com.tydic.se.base.ability.bo.recommend.SearchRecommendRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityDefaultSortService;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.SearchCommoditySortService;
import com.tydic.se.search.sort.SearchCommoditySpecifySortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepSupplierDisruptService;
import com.tydic.se.search.util.CompletableFutureExpandUtils;
import com.tydic.se.search.util.SearchHttpUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SearchCommoditySortServiceImpl
implements SearchCommoditySortService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommoditySortServiceImpl.class);
    @Qualifier(value="sortExecutorService")
    @Autowired
    private ExecutorService sortExecutorService;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SearchCommodityDefaultSortService searchCommodityDefaultSortService;
    @Autowired
    private SearchCommoditySpecifySortService searchCommoditySpecifySortService;
    @Autowired
    private SearchCommodityRedisDataService searchCommodityRedisDataService;
    @Autowired
    private SearchStepSupplierDisruptService searchStepSupplierDisruptService;

    @SearchLinkLog(desc="\u5b8c\u6574\u6392\u5e8f")
    public SeSearchRspBO commoditySorting(SeSearchReqBO reqBo, SeSearchRspBO rspBo) throws SearchSortException {
        SearchSortMsgBo searchSortMsgBo = this.searchCommodityBaseService.initParameter(reqBo);
        if ("L0".equals(reqBo.getSearchType()) || "L1".equals(reqBo.getSearchType()) || "L4".equals(reqBo.getSearchType())) {
            log.info("{}{}\u67e5\u8be2\u7ea7\u522b\u4e3a\uff1a{}\uff0c\u8df3\u8fc7\u9ed8\u8ba4\u6392\u5e8f\uff01", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", reqBo.getSearchType()});
        } else if (StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr())) {
            rspBo = this.dataFusion(reqBo, rspBo, searchSortMsgBo);
        } else {
            log.info("\u7a7a\u641c\u8df3\u8fc7\u57fa\u7840\u6392\u5e8f!");
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) || searchSortMsgBo.isSalesPriceJudge()) {
                rspBo = this.searchCommoditySpecifySortService.specifySort(rspBo, reqBo, searchSortMsgBo);
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", e});
            throw new SearchSortException("9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", (Throwable)e);
        }
        try {
            rspBo = this.searchStepSupplierDisruptService.supplierDisruptSorting(rspBo, reqBo, searchSortMsgBo);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u4f9b\u5e94\u5546\u6253\u4e71\u5f02\u5e38\uff01", e});
        }
        try {
            this.searchCommodityBaseService.supplierNotSupport(reqBo, rspBo);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u4f9b\u5e94\u5546\u6570\u636e\u6821\u9a8c\u5f02\u5e38\uff01", e});
        }
        return rspBo;
    }

    public SeSearchRspBO normCommoditySorting(SeSearchReqBO reqBo, ExecuteSearchReqBO executeSearchReqBO, SeSearchRspBO rspBo) throws SearchSortException {
        SearchSortMsgBo searchSortMsgBo = this.searchCommodityBaseService.initParameter(reqBo);
        searchSortMsgBo.setAccurateFieldsStr(this.fieldTransformation(executeSearchReqBO.getAccurateFieldsStr()));
        searchSortMsgBo.setLongAccurateFieldsStr(this.fieldTransformation(executeSearchReqBO.getLongAccurateFieldsStr()));
        rspBo = this.dataFusion(reqBo, rspBo, searchSortMsgBo);
        try {
            if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) || searchSortMsgBo.isSalesPriceJudge()) {
                rspBo = this.searchCommoditySpecifySortService.specifySort(rspBo, reqBo, searchSortMsgBo);
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", e});
            throw new SearchSortException("9999", "\u67e5\u8be2\u6307\u5b9a\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", (Throwable)e);
        }
        try {
            rspBo = this.searchStepSupplierDisruptService.supplierDisruptSorting(rspBo, reqBo, searchSortMsgBo);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u4f9b\u5e94\u5546\u6253\u4e71\u5f02\u5e38\uff01", e});
        }
        return rspBo;
    }

    private SeSearchRspBO dataFusion(SeSearchReqBO reqBO, SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        SeSearchRspBO finalRspBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBo), SeSearchRspBO.class);
        String searchSortBaseTimeout = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchSortBaseTimeout;
        CompletableFuture baseSortFuture = CompletableFuture.supplyAsync(() -> this.baseCommoditySorting(reqBO, finalRspBo, searchSortMsgBo), this.sortExecutorService);
        baseSortFuture = CompletableFutureExpandUtils.orTimeout(baseSortFuture, (long)Long.parseLong(searchSortBaseTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
        baseSortFuture.handle((a, throwable) -> {
            log.error("{}{}\u641c\u7d22\u5f15\u64ce\u9ed8\u8ba4\u6392\u5e8f\u5f02\u5e38\uff01ex:{}", new Object[]{">>>\u6392\u5e8f\u540e\u7f6e", ">>>TXT>>>", throwable.getMessage()});
            throwable.printStackTrace();
            return null;
        });
        CompletableFuture recommendSortFuture = CompletableFuture.supplyAsync(() -> this.recommendSorting(reqBO.getRecProductReqBO(), searchSortMsgBo), this.sortExecutorService);
        String searchSortRecommendTimeout = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchSortRecommendTimeout;
        recommendSortFuture = CompletableFutureExpandUtils.orTimeout(recommendSortFuture, (long)Long.parseLong(searchSortRecommendTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
        recommendSortFuture.handle((a, throwable) -> {
            if (!ObjectUtils.isEmpty((Object)throwable)) {
                log.error("{}{}\u667a\u80fd\u63a8\u8350\u5546\u54c1\u83b7\u53d6\u5f02\u5e38\uff01ex:{}", new Object[]{">>>\u667a\u80fd\u63a8\u8350", ">>>TXT>>>", throwable.getMessage()});
                throwable.printStackTrace();
            }
            return null;
        });
        ((CompletableFuture)CompletableFuture.allOf(baseSortFuture, recommendSortFuture).exceptionally(e -> null)).join();
        try {
            SeSearchRspBO recBo = (SeSearchRspBO)recommendSortFuture.get();
            if (!ObjectUtils.isEmpty((Object)recBo)) {
                searchSortMsgBo.setRecSkuList(recBo.getSkuList());
            }
            return (SeSearchRspBO)baseSortFuture.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return rspBo;
        }
    }

    public SeSearchRspBO recommendSorting(SeSearchReqBO reqBO) {
        SeSearchRspBO rspBo = this.recommendSorting(reqBO.getRecProductReqBO(), null);
        return this.searchCommodityRedisDataService.dataEncapsulation(rspBo, reqBO);
    }

    private SeSearchRspBO recommendSorting(RecProductReqBO recProductReqBO, SearchSortMsgBo searchSortMsgBo) {
        if (ObjectUtils.isEmpty((Object)recProductReqBO)) {
            return null;
        }
        String recommendationUrl = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRecommendUrl;
        if (StringUtils.isBlank((CharSequence)recommendationUrl)) {
            return null;
        }
        if (!ObjectUtils.isEmpty((Object)searchSortMsgBo) && searchSortMsgBo.getComSortList().size() == 1 && !"_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn())) {
            return null;
        }
        Map paramsMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)recProductReqBO), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        try {
            return (SeSearchRspBO)SearchHttpUtil.doPost((String)recommendationUrl, (status, json) -> {
                if (status != 200) {
                    throw new SearchSortException("8502", "\u667a\u80fd\u63a8\u8350\u8c03\u7528\u5f02\u5e38");
                }
                SearchRecommendRspBO searchRecommendRspBO = (SearchRecommendRspBO)JSON.parseObject((String)json, SearchRecommendRspBO.class);
                if (!"0".equals(searchRecommendRspBO.getCode())) {
                    throw new SearchSortException("8201", "\u667a\u80fd\u63a8\u8350\u6570\u636e\u8fd4\u56de\u5f02\u5e38");
                }
                SeSearchRspBO rspBO = new SeSearchRspBO();
                rspBO.setSkuList(BeanMapper.mapList((Collection)searchRecommendRspBO.getData().getProductBOList(), SeQuerySkuBO.class));
                log.error("{}{}\u8fd4\u56de\u4e86{}\u4e2a\u5546\u54c1\uff01", new Object[]{">>>\u667a\u80fd\u63a8\u8350", ">>>TXT>>>", rspBO.getSkuList().size()});
                searchSortMsgBo.setSortFusion(Boolean.TRUE);
                return rspBO;
            }, (Map)paramsMap);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u57fa\u7840\u6392\u5e8f\uff01", e});
            return null;
        }
    }

    private SeSearchRspBO baseCommoditySorting(SeSearchReqBO reqBO, SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        rspBo.setSynonymMap(new LinkedHashMap());
        Boolean seComSortExist = searchSortMsgBo.getComSortList().stream().anyMatch(seComSortBO -> "_score".equals(seComSortBO.getOrderByColumn()));
        Boolean seComSortPosition = !searchSortMsgBo.getComSortList().isEmpty() && "_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn());
        try {
            String globalProductFiltering = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchGlobalProductFiltering;
            Boolean open = Objects.equals(globalProductFiltering, "1") ? Boolean.TRUE : Boolean.TRUE.equals(seComSortExist) && Boolean.TRUE.equals(seComSortPosition);
            if (StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && Boolean.TRUE.equals(open)) {
                String redisUse = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortRedisUse;
                if (searchSortMsgBo.getRedisEnabled().booleanValue() && Objects.equals(redisUse, "1") && !CollectionUtils.isEmpty((Collection)searchSortMsgBo.getSessionIdKeySet())) {
                    log.info("{}{}\u6709redis\u7f13\u5b58\uff01", (Object)">>>\u6392\u5e8f\u524d\u7f6e", (Object)">>>TXT>>>");
                    searchSortMsgBo.setSessionIdKey((String)searchSortMsgBo.getSessionIdKeySet().toArray()[0]);
                    rspBo = this.searchCommodityRedisDataService.readCache(searchSortMsgBo);
                    log.info("{}{}redis\u53ef\u7528\u6027:{},redisUse\uff1a{},\u7f13\u5b58\u6570\u91cf:{}", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", searchSortMsgBo.getRedisEnabled(), redisUse, CollectionUtils.isEmpty((Collection)searchSortMsgBo.getSessionIdKeySet()) ? 0 : searchSortMsgBo.getSessionIdKeySet().size()});
                } else {
                    rspBo = this.searchCommodityDefaultSortService.defaultQuerySort(reqBO, rspBo, searchSortMsgBo);
                }
            } else {
                log.info("{}{}\u67e5\u8be2\u4e3a{},\u6392\u5e8f\u5224\u65ad\u4e3a{}-{}-{},\u4e0d\u9700\u8981\u9ed8\u8ba4\u6392\u5e8f\uff01", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", searchSortMsgBo.getQueryStr(), seComSortExist, seComSortPosition, open});
            }
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u9ed8\u8ba4\u67e5\u8be2\u5546\u54c1\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", e});
            throw new SearchSortException("9999", "\u9ed8\u8ba4\u67e5\u8be2\u5546\u54c1\u6392\u5e8f\u5b58\u5728\u95ee\u9898\uff01", (Throwable)e);
        }
        return rspBo;
    }

    private String fieldTransformation(String fieldList) {
        List<String> esFields = Arrays.asList(fieldList.split(","));
        ArrayList esNewFields = new ArrayList();
        esFields.forEach(esField -> {
            esField = esField.replace(".keyword", "");
            esNewFields.add(SearchSortUtils.lineToHump((String)esField));
        });
        return String.join((CharSequence)",", esNewFields);
    }
}

