/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepArtificialInterventionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchStepArtificialInterventionServiceImpl
implements SearchStepArtificialInterventionService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepArtificialInterventionServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u4eba\u5de5\u5e72\u9884\u7c7b\u76ee")
    public SeSearchRspBO artificialIntervention(SeSearchRspBO baseBo, SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        String artificialSort = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortArtificial;
        if (Objects.equals(artificialSort, "0")) {
            return baseBo;
        }
        if (CollectionUtils.isEmpty((Map)searchSortMsgBo.getCatalogAndOrderMap())) {
            return baseBo;
        }
        log.info("{}{}\u4eba\u5de5\u5e72\u9884\u7c7b\u76ee{}{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", ">>>", searchSortMsgBo.getQueryStr()});
        SeSearchRspBO rspBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseBo), SeSearchRspBO.class);
        try {
            LinkedList<Object> artificialList = new LinkedList<Object>();
            LinkedList<SeQuerySkuBO> generalList = new LinkedList<SeQuerySkuBO>();
            ArrayList catalogAndOrderList = new ArrayList(searchSortMsgBo.getCatalogAndOrderMap().keySet());
            String artificialTolerance = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortArtificialTolerance;
            for (SeQuerySkuBO seQuerySkuBO : baseBo.getSkuList()) {
                List manageL3CatalogName = seQuerySkuBO.getL3CategoryName();
                if (CollectionUtils.isEmpty((Collection)manageL3CatalogName)) continue;
                if (Boolean.FALSE.equals(Collections.disjoint(manageL3CatalogName, catalogAndOrderList)) && seQuerySkuBO.getSmoothingWeight() > (double)Integer.parseInt(artificialTolerance)) {
                    artificialList.add(seQuerySkuBO);
                    continue;
                }
                generalList.add(seQuerySkuBO);
            }
            artificialList.addAll(generalList);
            rspBo.setSkuList(artificialList);
            return rspBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u76f8\u5173\u6027\u6392\u5e8f-\u4eba\u5de5\u5e72\u9884\u7c7b\u76ee \u5f02\u5e38\uff01");
            return baseBo;
        }
    }
}

