/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.SeEsbVendorBo;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.impl.steps.api.SearchStepGetNewStockByIdRecallService;
import com.tydic.se.search.util.esb.ESBParamUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepGetNewStockByIdRecallServiceImpl
implements SearchStepGetNewStockByIdRecallService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepGetNewStockByIdRecallServiceImpl.class);
    @Value(value="${search.recall.getNewStockById.url:${ESB_ACCESS_IP}/OSN/api/getNewStockById/v1}")
    private String getNewStockByIdUrl;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u6709\u65e0\u8d27\u8fc7\u6ee4")
    public void getNewStockByIdRecall(SeSearchReqBO reqBO, SeSearchRspBO rspBO, List<String> getNewStockByIdSkuIdList, List<SeEsbVendorBo> esbVendorBoList) {
        try {
            List skuList = rspBO.getSkuList();
            HashMap<String, List<JSONArray>> getNewStockByIdMap = new HashMap<String, List<JSONArray>>();
            for (SeQuerySkuBO sku : skuList) {
                if (sku.getSkuSource() == 2) {
                    List<JSONArray> list;
                    JSONObject bo = new JSONObject();
                    bo.put("skuId", (Object)sku.getExtSkuId());
                    int num = new BigDecimal(String.valueOf(sku.getCommentNumber())).intValue();
                    bo.put("num", (Object)(ObjectUtils.isEmpty((Object)sku.getCommentNumber()) ? 1 : num));
                    if (getNewStockByIdMap.containsKey(String.valueOf(sku.getSupplierId()))) {
                        list = (List)getNewStockByIdMap.get(String.valueOf(sku.getSupplierId()));
                        String getNewStockByIdSize = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchRecallGetNewStockByIdSize;
                        if (((JSONArray)list.get(list.size() - 1)).size() == Integer.parseInt(getNewStockByIdSize)) {
                            JSONArray array = new JSONArray();
                            array.add((Object)bo);
                            list.add(array);
                        } else {
                            ((JSONArray)list.get(list.size() - 1)).add((Object)bo);
                        }
                        getNewStockByIdMap.put(String.valueOf(sku.getSupplierId()), list);
                        continue;
                    }
                    list = new LinkedList();
                    JSONArray array = new JSONArray();
                    array.add((Object)bo);
                    list.add(array);
                    getNewStockByIdMap.put(String.valueOf(sku.getSupplierId()), list);
                    continue;
                }
                getNewStockByIdSkuIdList.add(sku.getExtSkuId());
            }
            String getNewStockByIdNumber = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchRecallGetNewStockByIdNumber;
            for (int i = 0; i < Math.min(Integer.parseInt(getNewStockByIdNumber), esbVendorBoList.size()); ++i) {
                SeEsbVendorBo esbVendorBo = esbVendorBoList.get(i);
                List getNewStockByIdList = (List)getNewStockByIdMap.get(String.valueOf(esbVendorBo.getVendorId()));
                if (ObjectUtils.isEmpty((Object)getNewStockByIdList)) continue;
                for (JSONArray reqArray : getNewStockByIdList) {
                    JSONObject req = new JSONObject();
                    req.put("skuNums", (Object)reqArray);
                    req.put("area", (Object)(esbVendorBo.getProvince() + "_" + esbVendorBo.getCity() + "_" + esbVendorBo.getCounty()));
                    JSONObject rsp = ESBParamUtil.callAbility((String)this.getNewStockByIdUrl, (String)esbVendorBo.getHsn(), (String)req.toJSONString());
                    if (rsp == null || ObjectUtils.isEmpty((Object)rsp.get((Object)"result"))) continue;
                    try {
                        JSONArray result = rsp.getJSONArray("result");
                        for (Object resultOne : result) {
                            JSONObject one = JSON.parseObject((String)JSON.toJSONString(resultOne));
                            if (Objects.equals(one.get((Object)"stockStateId"), 34)) continue;
                            getNewStockByIdSkuIdList.add(one.getString("skuId"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warn("\u4f9b\u5e94\u5546\u8fd4\u56de\u6570\u636e\u5904\u7406\u5f02\u5e38 ex:{} rsp:{}", (Object)e.getMessage(), (Object)rsp);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u6709\u8d27\u67e5\u8be2\u5f02\u5e38\uff01ex:{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new SeBusinessException("\u4f9b\u5e94\u5546\u6709\u8d27\u67e5\u8be2\u5f02\u5e38\uff01");
        }
    }
}

