/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchCommodityCustomInterventionService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceBaseService;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepRelevanceBaseServiceImpl
implements SearchStepRelevanceBaseService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceBaseServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchCommodityCustomInterventionService searchCommodityCustomInterventionService;

    @Override
    public Boolean getIrrelevantRatioPass(Double skuWeight, Long seChannelType) {
        String irrelevantRatioPass = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortIrrelevantRatioPass;
        return skuWeight >= Double.parseDouble(irrelevantRatioPass);
    }

    @Override
    public Boolean getIrrelevantRatioLowest(String queryStr, Double skuWeight, Long seChannelType) {
        String irrelevantRatioLowest = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortIrrelevantRatioLowest;
        Double irrelevantWeight = Double.parseDouble(irrelevantRatioLowest);
        String chineseReg = "[\u4e00-\u9fcc]+";
        Pattern p = Pattern.compile(chineseReg);
        Matcher m = p.matcher(queryStr);
        if (!m.find()) {
            irrelevantWeight = irrelevantWeight * 2.0;
        }
        return skuWeight < irrelevantWeight;
    }

    @Override
    public void manualInterventionWeigh(SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        List queryStrParticiple = searchSortMsgBo.getQueryStrParticiple();
        double basicPoints = seQuerySkuBO.getWeight();
        if (queryStrParticiple.size() != 0) {
            AtomicReference<Double> flag = new AtomicReference<Double>(basicPoints);
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentLast(seQuerySkuBO, searchSortMsgBo));
            flag.updateAndGet(v -> v + this.searchCommodityCustomInterventionService.locationJudgmentSpecialChar(seQuerySkuBO, searchSortMsgBo));
            seQuerySkuBO.setWeight(flag.get());
        }
    }

    @Override
    public List<SeQuerySkuBO> sameWeightsFollowedBySynonyms(List<SeQuerySkuBO> seQuerySkuBOList, final Long seChannelType) {
        return seQuerySkuBOList.stream().sorted(new Comparator<SeQuerySkuBO>(){

            @Override
            public int compare(SeQuerySkuBO o1, SeQuerySkuBO o2) {
                if (o1.getWeight().equals(o2.getWeight())) {
                    String followedBySynonymsUp = ((SearchProcessConfig.SortConfig)((SearchStepRelevanceBaseServiceImpl)SearchStepRelevanceBaseServiceImpl.this).searchProcessConfig.getSort().get((Object)seChannelType)).searchSynonymFollowedBySynonymsUp;
                    if (Objects.equals(followedBySynonymsUp, "1")) {
                        return o1.getSynonymWeight().compareTo(o2.getSynonymWeight());
                    }
                    return o2.getSynonymWeight().compareTo(o1.getSynonymWeight());
                }
                return Double.compare(o2.getWeight(), o1.getWeight());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<SeQuerySkuBO> weightsSynonymsLater(List<SeQuerySkuBO> seQuerySkuBOList) {
        List<SeQuerySkuBO> noSynonyms = seQuerySkuBOList.stream().filter(seQuerySkuBO -> seQuerySkuBO.getSynonymWeight() == 0.0).collect(Collectors.toList());
        List synonyms = seQuerySkuBOList.stream().filter(seQuerySkuBO -> seQuerySkuBO.getSynonymWeight() != 0.0).collect(Collectors.toList());
        noSynonyms.addAll(synonyms);
        return noSynonyms;
    }
}

