/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.util.ExecutorProcessPool;
import com.tydic.se.base.util.ExecutorServiceFactory;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceRelevantWeighService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceSingleWordWeightService;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepRelevanceRelevantWeighServiceImpl
implements SearchStepRelevanceRelevantWeighService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceRelevantWeighServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepRelevanceSingleWordWeightService searchStepRelevanceSingleWordWeightService;

    @Override
    public void relevantWeigh(List<Map<String, Map<String, Object>>> splitData, SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        try {
            if (!searchSortMsgBo.getQueryStrParticiple().isEmpty()) {
                AtomicReference flagWeightMap = new AtomicReference();
                AtomicReference weightCardinal = new AtomicReference();
                flagWeightMap.set(new ConcurrentHashMap());
                weightCardinal.set(new ConcurrentHashMap());
                Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                AtomicReference weightDescAtomic = new AtomicReference(new ArrayList());
                seQuerySkuBO.setWeight(Double.valueOf(0.0));
                seQuerySkuBO.setSynonymWeight(Double.valueOf(0.0));
                Map esFields = (Map)this.searchProcessConfig.getEsFields().get(searchSortMsgBo.getSeChannelType());
                Map<String, List> fieldValues = SearchStepRelevanceUtil.correlationStringPackagingMap(seQuerySkuBO, esFields.keySet(), clazz);
                HashMap esFieldsNew = new HashMap();
                esFields.forEach((key, value) -> {
                    String newKey = key.startsWith("$") ? key.substring(key.lastIndexOf(46) + 1) : key;
                    esFieldsNew.put(newKey, value);
                });
                Long seChannelType = searchSortMsgBo.getSeChannelType();
                Map<Long, Map<String, String>> matchQueryChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_MATCH_QUERY_MAPPING");
                Map<String, String> matchQueryMap = matchQueryChannelMap != null ? matchQueryChannelMap.get(seChannelType) : null;
                boolean isBrandMatchQuery = matchQueryMap != null && "0".equals(matchQueryMap.get("brand_name"));
                boolean isVenderMatchQuery = matchQueryMap != null && "0".equals(matchQueryMap.get("vendor_name"));
                Map<Long, Map<String, String>> exactMatchChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_EXACT_MATCH_MAPPING");
                Map<String, String> exactMatchMap = exactMatchChannelMap != null ? exactMatchChannelMap.get(seChannelType) : null;
                boolean isBrandExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("brand_name"));
                boolean isVendorExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("vendor_name"));
                ExecutorService executorService = ExecutorServiceFactory.getInstance().createCustomThreadPool(5);
                CountDownLatch countDownLatch = new CountDownLatch(fieldValues.size());
                for (Map.Entry<String, List> fieldValueEntry : fieldValues.entrySet()) {
                    Runnable run = () -> {
                        try {
                            String values = String.join((CharSequence)"   ", (Iterable)fieldValueEntry.getValue());
                            splitData.forEach(maps -> {
                                boolean judge = Boolean.TRUE;
                                boolean wordJudge = Boolean.FALSE;
                                for (Map.Entry<String, Map<String, Object>> entry : maps.entrySet()) {
                                    double tmp = this.searchStepRelevanceSingleWordWeightService.singleWordWeight(seQuerySkuBO, values, entry, searchSortMsgBo.getSeChannelType());
                                    if (tmp != 0.0 && judge) {
                                        wordJudge = Boolean.TRUE;
                                    } else {
                                        judge = Boolean.FALSE;
                                    }
                                    if (tmp == 0.0) continue;
                                    if (!((Map)flagWeightMap.get()).containsKey(fieldValueEntry.getKey())) {
                                        ((Map)flagWeightMap.get()).put(fieldValueEntry.getKey(), new BigDecimal("0"));
                                    }
                                    ((Map)flagWeightMap.get()).put(fieldValueEntry.getKey(), ((BigDecimal)((Map)flagWeightMap.get()).get(fieldValueEntry.getKey())).add(new BigDecimal(tmp)));
                                    ((List)weightDescAtomic.get()).add("[" + (String)fieldValueEntry.getKey() + "]" + entry.getKey() + ":" + entry.getValue());
                                    ((Map)weightCardinal.get()).put(fieldValueEntry.getKey(), esFieldsNew.get(fieldValueEntry.getKey()));
                                    if (!Boolean.TRUE.equals(wordJudge)) continue;
                                    break;
                                }
                            });
                        }
                        catch (Exception e) {
                            log.error("{}{}\u5355\u5143\u6743\u91cd\u8ba1\u7b97\u5f02\u6b65\u4efb\u52a1\u5931\u8d25\uff01field:{},values:{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", fieldValueEntry.getKey(), fieldValueEntry.getValue() + e.getMessage(), e});
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    };
                    ExecutorProcessPool.getInstance().executeByCustomThreadNoLog(run, executorService);
                }
                countDownLatch.await();
                BigDecimal weightCardinalTotal = ((Map)weightCardinal.get()).values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                AtomicReference<BigDecimal> weightTotalAtomic = new AtomicReference<BigDecimal>(new BigDecimal("0"));
                ((Map)weightCardinal.get()).forEach((field, weight) -> weightTotalAtomic.updateAndGet(w -> w.add(((BigDecimal)((Map)flagWeightMap.get()).get(field)).multiply((BigDecimal)((Map)weightCardinal.get()).get(field)))));
                BigDecimal weightTotal = weightTotalAtomic.get();
                String searchSortQuerySkuName = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortQuerySkuName;
                if (StringUtils.isNotBlank((CharSequence)searchSortQuerySkuName)) {
                    if (searchSortQuerySkuName.contains(",")) {
                        String[] configPairs;
                        for (String pair : configPairs = searchSortQuerySkuName.split(",")) {
                            String[] keyValue = pair.split(":");
                            if (keyValue.length != 2) continue;
                            String fieldName = keyValue[0].trim();
                            try {
                                Field field2 = SearchStepRelevanceUtil.getDeclaredFieldRecursively(clazz, fieldName);
                                String fieldValue = field2.get(seQuerySkuBO).toString().toLowerCase();
                                String queryStr = searchSortMsgBo.getQueryStr().toLowerCase();
                                BigDecimal weight2 = new BigDecimal(keyValue[1].trim());
                                if (!fieldValue.contains(queryStr)) continue;
                                weightTotal = weightTotal.add(weight2);
                                ((List)weightDescAtomic.get()).add("[" + field2.getName() + "]:" + weight2);
                            }
                            catch (Exception e) {
                                ((List)weightDescAtomic.get()).add("[" + fieldName + "]:\u4e0d\u5b58\u5728");
                            }
                        }
                    } else {
                        String queryStr;
                        Field field3 = SearchStepRelevanceUtil.getDeclaredFieldRecursively(SeQuerySkuBO.class, ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortQuerySkuName);
                        String fieldValue = field3.get(seQuerySkuBO).toString().toLowerCase();
                        if (fieldValue.contains(queryStr = searchSortMsgBo.getQueryStr().toLowerCase())) {
                            weightTotal = weightTotal.add(new BigDecimal(1));
                            ((List)weightDescAtomic.get()).add("[" + field3.getName() + "]:" + 1.0);
                        }
                    }
                }
                if (isBrandMatchQuery && !isBrandExactMatch && StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getBrandName()) && seQuerySkuBO.getBrandName().contains(searchSortMsgBo.getQueryStr())) {
                    weightTotal = weightTotal.add(new BigDecimal(1));
                    ((List)weightDescAtomic.get()).add("[\u54c1\u724c\u6a21\u7cca\u5339\u914d]:1.0");
                }
                if (isVenderMatchQuery && !isVendorExactMatch && StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getSupplierName()) && seQuerySkuBO.getSupplierName().contains(searchSortMsgBo.getQueryStr())) {
                    weightTotal = weightTotal.add(new BigDecimal(1));
                    ((List)weightDescAtomic.get()).add("[\u4f9b\u5e94\u5546\u6a21\u7cca\u5339\u914d]:1.0");
                }
                seQuerySkuBO.setWeightDesc(String.join((CharSequence)" , ", weightDescAtomic.get()));
                seQuerySkuBO.setWeight(Double.valueOf(weightTotal.doubleValue()));
            } else {
                seQuerySkuBO.setWeightDesc("\u4e0d\u8ba1\u7b97\u6743\u503c\uff01");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6743\u503c\u8ba1\u7b97\uff01", e});
            throw new SearchSortException("9999", "\u6743\u503c\u8ba1\u7b97\uff01", (Throwable)e);
        }
    }
}

