/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps.utils;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class SearchStepRelevanceUtil {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceUtil.class);

    public static Map<String, List> correlationStringPackagingMap(SeQuerySkuBO seQuerySkuBO, Set<String> fields, Class<SeQuerySkuBO> clazz) {
        HashMap<String, List> result = new HashMap<String, List>();
        try {
            for (String fieldName : fields) {
                List<Object> values;
                if (fieldName.startsWith("$")) continue;
                Field field = null;
                try {
                    field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(clazz, fieldName);
                }
                catch (Exception ignored) {
                    continue;
                }
                Type type = field.getGenericType();
                String pattern = "java.util.List<.*>";
                boolean isMatch = Pattern.matches(pattern, type.getTypeName());
                if (isMatch) {
                    values = (List)field.get(seQuerySkuBO);
                    if (CollectionUtils.isEmpty(values)) {
                        result.put(fieldName, new ArrayList());
                        continue;
                    }
                    result.put(fieldName, values);
                    continue;
                }
                values = new ArrayList();
                Object value = field.get(seQuerySkuBO);
                if (!ObjectUtils.isEmpty((Object)value)) {
                    values.add(value);
                }
                result.put(fieldName, values);
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u52a8\u6001\u5b57\u6bb5\u503c\u63d0\u524d\u9519\u8bef\uff01", e});
            throw new SearchSortException("9999", "\u52a8\u6001\u5b57\u6bb5\u503c\u63d0\u524d\u9519\u8bef\uff01", (Throwable)e);
        }
        return result;
    }

    public static void correlationStringPackaging(SeQuerySkuBO seQuerySkuBO, String[] fields, Class<SeQuerySkuBO> clazz, StringBuilder stringBuilder) {
        try {
            for (String fieldName : fields) {
                if (fieldName.startsWith("$")) continue;
                String pattern = "java.util.List<.*>";
                Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(clazz, fieldName);
                Type type = field.getGenericType();
                boolean isMatch = Pattern.matches(pattern, type.getTypeName());
                if (isMatch) {
                    List value = (List)field.get(seQuerySkuBO);
                    StringBuilder sb = new StringBuilder();
                    if (!ObjectUtils.isEmpty((Object)value)) {
                        value.forEach(element -> sb.append(String.valueOf(element)));
                    }
                    stringBuilder.append(ObjectUtils.isEmpty((Object)value) ? "" : sb.toString() + ",");
                    continue;
                }
                stringBuilder.append(ObjectUtils.isEmpty((Object)field.get(seQuerySkuBO)) ? "" : field.get(seQuerySkuBO) + ",");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5c5e\u6027\u9519\u8bef\uff01", e});
            throw new SearchSortException("9999", "\u5c5e\u6027\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static boolean checkNotExistChinese(String name) {
        char n = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            n = name.charAt(i);
            if ('\u4e00' > n || n >= '\u9fa5') continue;
            return false;
        }
        return true;
    }

    public static boolean doesFieldExist(Class<?> clazz, String fieldName) {
        while (clazz != null && clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return true;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public static Field getDeclaredFieldRecursively(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return SearchStepRelevanceUtil.getDeclaredFieldRecursively(superClass, fieldName);
            }
            throw e;
        }
    }

    public static Method getDeclaredMethodRecursively(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return SearchStepRelevanceUtil.getDeclaredMethodRecursively(superClass, methodName, parameterTypes);
            }
            throw e;
        }
    }
}

