/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcBillAttachmentBO;
import com.tydic.smc.ability.bo.SmcBillDetailSkuBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryDetailAbilityReqBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryDetailAbilityRspBO;
import com.tydic.smc.dao.AccessoryMapper;
import com.tydic.smc.dao.BillDetailInfoMapper;
import com.tydic.smc.dao.BillExtendInfoMapper;
import com.tydic.smc.dao.StockChangeObjectMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.AccessoryPO;
import com.tydic.smc.po.BillExtendInfoPO;
import com.tydic.smc.po.StockChangeObjectPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.busi.SmcInStoreBillQryDetailBusiService;
import com.tydic.smc.service.busi.bo.BillDetailInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcInStoreBillQryDetailBusiServiceImpl
implements SmcInStoreBillQryDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcInStoreBillQryDetailBusiServiceImpl.class);
    @Autowired
    private StockChangeObjectMapper stockChangeObjectMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private BillExtendInfoMapper billExtendInfoMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;

    @Override
    public SmcInStoreBillQryDetailAbilityRspBO qrySmcInStoreBillDetail(SmcInStoreBillQryDetailAbilityReqBO reqBO) {
        SmcBillDetailSkuBO bo;
        log.info("\u5165\u5e93\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO.toString());
        SmcInStoreBillQryDetailAbilityRspBO rspBO = new SmcInStoreBillQryDetailAbilityRspBO();
        StockChangeObjectPO stockChangeObjectPO = new StockChangeObjectPO();
        stockChangeObjectPO.setObjectId(reqBO.getObjectId());
        stockChangeObjectPO.setStorehouseId(reqBO.getStorehouseId());
        StockChangeObjectPO stockChangeObject = this.stockChangeObjectMapper.getModelBy(stockChangeObjectPO);
        if (stockChangeObject == null) {
            throw new SmcBusinessException("18001", "\u5355\u636e[" + reqBO.getObjectId() + "]\u4e0d\u5b58\u5728");
        }
        this.dealStockChangeObjectResult(stockChangeObject, rspBO);
        BillExtendInfoPO billExtendInfoPO = new BillExtendInfoPO();
        billExtendInfoPO.setObjectId(reqBO.getObjectId());
        billExtendInfoPO.setStorehouseId(reqBO.getStorehouseId());
        BillExtendInfoPO billExtendInfo = this.billExtendInfoMapper.getModelBy(billExtendInfoPO);
        if (billExtendInfo != null) {
            this.dealBillExtendInfoResult(billExtendInfo, rspBO);
        }
        BillDetailInfoBO billDetailInfoBO = new BillDetailInfoBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        billDetailInfoBO.setObjectId(reqBO.getObjectId());
        billDetailInfoBO.setStorehouseId(reqBO.getStorehouseId());
        List billDetailInfoBOList = this.billDetailInfoMapper.getSkuGroupBySku(billDetailInfoBO, page);
        if (billDetailInfoBOList != null) {
            ArrayList<SmcBillDetailSkuBO> smcBillDetailSkuBOList = new ArrayList<SmcBillDetailSkuBO>();
            BigDecimal totalNum = BigDecimal.ZERO;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (BillDetailInfoBO billDetailInfo : billDetailInfoBOList) {
                bo = new SmcBillDetailSkuBO();
                bo.setSkuId(billDetailInfo.getSkuId().toString());
                bo.setMaterialCode("\u7269\u6599\u7f16\u7801");
                bo.setSkuName("\u5546\u54c1\u540d\u79f0");
                bo.setSkuNum(billDetailInfo.getSkuNum());
                bo.setUnitPrice(new BigDecimal(12));
                BigDecimal price = bo.getUnitPrice().multiply(new BigDecimal(bo.getSkuNum()));
                bo.setPrice(price.setScale(2, 4));
                bo.setConfigur("\u914d\u7f6e");
                bo.setRemark("\u5907\u6ce8");
                if ("02".equals(rspBO.getObjectType())) {
                    bo.setImsi(billDetailInfo.getImsiStr());
                    bo.setScanImsi(billDetailInfo.getImsiStr());
                } else {
                    bo.setImsi(billDetailInfo.getImsiStr());
                }
                smcBillDetailSkuBOList.add(bo);
                totalNum = totalNum.add(new BigDecimal(bo.getSkuNum()));
                totalPrice = totalPrice.add(bo.getPrice());
            }
            rspBO.setTotalNum(Integer.valueOf(totalNum.intValue()));
            rspBO.setTotalPrice(totalPrice);
            rspBO.setRows(smcBillDetailSkuBOList);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        }
        AccessoryPO accessoryPO = new AccessoryPO();
        accessoryPO.setObjectId(reqBO.getObjectId());
        List accessoryPOS = this.accessoryMapper.getList(accessoryPO);
        if (accessoryPOS != null) {
            ArrayList<SmcBillDetailSkuBO> attachmentBOList = new ArrayList<SmcBillDetailSkuBO>();
            for (AccessoryPO po : accessoryPOS) {
                bo = new SmcBillAttachmentBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                attachmentBOList.add(bo);
            }
            rspBO.setBillAttachmentList(attachmentBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealStockChangeObjectResult(StockChangeObjectPO po, SmcInStoreBillQryDetailAbilityRspBO rspBO) {
        StockhouseInfoPO result;
        StockhouseInfoPO house;
        rspBO.setObjectId(po.getObjectId().toString());
        rspBO.setObjectType(po.getObjectType());
        rspBO.setCreateName(po.getCreateOperName());
        rspBO.setCreateNo(po.getCreateOperId() + "");
        rspBO.setHandObjectId(po.getHandObjectId());
        rspBO.setCreateTime(DateUtils.dateToStr((Date)po.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (po.getInStoreNo() != null) {
            rspBO.setInStoreNo(po.getInStoreNo().toString());
            house = new StockhouseInfoPO();
            house.setStorehouseId(po.getInStoreNo());
            result = this.stockhouseInfoMapper.getModelBy(house);
            if (result != null) {
                rspBO.setInStoreName(result.getStorehouseName());
            }
        }
        if (po.getOutStoreNo() != null) {
            rspBO.setOutStoreNo(po.getOutStoreNo().toString());
            house = new StockhouseInfoPO();
            house.setStorehouseId(po.getOutStoreNo());
            result = this.stockhouseInfoMapper.getModelBy(house);
            if (result != null) {
                rspBO.setOutStoreName(result.getStorehouseName());
            }
        }
        rspBO.setRemark(po.getRemark());
        rspBO.setStatus(po.getObjectState());
        String statusStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("OBJECT_STATUS", po.getObjectState());
        rspBO.setStatusStr(statusStr);
        if (po.getRelativeObjectId() != null) {
            rspBO.setRelativeObjectId(po.getRelativeObjectId().toString());
        }
    }

    private void dealBillExtendInfoResult(BillExtendInfoPO po, SmcInStoreBillQryDetailAbilityRspBO rspBO) {
        rspBO.setSupplierId(po.getSupplierId());
        rspBO.setBusiType(po.getBusiType());
        rspBO.setCashFlag(po.getCashFlag());
        if (po.getSupplierId() != null) {
            rspBO.setSupplierName("\u4f9b\u5e94\u5546\u540d\u79f0\u63a5\u53e3\u67e5\u8be2\u5176\u540d\u79f0");
        }
        String busiTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("BUSI_TYPE", po.getBusiType());
        rspBO.setBusiTypeStr(busiTypeStr);
        String cashFlagStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("IF_FLAG", po.getCashFlag());
        rspBO.setCashFlagStr(cashFlagStr);
    }
}

