/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcInStoreBillQryListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryListAbilityRspBO;
import com.tydic.smc.ability.bo.StockBillObjectBO;
import com.tydic.smc.dao.StockChangeObjectMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.po.StockChangeObjectPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.busi.SmcInStoreBillQryListBusiService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcInStoreBillQryListBusiServiceImpl
implements SmcInStoreBillQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcInStoreBillQryListBusiServiceImpl.class);
    @Autowired
    private StockChangeObjectMapper stockChangeObjectMapper;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;

    @Override
    public SmcInStoreBillQryListAbilityRspBO qryInStoreBillList(SmcInStoreBillQryListAbilityReqBO reqBO) {
        log.info("\u5165\u5e93\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2\u53c2\u6570\uff1a" + reqBO.toString());
        SmcInStoreBillQryListAbilityRspBO rspBO = new SmcInStoreBillQryListAbilityRspBO();
        ArrayList<StockBillObjectBO> stockBillObjectBOS = new ArrayList<StockBillObjectBO>();
        StockChangeObjectPO po = new StockChangeObjectPO();
        if (reqBO.getBeginDate() != null) {
            po.setBeginDate(DateUtils.strToDate((String)(reqBO.getBeginDate() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (reqBO.getEndDate() != null) {
            po.setEndDate(DateUtils.strToDate((String)(reqBO.getEndDate() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (reqBO.getInStoreNo() != null) {
            po.setInStoreNo(reqBO.getInStoreNo());
        }
        if (reqBO.getObjectType() != null) {
            po.setObjectType(reqBO.getObjectType());
        } else {
            ArrayList<String> objectTypeList = new ArrayList<String>();
            objectTypeList.add("02");
            objectTypeList.add("04");
            objectTypeList.add("03");
            po.setObjectTypeList(objectTypeList);
        }
        if (reqBO.getOutStoreNo() != null) {
            po.setOutStoreNo(reqBO.getOutStoreNo());
        }
        if (reqBO.getObjectId() != null) {
            po.setObjectId(reqBO.getObjectId());
        }
        if (reqBO.getRelativeObjectId() != null) {
            po.setRelativeObjectId(reqBO.getRelativeObjectId());
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List stockChangeObjectPOS = this.stockChangeObjectMapper.getListPage(po, page);
        for (StockChangeObjectPO stockChangeObjectPO : stockChangeObjectPOS) {
            StockhouseInfoPO resultPO;
            StockhouseInfoPO housePO;
            StockBillObjectBO stockBillObjectBO = new StockBillObjectBO();
            stockBillObjectBO.setObjectId(stockChangeObjectPO.getObjectId().toString());
            stockBillObjectBO.setObjectType(stockChangeObjectPO.getObjectType());
            String objectTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("OBJECT_TYPE", stockChangeObjectPO.getObjectType());
            stockBillObjectBO.setObjectTypeStr(objectTypeStr);
            stockBillObjectBO.setInStoreDate(DateUtils.dateToStr((Date)stockChangeObjectPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            if (stockChangeObjectPO.getInStoreNo() != null) {
                stockBillObjectBO.setInStoreNo(stockChangeObjectPO.getInStoreNo() + "");
                housePO = new StockhouseInfoPO();
                housePO.setStorehouseId(stockChangeObjectPO.getInStoreNo());
                resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
                if (resultPO != null) {
                    stockBillObjectBO.setInStoreName(resultPO.getStorehouseName());
                }
            }
            if (stockChangeObjectPO.getOutStoreNo() != null) {
                stockBillObjectBO.setOutStoreNo(stockChangeObjectPO.getOutStoreNo() + "");
                housePO = new StockhouseInfoPO();
                housePO.setStorehouseId(stockChangeObjectPO.getOutStoreNo());
                resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
                if (resultPO != null) {
                    stockBillObjectBO.setOutStoreName(resultPO.getStorehouseName());
                }
            }
            if (stockChangeObjectPO.getRelativeObjectId() != null) {
                stockBillObjectBO.setRelativeObjectId(stockChangeObjectPO.getRelativeObjectId().toString());
            }
            stockBillObjectBO.setCreateOperId(stockChangeObjectPO.getCreateOperId() + "");
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            stockBillObjectBOS.add(stockBillObjectBO);
        }
        rspBO.setRows(stockBillObjectBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

