/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.smc.common.bo.SmcPostRuleInfoBO;
import com.tydic.smc.dao.PostRuleMapper;
import com.tydic.smc.po.PostRulePO;
import com.tydic.smc.service.busi.SmcQryPostRuleListBusiService;
import com.tydic.smc.service.busi.bo.SmcQryPostRuleListBusiReqBO;
import com.tydic.smc.service.busi.bo.SmcQryPostRuleListBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmcQryPostRuleListBusiServiceImpl
implements SmcQryPostRuleListBusiService {
    private static final Integer NO_PAGE = -1;
    private static final Integer DEFAULT_SIZE = 1;
    private static final Integer DEFAULT_TOTAL = 0;
    @Autowired
    private PostRuleMapper postRuleMapper;

    @Override
    public SmcQryPostRuleListBusiRspBO qryPostRuleList(SmcQryPostRuleListBusiReqBO reqBO) {
        this.doSetPage(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        PostRulePO postRulePO = new PostRulePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)postRulePO);
        List postList = this.postRuleMapper.getListPage(postRulePO, page);
        SmcQryPostRuleListBusiRspBO rspBO = new SmcQryPostRuleListBusiRspBO();
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        if (NO_PAGE.equals(reqBO.getPageNo()) && NO_PAGE.equals(reqBO.getPageSize())) {
            rspBO.setTotal(DEFAULT_SIZE);
            rspBO.setRecordsTotal(CollectionUtils.isEmpty((Collection)postList) ? DEFAULT_TOTAL.intValue() : postList.size());
            rspBO.setPageNo(DEFAULT_SIZE);
        }
        if (CollectionUtils.isEmpty((Collection)postList)) {
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u90ae\u8d39\u89c4\u5219\u5217\u8868\u67e5\u8be2\u65e0\u8bb0\u5f55\uff01");
            return rspBO;
        }
        ArrayList<SmcPostRuleInfoBO> rows = new ArrayList<SmcPostRuleInfoBO>(postList.size());
        for (PostRulePO po : postList) {
            SmcPostRuleInfoBO bo = new SmcPostRuleInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rows.add(bo);
        }
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u90ae\u8d39\u89c4\u5219\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rspBO;
    }

    private void doSetPage(SmcQryPostRuleListBusiReqBO reqBO) {
        if (reqBO.getPageNo() == null) {
            reqBO.setPageNo(DEFAULT_SIZE);
        } else if (reqBO.getPageSize() == null) {
            reqBO.setPageNo(NO_PAGE);
            reqBO.setPageSize(NO_PAGE);
        }
    }
}

