/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.intf.utils;

import com.tydic.smc.intf.exception.SmcIntfBusinessException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static HttpClient client = null;

    public static String conn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout) {
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if (null == connectTimeout) {
            connectTimeout = 30000;
        }
        if (null == socketTimeout) {
            socketTimeout = 30000;
        }
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            int statusCode;
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(socketTimeout);
            conn.setDoOutput(true);
            if (null != header) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.setRequestProperty("Content-Type", "application/json; charset=" + charset);
            conn.connect();
            if (StringUtils.isNotBlank((CharSequence)content)) {
                out = new DataOutputStream(conn.getOutputStream());
                out.write(content.getBytes(charset));
                ((DataOutputStream)out).flush();
            }
            if (200 != (statusCode = conn.getResponseCode())) {
                Map.Entry<String, String> entry;
                entry = null;
                return entry;
            }
            is = conn.getInputStream();
            if (null != is) {
                String rspStr;
                int len;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                String string = rspStr = new String(outStream.toByteArray(), charset);
                return string;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new SmcIntfBusinessException("9999", e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SmcIntfBusinessException("9999", e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SmcIntfBusinessException("9999", e.getMessage());
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) {
        String jsonStr = null;
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpGet.getURI());
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpGet) {
                httpGet.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String param) {
        String jsonStr = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            if (null != param) {
                StringEntity entity = new StringEntity(param, "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
        return jsonStr;
    }

    static {
        if (null == client) {
            client = HttpClients.createDefault();
        }
    }
}

