/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.tydic.smc.common.bo.SmcShopPostageBO;
import com.tydic.smc.dao.PostRuleMapper;
import com.tydic.smc.po.PostRulePO;
import com.tydic.smc.service.busi.SmcCalculatePostageBusiService;
import com.tydic.smc.service.busi.bo.SmcCalculatePostageBusiReqBO;
import com.tydic.smc.service.busi.bo.SmcCalculatePostageBusiRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmcCalculatePostageBusiServiceImpl
implements SmcCalculatePostageBusiService {
    private static final Integer VALID_STATUS = 0;
    @Autowired
    private PostRuleMapper postRuleMapper;

    @Override
    public SmcCalculatePostageBusiRspBO dealCalculatePostage(SmcCalculatePostageBusiReqBO reqBO) {
        BigDecimal discountTotalFee = BigDecimal.ZERO;
        BigDecimal realTotalFreightFee = BigDecimal.ZERO;
        for (SmcShopPostageBO shopInfo : reqBO.getShopInfoList()) {
            SmcShopPostageBO smcShopPostageBO = new SmcShopPostageBO();
            smcShopPostageBO.setShopId(shopInfo.getShopId());
            smcShopPostageBO.setProvId(shopInfo.getProvId());
            smcShopPostageBO.setRegionId(shopInfo.getRegionId());
            BigDecimal baseFreightFee = BigDecimal.ZERO;
            BigDecimal remoteFreightFee = BigDecimal.ZERO;
            BigDecimal overweightFreightFee = BigDecimal.ZERO;
            BigDecimal discountFee = BigDecimal.ZERO;
            BigDecimal realFreightFee = BigDecimal.ZERO;
            PostRulePO postRulePO = new PostRulePO();
            postRulePO.setShopId(shopInfo.getShopId());
            postRulePO.setProvId(shopInfo.getProvId());
            postRulePO.setStatus(VALID_STATUS);
            List postRuleList = this.postRuleMapper.getList(postRulePO);
            if (!CollectionUtils.isEmpty((Collection)postRuleList)) {
                postRulePO = (PostRulePO)postRuleList.get(0);
                BeanUtils.copyProperties((Object)postRulePO, (Object)smcShopPostageBO);
                baseFreightFee = postRulePO.getBaseFreightFee();
                remoteFreightFee = postRulePO.getRemoteFreightFee();
                overweightFreightFee = postRulePO.getOverweightFreightFee();
                if (shopInfo.getPaymentFee().compareTo(postRulePO.getFreeFee()) == -1) {
                    realFreightFee = postRulePO.getBaseFreightFee();
                } else {
                    discountFee = postRulePO.getBaseFreightFee();
                }
            }
            discountTotalFee = discountTotalFee.add(discountFee);
            realTotalFreightFee = realTotalFreightFee.add(realFreightFee);
            smcShopPostageBO.setBaseFreightFee(baseFreightFee);
            smcShopPostageBO.setRemoteFreightFee(remoteFreightFee);
            smcShopPostageBO.setOverweightFreightFee(overweightFreightFee);
            smcShopPostageBO.setDiscountFee(discountFee);
            smcShopPostageBO.setRealFreightFee(realFreightFee);
            smcShopPostageBO.setPaymentFee(shopInfo.getPaymentFee());
        }
        SmcCalculatePostageBusiRspBO rspBO = new SmcCalculatePostageBusiRspBO();
        rspBO.setDiscountTotalFee(discountTotalFee);
        rspBO.setRealTotalFreightFee(realTotalFreightFee);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u90ae\u8d39\u8ba1\u7b97\u6210\u529f\uff01");
        return rspBO;
    }
}

