/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcBillAttachmentBO;
import com.tydic.smc.ability.bo.SmcBillDetailSkuBO;
import com.tydic.smc.ability.bo.SmcQryOutStockDetailAbilityReqBO;
import com.tydic.smc.ability.bo.SmcQryOutStockDetailAbilityRspBO;
import com.tydic.smc.api.common.bo.SmcBillReparationBO;
import com.tydic.smc.dao.BillDetailInfoMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.BillDetailInfoPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.atom.SmcQryObjByIdAndHouseIdAtomService;
import com.tydic.smc.service.atom.bo.SmcQryObjByIdAndHouseIdAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryObjByIdAndHouseIdAtomRspBO;
import com.tydic.smc.service.busi.SmcQryOutStockDetailBusiService;
import com.tydic.smc.service.busi.bo.AccessoryBO;
import com.tydic.smc.service.busi.bo.BillExtendInfoBO;
import com.tydic.smc.service.busi.bo.BillLogisticsInfoBO;
import com.tydic.smc.service.busi.bo.BillReparationInfoBO;
import com.tydic.smc.service.busi.bo.StockChangeObjectBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcQryOutStockDetailBusiServiceImpl
implements SmcQryOutStockDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcQryOutStockDetailBusiServiceImpl.class);
    @Autowired
    private SmcQryObjByIdAndHouseIdAtomService smcQryObjByIdAndHouseIdAtomService;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;

    @Override
    public SmcQryOutStockDetailAbilityRspBO qryOutStockDetail(SmcQryOutStockDetailAbilityReqBO reqBO) {
        SmcQryOutStockDetailAbilityRspBO rspBO = new SmcQryOutStockDetailAbilityRspBO();
        SmcQryObjByIdAndHouseIdAtomReqBO smcQryObjByIdAndHouseIdAtomReqBO = new SmcQryObjByIdAndHouseIdAtomReqBO();
        smcQryObjByIdAndHouseIdAtomReqBO.setObjectId(reqBO.getObjectId());
        smcQryObjByIdAndHouseIdAtomReqBO.setStorehouseId(reqBO.getStorehouseId());
        SmcQryObjByIdAndHouseIdAtomRspBO detailRspBO = this.smcQryObjByIdAndHouseIdAtomService.qryBillByObjectId(smcQryObjByIdAndHouseIdAtomReqBO);
        if (detailRspBO != null && !"0000".equals(detailRspBO.getRespCode())) {
            throw new SmcBusinessException(detailRspBO.getRespCode(), detailRspBO.getRespDesc());
        }
        StockChangeObjectBO stockChangeObjectBO = detailRspBO.getStockChangeObjectBO();
        rspBO.setObjectType(stockChangeObjectBO.getObjectType());
        rspBO.setObjectId(stockChangeObjectBO.getObjectId() + "");
        rspBO.setCreateNo(stockChangeObjectBO.getCreateOperId() + "");
        rspBO.setCreateName(stockChangeObjectBO.getCreateOperName());
        rspBO.setCreateTime(DateUtils.dateToStr((Date)stockChangeObjectBO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (stockChangeObjectBO.getInStoreNo() != null) {
            rspBO.setInStoreNo(stockChangeObjectBO.getInStoreNo() + "");
            rspBO.setInStoreName(this.qryStorehouseName(stockChangeObjectBO.getInStoreNo()));
        }
        if (stockChangeObjectBO.getOutStoreNo() != null) {
            rspBO.setOutStoreNo(stockChangeObjectBO.getOutStoreNo() + "");
            rspBO.setOutStoreName(this.qryStorehouseName(stockChangeObjectBO.getOutStoreNo()));
        }
        rspBO.setHandObjectId(stockChangeObjectBO.getHandObjectId());
        rspBO.setRemark(stockChangeObjectBO.getRemark());
        rspBO.setStatus(stockChangeObjectBO.getObjectState());
        String statusStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("OBJECT_STATUS", stockChangeObjectBO.getObjectState());
        rspBO.setStatusStr(statusStr);
        rspBO.setMoveInOperId(stockChangeObjectBO.getUpdateOperId() + "");
        rspBO.setMoveInOperName(stockChangeObjectBO.getUpdateOperName());
        rspBO.setMoveInTime(DateUtils.dateToStr((Date)stockChangeObjectBO.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        BillExtendInfoBO billExtendInfoBO = detailRspBO.getBillExtendInfoBO();
        rspBO.setMoveType(billExtendInfoBO.getMoveType());
        String moveTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("MOVE_TYPE", billExtendInfoBO.getMoveType());
        rspBO.setMoveTypeDesc(moveTypeStr);
        rspBO.setAllocateType(billExtendInfoBO.getAllocateType());
        String allocateTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("ALLOCATE_TYPE", billExtendInfoBO.getAllocateType());
        rspBO.setAllocateTypeDesc(allocateTypeStr);
        if (billExtendInfoBO.getCustomerId() != null) {
            rspBO.setCustomerId(billExtendInfoBO.getCustomerId());
        }
        rspBO.setCustomerName("\u5ba2\u62371111");
        if (billExtendInfoBO.getBusiStaff() != null) {
            rspBO.setBusiStaffId(billExtendInfoBO.getBusiStaff());
        }
        rspBO.setBusiStaffName("\u4e1a\u52a1\u54581133");
        if (detailRspBO.getBillLogisticsInfoBO() != null) {
            BillLogisticsInfoBO billLogisticsInfoBO = detailRspBO.getBillLogisticsInfoBO();
            rspBO.setWeight(billLogisticsInfoBO.getWeight());
            rspBO.setTransFee(billLogisticsInfoBO.getTransFee());
            rspBO.setLogisCompanyId(billLogisticsInfoBO.getLogisCompany());
            rspBO.setLogisCompanyName("\u7269\u6d41\u516c\u53f8\u540d\u79f0\u8f6c\u4e49");
            rspBO.setExpressNo(billLogisticsInfoBO.getExpressNo());
            rspBO.setInsurePrice(billLogisticsInfoBO.getInsurePrice());
        }
        if (detailRspBO.getBillReparationInfoBO() != null) {
            ArrayList<SmcBillReparationBO> smcBillReparationBOList = new ArrayList<SmcBillReparationBO>();
            List billReparationInfoBOList = detailRspBO.getBillReparationInfoBO();
            BigDecimal totalReparationMoney = BigDecimal.ZERO;
            for (BillReparationInfoBO bo : billReparationInfoBOList) {
                SmcBillReparationBO smcBillReparationBO = new SmcBillReparationBO();
                smcBillReparationBO.setCashFlag(bo.getCashFlag());
                smcBillReparationBO.setReparationMoney(bo.getReparationMoney());
                smcBillReparationBO.setReparationRemark(bo.getReparationRemark());
                String reparationTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("REPARATION_TYPE", bo.getReparationType());
                smcBillReparationBO.setReparationType(reparationTypeStr);
                smcBillReparationBOList.add(smcBillReparationBO);
                totalReparationMoney = totalReparationMoney.add(bo.getReparationMoney());
            }
            rspBO.setTotalReparationMoney(totalReparationMoney);
            rspBO.setReparationList(smcBillReparationBOList);
        }
        BillDetailInfoPO billDetailInfoPO = new BillDetailInfoPO();
        billDetailInfoPO.setObjectId(reqBO.getObjectId());
        billDetailInfoPO.setStorehouseId(reqBO.getStorehouseId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List billDetailInfoPOList = this.billDetailInfoMapper.getListPage(billDetailInfoPO, page);
        if (billDetailInfoPOList != null) {
            ArrayList<SmcBillDetailSkuBO> smcBillDetailSkuBOList = new ArrayList<SmcBillDetailSkuBO>();
            BigDecimal totalNum = BigDecimal.ZERO;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (BillDetailInfoPO bo : billDetailInfoPOList) {
                SmcBillDetailSkuBO smcBillDetailSkuBO = new SmcBillDetailSkuBO();
                smcBillDetailSkuBO.setSkuId(bo.getSkuId() + "");
                smcBillDetailSkuBO.setMaterialCode("\u7269\u6599\u7f16\u7801");
                smcBillDetailSkuBO.setSkuName("\u5546\u54c1\u540d\u79f0");
                smcBillDetailSkuBO.setSkuNum(Integer.valueOf(bo.getBillDetailNum().intValue()));
                smcBillDetailSkuBO.setUnitPrice(new BigDecimal(12));
                BigDecimal price = new BigDecimal(2).multiply(new BigDecimal(bo.getBillDetailNum()));
                smcBillDetailSkuBO.setPrice(price.setScale(2, 4));
                smcBillDetailSkuBO.setConfigur("\u914d\u7f6e");
                smcBillDetailSkuBO.setRemark("\u5907\u6ce8");
                smcBillDetailSkuBO.setImsi(bo.getImsi());
                smcBillDetailSkuBOList.add(smcBillDetailSkuBO);
                totalNum = totalNum.add(new BigDecimal(bo.getBillDetailNum()));
                totalPrice = totalPrice.add(price);
            }
            rspBO.setTotalNum(Integer.valueOf(totalNum.intValue()));
            rspBO.setTotalPrice(totalPrice);
            rspBO.setRows(smcBillDetailSkuBOList);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        }
        if (detailRspBO.getAccessoryBOList() != null) {
            ArrayList<SmcBillAttachmentBO> smcBillAttachmentBOS = new ArrayList<SmcBillAttachmentBO>();
            for (AccessoryBO bo : detailRspBO.getAccessoryBOList()) {
                SmcBillAttachmentBO smcBillAttachmentBO = new SmcBillAttachmentBO();
                smcBillAttachmentBO.setAccessoryName(bo.getAccessoryName());
                smcBillAttachmentBO.setAccessoryUrl(bo.getAccessoryUrl());
                smcBillAttachmentBOS.add(smcBillAttachmentBO);
            }
            rspBO.setBillAttachmentList(smcBillAttachmentBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }
}

