/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityRspBO;
import com.tydic.smc.ability.bo.StockSkuBO;
import com.tydic.smc.api.common.bo.SmcStockhouseInfoBO;
import com.tydic.smc.dao.StockInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.service.atom.SmcQryStockhouseListByShopAtomService;
import com.tydic.smc.service.atom.bo.SmcQryStockhouseListByShopAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryStockhouseListByShopAtomRspBO;
import com.tydic.smc.service.busi.SmcStoreSkuQryListBusiService;
import com.tydic.smc.service.busi.bo.StockInfoBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcStoreSkuQryListBusiServiceImpl
implements SmcStoreSkuQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcStoreSkuQryListBusiServiceImpl.class);
    @Autowired
    private StockInfoMapper stockInfoMapper;
    @Autowired
    private SmcQryStockhouseListByShopAtomService smcQryStockhouseListByShopAtomService;

    @Override
    public SmcStoreSkuQryListAbilityRspBO qryStoreSkuList(SmcStoreSkuQryListAbilityReqBO reqBO) {
        SmcStoreSkuQryListAbilityRspBO rspBO = new SmcStoreSkuQryListAbilityRspBO();
        ArrayList<StockSkuBO> stockSkuBOList = new ArrayList<StockSkuBO>();
        ArrayList<Long> storehouseIdList = new ArrayList<Long>();
        if (reqBO.getShopId() != null || reqBO.getStorehouseId() == null) {
            // empty if block
        }
        if (reqBO.getShopId() != null) {
            SmcQryStockhouseListByShopAtomReqBO qryReqBO = new SmcQryStockhouseListByShopAtomReqBO();
            ArrayList<Long> shopIdList = new ArrayList<Long>();
            shopIdList.add(reqBO.getShopId());
            qryReqBO.setShopIdList(shopIdList);
            SmcQryStockhouseListByShopAtomRspBO qryRspBO = this.smcQryStockhouseListByShopAtomService.qryStockhouseListByShop(qryReqBO);
            if (qryRspBO != null && !"0000".equals(qryRspBO.getRespCode())) {
                throw new SmcBusinessException(qryRspBO.getRespCode(), qryRspBO.getRespDesc());
            }
            Map storehouseMap = qryRspBO.getShopIdStockhouseListMap();
            ArrayList<Long> storehouseList = new ArrayList<Long>();
            if (storehouseMap != null) {
                for (Long key : storehouseMap.keySet()) {
                    List smcStockhouseInfoBOList = (List)storehouseMap.get(key);
                    for (SmcStockhouseInfoBO bo : smcStockhouseInfoBOList) {
                        storehouseList.add(bo.getStorehouseId());
                    }
                }
            }
        }
        StockInfoBO stockInfoBO = new StockInfoBO();
        if (reqBO.getImsi() != null) {
            stockInfoBO.setImsi(reqBO.getImsi());
        }
        if (reqBO.getMaterialCode() != null) {
            stockInfoBO.setMaterialCode(reqBO.getMaterialCode());
        }
        if (reqBO.getStorehouseId() != null) {
            storehouseIdList.add(reqBO.getStorehouseId());
        }
        if (storehouseIdList.size() > 0) {
            stockInfoBO.setStorehouseList(storehouseIdList);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List stockInfoBOList = null;
        stockInfoBOList = stockInfoBO.getImsi() != null ? this.stockInfoMapper.qryStoreListPageByImsiCond(stockInfoBO, page) : this.stockInfoMapper.qryStoreListPageByCond(stockInfoBO, page);
        if (stockInfoBOList != null) {
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (stockInfoBOList.size() > 0) {
                for (StockInfoBO bo : stockInfoBOList) {
                    StockSkuBO stockSkuBO = new StockSkuBO();
                    stockSkuBO.setSkuId(bo.getSkuId());
                    Long totalNum = bo.getErrorTotalNum() + bo.getTransTotalNum() + bo.getSaledTotalNum() + bo.getUnsaleTotalNum() + bo.getTransTotalNum();
                    stockSkuBO.setTotalNum(totalNum);
                    stockSkuBO.setSaleNum(bo.getSaledTotalNum());
                    stockSkuBO.setRemainNum(bo.getUnsaleTotalNum());
                    stockSkuBOList.add(stockSkuBO);
                    skuList.add(bo.getSkuId());
                }
            }
        }
        rspBO.setRows(stockSkuBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

