/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.smc.ability.SmcExtBatchImportOutStockAbilityService;
import com.tydic.smc.ability.bo.SmcExtBatchImportOutStockReqBO;
import com.tydic.smc.ability.bo.SmcExtBatchImportOutStockRspBO;
import com.tydic.smc.ability.bo.SmcGetOutStockTempReqBO;
import com.tydic.smc.ability.bo.SmcGetOutStockTempRspBO;
import com.tydic.smc.api.ability.bo.SmcOutStoreBillAddAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcOutStoreBillAddAbilityRspBO;
import com.tydic.smc.api.common.bo.SmcBillSkuBO;
import com.tydic.smc.common.bo.SmcExtImportOutStockInfoBO;
import com.tydic.smc.dao.StockInstanceMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.StockInstancePO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.busi.SmcOutStoreBillAddBusiService;
import com.tydic.smc.util.ExcelUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="XLS_UAT", serviceInterface=SmcExtBatchImportOutStockAbilityService.class)
public class SmcExtBatchImportOutStockAbilityServiceImpl
implements SmcExtBatchImportOutStockAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SmcExtBatchImportOutStockAbilityServiceImpl.class);
    @Value(value="${resfile.smc.outbound.path:}")
    private String filePath;
    @Value(value="${config.smc.import.outstock.temp.url:}")
    private String importOutStockTmpUrl;
    private static final boolean NOT_DECIMAL = false;
    private static final boolean DECIMAL = true;
    private static final String DECIMAL_PATTERN = "^[0-9]+([.][0-9]+)?$";
    private static final String NUM_PATTERN = "^[1-9]\\d*$";
    private static final Map<String, String> ALLOCATE_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("\u95e8\u5e97\u8c03\u62e8", "01");
            this.put(SmcExtBatchImportOutStockAbilityServiceImpl.DELIVERY, "02");
            this.put("\u81ea\u5907\u8f66", "03");
            this.put("\u81ea\u63d0", "04");
        }
    };
    private static final String DELIVERY = "\u914d\u9001";
    @Autowired
    private SmcOutStoreBillAddBusiService smcOutStoreBillAddBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private StockInstanceMapper stockInstanceMapper;

    public SmcExtBatchImportOutStockRspBO dealImportOutStock(SmcExtBatchImportOutStockReqBO reqBO) {
        ArrayList<SmcExtImportOutStockInfoBO> failedRows;
        List<SmcExtImportOutStockInfoBO> rowsBeforeGrouped;
        this.doCheck(reqBO);
        File file = this.downloadFile(reqBO.getFileName());
        if (file != null) {
            log.info("\u6279\u91cf\u5bfc\u5165\u6253\u5370\u6587\u4ef6\u540d\uff1a" + file.getAbsolutePath() + "::" + file.getName());
        }
        if (CollectionUtils.isEmpty(rowsBeforeGrouped = this.doParseFile(file, failedRows = new ArrayList<SmcExtImportOutStockInfoBO>()))) {
            SmcExtBatchImportOutStockRspBO rspBO = new SmcExtBatchImportOutStockRspBO();
            rspBO.setFailedRows(failedRows);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5904\u7406\u5931\u8d25\uff01");
            return rspBO;
        }
        Map<String, List<SmcExtImportOutStockInfoBO>> groupMap = this.doGroup(rowsBeforeGrouped);
        return this.doOutStock(groupMap, reqBO, failedRows);
    }

    public SmcGetOutStockTempRspBO getImportOutStockTmp(SmcGetOutStockTempReqBO reqBO) {
        SmcGetOutStockTempRspBO rspBO = new SmcGetOutStockTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u83b7\u53d6\u6210\u529f");
        if (StringUtils.isEmpty((Object)this.importOutStockTmpUrl)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        rspBO.setTempUrl(this.importOutStockTmpUrl);
        return rspBO;
    }

    private SmcExtBatchImportOutStockRspBO doOutStock(Map<String, List<SmcExtImportOutStockInfoBO>> groupMap, SmcExtBatchImportOutStockReqBO reqBO, List<SmcExtImportOutStockInfoBO> failedRows) {
        SmcExtBatchImportOutStockRspBO rspBO = new SmcExtBatchImportOutStockRspBO();
        int[] totalNum = new int[]{failedRows.size()};
        groupMap.forEach((key, value) -> {
            totalNum[0] = totalNum[0] + value.size();
            SmcOutStoreBillAddAbilityReqBO outReqBO = new SmcOutStoreBillAddAbilityReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)outReqBO);
            StockhouseInfoPO outStockhouseInfoPO = this.getStockhouse(reqBO, ((SmcExtImportOutStockInfoBO)value.get(0)).getOutStoreName());
            if (outStockhouseInfoPO == null) {
                value.forEach(row -> {
                    String failedMsg = "\u7b2c" + row.getRowNum() + "\u884c\u6839\u636e\u79fb\u51fa\u4ed3\u5e93\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f";
                    row.setFailedDesc(failedMsg);
                });
                failedRows.addAll((Collection<SmcExtImportOutStockInfoBO>)value);
                return;
            }
            StockhouseInfoPO inStockhouseInfoPO = this.getStockhouse(reqBO, ((SmcExtImportOutStockInfoBO)value.get(0)).getInStoreName());
            if (inStockhouseInfoPO == null) {
                value.forEach(row -> {
                    String failedMsg = "\u7b2c" + row.getRowNum() + "\u884c\u6839\u636e\u79fb\u5165\u4ed3\u5e93\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f";
                    row.setFailedDesc(failedMsg);
                });
                failedRows.addAll((Collection<SmcExtImportOutStockInfoBO>)value);
                return;
            }
            Long inStoreNo = inStockhouseInfoPO.getStorehouseId();
            Long outStoreNo = outStockhouseInfoPO.getStorehouseId();
            ArrayList<SmcBillSkuBO> skuList = new ArrayList<SmcBillSkuBO>(value.size());
            for (SmcExtImportOutStockInfoBO row2 : value) {
                SmcBillSkuBO skuBO = new SmcBillSkuBO();
                skuBO.setImsi(row2.getImsi());
                skuBO.setMaterialCode(row2.getMaterialCode());
                skuBO.setBillDetailNum(Long.valueOf(row2.getBillDetailNum()));
                Long skuId = null;
                StockInstancePO stockInstancePO = new StockInstancePO();
                stockInstancePO.setStorehouseId(outStoreNo);
                stockInstancePO.setImsi(row2.getImsi());
                stockInstancePO.setMaterialCode(row2.getMaterialCode());
                stockInstancePO.setStatus("01");
                stockInstancePO.setSaleFlag("1");
                List instanceList = this.stockInstanceMapper.getList(stockInstancePO);
                if (CollectionUtils.isEmpty((Collection)instanceList)) {
                    String failedMsg = "\u7b2c" + row2.getRowNum() + "\u884c\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u4e0d\u5230sku\u5546\u54c1\u4fe1\u606f";
                    row2.setFailedDesc(failedMsg);
                    failedRows.add(row2);
                    continue;
                }
                skuId = ((StockInstancePO)instanceList.get(0)).getSkuId();
                skuBO.setSkuId(skuId);
                skuList.add(skuBO);
            }
            outReqBO.setOutStoreNo(outStoreNo);
            outReqBO.setInStoreNo(inStoreNo);
            outReqBO.setStorehouseId(outStoreNo);
            outReqBO.setObjectType("06");
            outReqBO.setAllocateType(ALLOCATE_TYPE_MAP.get(((SmcExtImportOutStockInfoBO)value.get(0)).getAllocateTypeDesc()));
            outReqBO.setMoveType("01");
            outReqBO.setExpressNo(((SmcExtImportOutStockInfoBO)value.get(0)).getExpressNo());
            outReqBO.setLogisCompany(((SmcExtImportOutStockInfoBO)value.get(0)).getLogisCompany());
            outReqBO.setWeight(StringUtils.isEmpty((Object)((SmcExtImportOutStockInfoBO)value.get(0)).getWeight()) ? BigDecimal.ZERO : new BigDecimal(((SmcExtImportOutStockInfoBO)value.get(0)).getWeight()));
            outReqBO.setTransFee(StringUtils.isEmpty((Object)((SmcExtImportOutStockInfoBO)value.get(0)).getTransFee()) ? BigDecimal.ZERO : new BigDecimal(((SmcExtImportOutStockInfoBO)value.get(0)).getTransFee()));
            outReqBO.setRemark(((SmcExtImportOutStockInfoBO)value.get(0)).getHeadRemark());
            outReqBO.setSkuList(skuList);
            SmcOutStoreBillAddAbilityRspBO outRspBO = this.smcOutStoreBillAddBusiService.addOutStoreBill(outReqBO);
            if (!"0000".equals(outRspBO.getRespCode())) {
                value.forEach(row -> {
                    StringBuilder builder = new StringBuilder("\u7b2c" + row.getRowNum() + "\u884c\u8c03\u7528\u51fa\u5e93\u670d\u52a1\u5931\u8d25\uff0c\u5177\u4f53\u5931\u8d25\u63cf\u8ff0\u662f\uff1a");
                    row.setFailedDesc(builder.append(outRspBO.getRespDesc()).toString());
                });
                failedRows.addAll((Collection<SmcExtImportOutStockInfoBO>)value);
                return;
            }
        });
        int totalFailedNum = failedRows.size();
        int totalSuccessedNum = totalNum[0] - totalFailedNum;
        rspBO.setFailedRows(failedRows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u603b\u5171[" + totalNum[0] + "]\u6761\u8bb0\u5f55\uff0c\u5176\u4e2d[" + totalSuccessedNum + "]\u6761\u6210\u529f\uff0c[" + totalFailedNum + "]\u6761\u5931\u8d25");
        return rspBO;
    }

    private StockhouseInfoPO getStockhouse(SmcExtBatchImportOutStockReqBO reqBO, String storehouseName) {
        StockhouseInfoPO stockhouseInfoPO = new StockhouseInfoPO();
        stockhouseInfoPO.setProvId(reqBO.getmProvince());
        stockhouseInfoPO.setCityId(reqBO.getmCity());
        stockhouseInfoPO.setCountyId(reqBO.getmDistrict());
        stockhouseInfoPO.setStorehouseName(storehouseName);
        stockhouseInfoPO.setStatus("1");
        try {
            stockhouseInfoPO = this.stockhouseInfoMapper.getModelBy(stockhouseInfoPO);
        }
        catch (TooManyResultsException e) {
            stockhouseInfoPO = null;
        }
        return stockhouseInfoPO;
    }

    private List<SmcExtImportOutStockInfoBO> doParseFile(File file, List<SmcExtImportOutStockInfoBO> rowsFailedList) {
        List<Row> rows = this.getRowsFromFile(file);
        ArrayList<SmcExtImportOutStockInfoBO> importRowsInfos = new ArrayList<SmcExtImportOutStockInfoBO>(rows.size());
        HashSet<String> imsiSet = new HashSet<String>(rows.size());
        for (Row row : rows) {
            SmcExtImportOutStockInfoBO importRow = new SmcExtImportOutStockInfoBO();
            importRow.setOutStoreName(this.getStrTrim(row, 0, false));
            importRow.setInStoreName(this.getStrTrim(row, 1, false));
            importRow.setHandObjectId(this.getStrTrim(row, 2, false));
            importRow.setAllocateTypeDesc(this.getStrTrim(row, 3, false));
            importRow.setWeight(this.getStrTrim(row, 4, true));
            importRow.setTransFee(this.getStrTrim(row, 5, true));
            importRow.setLogisCompany(this.getStrTrim(row, 6, false));
            importRow.setExpressNo(this.getStrTrim(row, 7, false));
            importRow.setHeadRemark(this.getStrTrim(row, 8, false));
            importRow.setImsi(this.getStrTrim(row, 9, false));
            importRow.setMaterialCode(this.getStrTrim(row, 10, false));
            importRow.setSkuName(this.getStrTrim(row, 11, false));
            importRow.setBillDetailNum(this.getStrTrim(row, 12, false));
            importRow.setDetailRemark(this.getStrTrim(row, 13, false));
            importRow.setRowNum(row.getRowNum());
            if (!this.doCheckCellInRow(rowsFailedList, importRow)) continue;
            if (imsiSet.contains(importRow.getImsi())) {
                importRow.setFailedDesc("\u7b2c" + importRow.getRowNum() + "\u884c\u4e32\u53f7\u91cd\u590d");
                rowsFailedList.add(importRow);
                continue;
            }
            if (!StringUtils.isEmpty((Object)importRow.getImsi())) {
                imsiSet.add(importRow.getImsi());
            }
            importRowsInfos.add(importRow);
        }
        if (CollectionUtils.isEmpty(importRowsInfos)) {
            return null;
        }
        return importRowsInfos;
    }

    private Map<String, List<SmcExtImportOutStockInfoBO>> doGroup(List<SmcExtImportOutStockInfoBO> rowsBeforeGrouped) {
        HashMap<String, List<SmcExtImportOutStockInfoBO>> groupMap = new HashMap<String, List<SmcExtImportOutStockInfoBO>>(rowsBeforeGrouped.size());
        for (SmcExtImportOutStockInfoBO row : rowsBeforeGrouped) {
            String key = row.getOutStoreName() + row.getInStoreName() + row.getAllocateTypeDesc() + row.getExpressNo();
            ArrayList<SmcExtImportOutStockInfoBO> rowsByGroup = new ArrayList<SmcExtImportOutStockInfoBO>(rowsBeforeGrouped.size());
            if (groupMap.containsKey(key)) {
                ((List)groupMap.get(key)).add(row);
                continue;
            }
            rowsByGroup.add(row);
            groupMap.put(key, rowsByGroup);
        }
        return groupMap;
    }

    private List<Row> getRowsFromFile(File file) {
        ArrayList<Row> rows;
        String suffix = ExcelUtils.getSuffix((String)file.getPath());
        if (!StringUtils.isEmpty((Object)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List hssfRows = ExcelUtils.readXls((String)file.getPath(), (int)0, (int)1);
            rows = new ArrayList<Row>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = ExcelUtils.readXlsx((String)file.getPath(), (int)0, (int)1);
            rows = new ArrayList(xssfRows);
        } else {
            throw new SmcBusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        if (CollectionUtils.isEmpty(rows)) {
            throw new SmcBusinessException("8888", "\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        if (rows.size() > 1000) {
            throw new SmcBusinessException("8888", "\u8d85\u8fc71000\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
        }
        return rows;
    }

    private boolean doCheckCellInRow(List<SmcExtImportOutStockInfoBO> importRowFailedList, SmcExtImportOutStockInfoBO importRow) {
        StringBuilder builder = new StringBuilder("\u7b2c" + importRow.getRowNum() + "\u884c\u6570\u636e\u6709\u95ee\u9898\uff0c\u5177\u4f53\u95ee\u9898\u662f\uff1a");
        StringBuilder question = new StringBuilder();
        if (StringUtils.isEmpty((Object)importRow.getOutStoreName())) {
            question.append("[\u79fb\u51fa\u4ed3\u5e93]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isEmpty((Object)importRow.getInStoreName())) {
            question.append("[\u79fb\u5165\u4ed3\u5e93]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (!StringUtils.isEmpty((Object)importRow.getOutStoreName()) && importRow.getOutStoreName().equals(importRow.getInStoreName())) {
            question.append("[\u79fb\u51fa\u4ed3\u5e93]\u548c[\u79fb\u5165\u4ed3\u5e93]\u4e0d\u53ef\u4ee5\u76f8\u540c\uff1b");
        }
        if (!ALLOCATE_TYPE_MAP.containsKey(importRow.getAllocateTypeDesc())) {
            question.append("[\u8c03\u62e8\u7c7b\u578b]\u9519\u8bef\uff1b");
        }
        if (DELIVERY.equals(importRow.getAllocateTypeDesc()) && StringUtils.isEmpty((Object)importRow.getWeight())) {
            question.append("\u8c03\u62e8\u7c7b\u578b\u4e3a[\u914d\u9001]\u65f6[\u91cd\u91cf]\u5fc5\u987b\u6709\u503c\uff1b");
        }
        if (DELIVERY.equals(importRow.getAllocateTypeDesc()) && StringUtils.isEmpty((Object)importRow.getTransFee())) {
            question.append("\u8c03\u62e8\u7c7b\u578b\u4e3a[\u914d\u9001]\u65f6[\u8fd0\u8d39]\u5fc5\u987b\u6709\u503c\uff1b");
        }
        if (DELIVERY.equals(importRow.getAllocateTypeDesc()) && StringUtils.isEmpty((Object)importRow.getLogisCompany())) {
            question.append("\u8c03\u62e8\u7c7b\u578b\u4e3a[\u914d\u9001]\u65f6[\u7269\u6d41\u516c\u53f8]\u5fc5\u987b\u6709\u503c\uff1b");
        }
        if (DELIVERY.equals(importRow.getAllocateTypeDesc()) && StringUtils.isEmpty((Object)importRow.getExpressNo())) {
            question.append("\u8c03\u62e8\u7c7b\u578b\u4e3a[\u914d\u9001]\u65f6[\u5feb\u9012\u5355\u53f7]\u5fc5\u987b\u6709\u503c\uff1b");
        }
        if (StringUtils.isEmpty((Object)importRow.getMaterialCode())) {
            question.append("[\u7269\u6599\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isEmpty((Object)importRow.getBillDetailNum())) {
            question.append("[\u6570\u91cf\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (!StringUtils.isEmpty((Object)importRow.getWeight()) && !Pattern.matches(DECIMAL_PATTERN, importRow.getWeight())) {
            question.append("[\u91cd\u91cf]\u683c\u5f0f\u9519\u8bef\uff1b");
        }
        if (!StringUtils.isEmpty((Object)importRow.getTransFee()) && !Pattern.matches(DECIMAL_PATTERN, importRow.getTransFee())) {
            question.append("[\u8fd0\u8d39]\u683c\u5f0f\u9519\u8bef\uff1b");
        }
        if (!Pattern.matches(NUM_PATTERN, importRow.getBillDetailNum())) {
            question.append("[\u6570\u91cf]\u683c\u5f0f\u9519\u8bef\uff1b");
        }
        if (!StringUtils.isEmpty((Object)importRow.getImsi()) && BigDecimal.ONE.compareTo(new BigDecimal(importRow.getBillDetailNum())) != 0) {
            question.append("\u6709[\u4e32\u53f7]\u65f6[\u6570\u91cf]\u5fc5\u987b\u662f1\uff1b");
        }
        if (question.length() != 0) {
            importRow.setFailedDesc(builder.append(question.substring(0, question.length() - 1)).toString());
            importRowFailedList.add(importRow);
            return false;
        }
        return true;
    }

    private File downloadFile(String fileName) {
        File file;
        try {
            file = this.fileClient.downloadToFile(this.filePath + fileName);
            log.info("getAbsolutePath={}", (Object)file.getAbsolutePath());
            log.info("getPath={}", (Object)file.getPath());
            log.info("getAbsoluteFile={}", (Object)file.getAbsoluteFile());
        }
        catch (Exception e) {
            throw new SmcBusinessException("8888", "\u6839\u636e\u6587\u4ef6\u540d\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\uff01");
        }
        if (null == file || !file.exists()) {
            throw new SmcBusinessException("8888", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return file;
    }

    private void doCheck(SmcExtBatchImportOutStockReqBO reqBO) {
        if (reqBO == null) {
            throw new SmcBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFileName())) {
            throw new SmcBusinessException("0001", "\u5165\u53c2[\u6587\u4ef6\u540d]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private String getStrTrim(Row row, int i, Boolean isDecimal) {
        String cellStr = ExcelUtils.cellToString((Cell)row.getCell(i), (Boolean)isDecimal);
        if (StringUtils.isEmpty((Object)cellStr)) {
            return "";
        }
        return cellStr.trim();
    }
}

