/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcBillAttachmentBO;
import com.tydic.smc.ability.bo.SmcBillDetailSkuBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryDetailAbilityReqBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryDetailAbilityRspBO;
import com.tydic.smc.api.commodity.SmcIntfSelectSkuAndSupListService;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListReqBO;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListRspBO;
import com.tydic.smc.dao.AccessoryMapper;
import com.tydic.smc.dao.BillDetailInfoMapper;
import com.tydic.smc.dao.BillExtendInfoMapper;
import com.tydic.smc.dao.StockChangeObjectMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.AccessoryPO;
import com.tydic.smc.po.BillExtendInfoPO;
import com.tydic.smc.po.StockChangeObjectPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.busi.SmcInStoreBillQryDetailBusiService;
import com.tydic.smc.service.busi.bo.BillDetailInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcInStoreBillQryDetailBusiServiceImpl
implements SmcInStoreBillQryDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcInStoreBillQryDetailBusiServiceImpl.class);
    @Autowired
    private StockChangeObjectMapper stockChangeObjectMapper;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private BillExtendInfoMapper billExtendInfoMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;
    @Autowired
    private SmcIntfSelectSkuAndSupListService smcIntfSelectSkuAndSupListService;

    @Override
    public SmcInStoreBillQryDetailAbilityRspBO qrySmcInStoreBillDetail(SmcInStoreBillQryDetailAbilityReqBO reqBO) {
        log.info("\u5165\u5e93\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO.toString());
        SmcInStoreBillQryDetailAbilityRspBO rspBO = new SmcInStoreBillQryDetailAbilityRspBO();
        StockChangeObjectPO stockChangeObjectPO = new StockChangeObjectPO();
        stockChangeObjectPO.setObjectId(reqBO.getObjectId());
        stockChangeObjectPO.setStorehouseId(reqBO.getStorehouseId());
        StockChangeObjectPO stockChangeObject = this.stockChangeObjectMapper.getModelBy(stockChangeObjectPO);
        if (stockChangeObject == null) {
            throw new SmcBusinessException("18001", "\u5355\u636e[" + reqBO.getObjectId() + "]\u4e0d\u5b58\u5728");
        }
        this.dealStockChangeObjectResult(stockChangeObject, rspBO);
        BillExtendInfoPO billExtendInfoPO = new BillExtendInfoPO();
        billExtendInfoPO.setObjectId(reqBO.getObjectId());
        billExtendInfoPO.setStorehouseId(reqBO.getStorehouseId());
        BillExtendInfoPO billExtendInfo = this.billExtendInfoMapper.getModelBy(billExtendInfoPO);
        if (billExtendInfo != null) {
            this.dealBillExtendInfoResult(billExtendInfo, rspBO);
        }
        BillDetailInfoBO billDetailInfoBO = new BillDetailInfoBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        billDetailInfoBO.setObjectId(reqBO.getObjectId());
        billDetailInfoBO.setStorehouseId(reqBO.getStorehouseId());
        List billDetailInfoBOList = this.billDetailInfoMapper.getSkuGroupBySku(billDetailInfoBO, page);
        if (billDetailInfoBOList != null) {
            HashMap<Long, Long> skuIdMap = new HashMap<Long, Long>();
            ArrayList<SmcBillDetailSkuBO> smcBillDetailSkuBOList = new ArrayList<SmcBillDetailSkuBO>();
            for (BillDetailInfoBO billDetailInfo : billDetailInfoBOList) {
                if (!skuIdMap.containsKey(billDetailInfo.getSkuId())) {
                    skuIdMap.put(billDetailInfo.getSkuId(), billDetailInfo.getSkuId());
                }
                SmcBillDetailSkuBO bo = new SmcBillDetailSkuBO();
                bo.setSkuId(billDetailInfo.getSkuId().toString());
                bo.setSkuNum(billDetailInfo.getSkuNum());
                bo.setRemark(billDetailInfo.getRemark());
                if ("02".equals(rspBO.getObjectType())) {
                    bo.setImsi(billDetailInfo.getImsiStr());
                    bo.setScanImsi(billDetailInfo.getImsiStr());
                } else {
                    bo.setImsi(billDetailInfo.getImsiStr());
                }
                smcBillDetailSkuBOList.add(bo);
            }
            this.dealSkuInfo(smcBillDetailSkuBOList, new ArrayList<Long>(skuIdMap.keySet()));
            BigDecimal totalNum = BigDecimal.ZERO;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (SmcBillDetailSkuBO item : smcBillDetailSkuBOList) {
                if (item.getSkuNum() != null) {
                    totalNum = totalNum.add(new BigDecimal(item.getSkuNum()));
                }
                if (item.getPrice() == null) continue;
                totalPrice = totalPrice.add(item.getPrice());
            }
            rspBO.setTotalNum(Integer.valueOf(totalNum.intValue()));
            rspBO.setTotalPrice(totalPrice);
            rspBO.setRows(smcBillDetailSkuBOList);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        }
        AccessoryPO accessoryPO = new AccessoryPO();
        accessoryPO.setObjectId(reqBO.getObjectId());
        List accessoryPOS = this.accessoryMapper.getList(accessoryPO);
        if (accessoryPOS != null) {
            ArrayList<SmcBillAttachmentBO> attachmentBOList = new ArrayList<SmcBillAttachmentBO>();
            for (AccessoryPO po : accessoryPOS) {
                SmcBillAttachmentBO bo = new SmcBillAttachmentBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                attachmentBOList.add(bo);
            }
            rspBO.setBillAttachmentList(attachmentBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealStockChangeObjectResult(StockChangeObjectPO po, SmcInStoreBillQryDetailAbilityRspBO rspBO) {
        rspBO.setObjectId(po.getObjectId().toString());
        rspBO.setObjectType(po.getObjectType());
        rspBO.setCreateName(po.getCreateOperName());
        rspBO.setCreateNo(po.getCreateOperId() + "");
        rspBO.setHandObjectId(po.getHandObjectId());
        rspBO.setCreateTime(DateUtils.dateToStr((Date)po.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (po.getInStoreNo() != null) {
            rspBO.setInStoreNo(po.getInStoreNo() + "");
            rspBO.setInStoreName(this.qryStorehouseName(po.getInStoreNo()));
        }
        if (po.getOutStoreNo() != null) {
            rspBO.setOutStoreNo(po.getOutStoreNo() + "");
            rspBO.setOutStoreName(this.qryStorehouseName(po.getOutStoreNo()));
        }
        rspBO.setRemark(po.getRemark());
        rspBO.setStatus(po.getObjectState());
        String statusStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("OBJECT_STATUS", po.getObjectState()).getStr();
        rspBO.setStatusStr(statusStr);
        if (po.getRelativeObjectId() != null) {
            rspBO.setRelativeObjectId(po.getRelativeObjectId().toString());
        }
    }

    private void dealBillExtendInfoResult(BillExtendInfoPO po, SmcInStoreBillQryDetailAbilityRspBO rspBO) {
        rspBO.setSupplierId(po.getSupplierId());
        rspBO.setBusiType(po.getBusiType());
        rspBO.setCashFlag(po.getCashFlag());
        rspBO.setSupplierId(po.getSupplierId());
        rspBO.setSupplierName(po.getSupplierName());
        if (po.getSupplierId() != null) {
            // empty if block
        }
        if (po.getBusiType() != null) {
            String busiTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("BUSI_TYPE", po.getBusiType()).getStr();
            rspBO.setBusiTypeStr(busiTypeStr);
        }
        if (po.getCashFlag() != null) {
            String cashFlagStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("IF_FLAG", po.getCashFlag()).getStr();
            rspBO.setCashFlagStr(cashFlagStr);
        }
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }

    private void dealSkuInfo(List<SmcBillDetailSkuBO> smcBillDetailSkuBOList, List<Long> skuIds) {
        SmcIntfSelectSkuAndSupListReqBO reqBO = new SmcIntfSelectSkuAndSupListReqBO();
        reqBO.setSkuIds(skuIds);
        reqBO.setPageSize(skuIds.size());
        SmcIntfSelectSkuAndSupListRspBO rspBO = this.smcIntfSelectSkuAndSupListService.selectSkuAndSupList(reqBO);
        if (rspBO != null && rspBO.getRows() != null) {
            smcBillDetailSkuBOList.forEach(item -> rspBO.getRows().forEach(sku -> {
                if (item.getSkuId().equals(sku.getSkuId().toString())) {
                    item.setMaterialCode(sku.getMaterialId());
                    item.setSkuName(sku.getSkuName());
                    if (sku.getSkuPrice() != null) {
                        item.setUnitPrice(new BigDecimal(sku.getSkuPrice()).divide(new BigDecimal(10000)));
                        BigDecimal price = item.getUnitPrice().multiply(new BigDecimal(item.getSkuNum()));
                        item.setPrice(price.setScale(3, 4));
                    }
                    item.setConfigur(sku.getConfigName());
                }
            }));
        }
    }
}

