/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcInStoreBillQryListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcInStoreBillQryListAbilityRspBO;
import com.tydic.smc.ability.bo.StockBillObjectBO;
import com.tydic.smc.dao.StockChangeObjectMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.StockChangeObjectPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.atom.SmcQryStoreByUserAuthAtomService;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomRspBO;
import com.tydic.smc.service.busi.SmcInStoreBillQryListBusiService;
import com.tydic.smc.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcInStoreBillQryListBusiServiceImpl
implements SmcInStoreBillQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcInStoreBillQryListBusiServiceImpl.class);
    @Autowired
    private StockChangeObjectMapper stockChangeObjectMapper;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;
    @Autowired
    private SmcQryStoreByUserAuthAtomService smcQryStoreByUserAuthAtomService;

    @Override
    public SmcInStoreBillQryListAbilityRspBO qryInStoreBillList(SmcInStoreBillQryListAbilityReqBO reqBO) {
        SmcInStoreBillQryListAbilityRspBO rspBO = new SmcInStoreBillQryListAbilityRspBO();
        SmcQryStoreByUserAuthAtomReqBO qryStoreByUserReqBO = new SmcQryStoreByUserAuthAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryStoreByUserReqBO);
        SmcQryStoreByUserAuthAtomRspBO qryStoreByUserRspBO = this.smcQryStoreByUserAuthAtomService.qryStorehouseListByUser(qryStoreByUserReqBO);
        if (qryStoreByUserRspBO != null && !"0000".equals(qryStoreByUserRspBO.getRespCode())) {
            throw new SmcBusinessException(qryStoreByUserRspBO.getRespCode(), qryStoreByUserRspBO.getRespDesc());
        }
        ArrayList<StockBillObjectBO> stockBillObjectBOS = new ArrayList<StockBillObjectBO>();
        StockChangeObjectPO po = new StockChangeObjectPO();
        if (reqBO.getBeginDate() != null) {
            po.setBeginDate(DateUtils.strToDate((String)(reqBO.getBeginDate() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            po.setBeginDate(DateUtil.getDateBeforeThree());
        }
        if (reqBO.getEndDate() != null) {
            po.setEndDate(DateUtils.strToDate((String)(reqBO.getEndDate() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            po.setEndDate(new Date());
        }
        if (reqBO.getInStoreNo() != null) {
            po.setInStoreNo(reqBO.getInStoreNo());
            po.setStorehouseId(reqBO.getInStoreNo());
        } else if (qryStoreByUserRspBO.getStorehouseIdList().size() > 0) {
            po.setStorehouseIds(qryStoreByUserRspBO.getStorehouseIdList());
        } else {
            rspBO.setRespDesc("\u67e5\u8be2\u65e0\u8bb0\u5f55");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getObjectType() != null) {
            po.setObjectType(reqBO.getObjectType());
        } else {
            ArrayList<String> objectTypeList = new ArrayList<String>();
            objectTypeList.add("02");
            objectTypeList.add("04");
            objectTypeList.add("03");
            po.setObjectTypeList(objectTypeList);
        }
        if (reqBO.getOutStoreNo() != null) {
            po.setOutStoreNo(reqBO.getOutStoreNo());
        }
        if (reqBO.getObjectId() != null) {
            po.setObjectId(reqBO.getObjectId());
        }
        if (reqBO.getRelativeObjectId() != null) {
            po.setRelativeObjectId(reqBO.getRelativeObjectId());
        }
        po.setOrderBy(" create_time desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List stockChangeObjectPOS = this.stockChangeObjectMapper.getListPage(po, page);
        Map objTyoeMap = this.smcDicDictionaryAtomService.queryDictByPcode("OBJECT_TYPE").getStrMap();
        for (StockChangeObjectPO stockChangeObjectPO : stockChangeObjectPOS) {
            StockBillObjectBO stockBillObjectBO = new StockBillObjectBO();
            stockBillObjectBO.setObjectId(stockChangeObjectPO.getObjectId().toString());
            stockBillObjectBO.setObjectType(stockChangeObjectPO.getObjectType());
            stockBillObjectBO.setObjectState(stockChangeObjectPO.getObjectState());
            stockBillObjectBO.setObjectTypeStr((String)objTyoeMap.get(stockChangeObjectPO.getObjectType()));
            stockBillObjectBO.setInStoreDate(DateUtils.dateToStr((Date)stockChangeObjectPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            stockBillObjectBO.setStorehouseId(stockChangeObjectPO.getStorehouseId() + "");
            if (stockChangeObjectPO.getInStoreNo() != null) {
                stockBillObjectBO.setInStoreNo(stockChangeObjectPO.getInStoreNo() + "");
                stockBillObjectBO.setInStoreName(this.qryStorehouseName(stockChangeObjectPO.getInStoreNo()));
            }
            if (stockChangeObjectPO.getOutStoreNo() != null) {
                stockBillObjectBO.setOutStoreNo(stockChangeObjectPO.getOutStoreNo() + "");
                stockBillObjectBO.setOutStoreName(this.qryStorehouseName(stockChangeObjectPO.getOutStoreNo()));
            }
            if (stockChangeObjectPO.getRelativeObjectId() != null) {
                stockBillObjectBO.setRelativeObjectId(stockChangeObjectPO.getRelativeObjectId().toString());
            }
            stockBillObjectBO.setCreateOperId(stockChangeObjectPO.getCreateOperId() + "");
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            if (reqBO.getmUserId().toString().equals(stockBillObjectBO.getCreateOperId()) && "02".equals(stockBillObjectBO.getObjectState()) && "02".equals(stockBillObjectBO.getObjectType())) {
                stockBillObjectBO.setOperFlag("1");
            } else {
                stockBillObjectBO.setOperFlag("0");
            }
            stockBillObjectBOS.add(stockBillObjectBO);
        }
        rspBO.setRows(stockBillObjectBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }
}

