/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcBillAttachmentBO;
import com.tydic.smc.ability.bo.SmcBillDetailSkuBO;
import com.tydic.smc.ability.bo.SmcQryOutStockDetailAbilityReqBO;
import com.tydic.smc.ability.bo.SmcQryOutStockDetailAbilityRspBO;
import com.tydic.smc.api.commodity.SmcIntfSelectSkuAndSupListService;
import com.tydic.smc.api.common.bo.SmcBillReparationBO;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListReqBO;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListRspBO;
import com.tydic.smc.common.bo.SmcApprovalTaskBO;
import com.tydic.smc.dao.BillDetailInfoMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.BillDetailInfoPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.atom.SmcQryObjByIdAndHouseIdAtomService;
import com.tydic.smc.service.atom.bo.SmcQryObjByIdAndHouseIdAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryObjByIdAndHouseIdAtomRspBO;
import com.tydic.smc.service.busi.SmcQryOutStockDetailBusiService;
import com.tydic.smc.service.busi.bo.AccessoryBO;
import com.tydic.smc.service.busi.bo.BillExtendInfoBO;
import com.tydic.smc.service.busi.bo.BillLogisticsInfoBO;
import com.tydic.smc.service.busi.bo.BillReparationInfoBO;
import com.tydic.smc.service.busi.bo.StockChangeObjectBO;
import com.tydic.uac.ability.UacQryApprovalAuditRecordAbilityService;
import com.tydic.uac.ability.bo.UacQryApprovalAuditRecordAbilityReqBO;
import com.tydic.uac.ability.bo.UacQryApprovalAuditRecordAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SmcQryOutStockDetailBusiServiceImpl
implements SmcQryOutStockDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcQryOutStockDetailBusiServiceImpl.class);
    private static final Integer WAIT_APRV = 1;
    private static final Integer APRVED = 2;
    private static final Integer APRV_REJECT = 3;
    private static final Integer PRV_CANCEL = 4;
    private static final Map<Integer, String> STATUS_MAP = new HashMap<Integer, String>();
    @Autowired
    private SmcQryObjByIdAndHouseIdAtomService smcQryObjByIdAndHouseIdAtomService;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;
    @Autowired
    private BillDetailInfoMapper billDetailInfoMapper;
    @Autowired
    private SmcIntfSelectSkuAndSupListService smcIntfSelectSkuAndSupListService;
    @Autowired
    private UacQryApprovalAuditRecordAbilityService uacQryApprovalAuditRecordAbilityService;

    @Override
    public SmcQryOutStockDetailAbilityRspBO qryOutStockDetail(SmcQryOutStockDetailAbilityReqBO reqBO) {
        SmcQryOutStockDetailAbilityRspBO rspBO = new SmcQryOutStockDetailAbilityRspBO();
        SmcQryObjByIdAndHouseIdAtomReqBO smcQryObjByIdAndHouseIdAtomReqBO = new SmcQryObjByIdAndHouseIdAtomReqBO();
        smcQryObjByIdAndHouseIdAtomReqBO.setObjectId(reqBO.getObjectId());
        smcQryObjByIdAndHouseIdAtomReqBO.setStorehouseId(reqBO.getStorehouseId());
        SmcQryObjByIdAndHouseIdAtomRspBO detailRspBO = this.smcQryObjByIdAndHouseIdAtomService.qryBillByObjectId(smcQryObjByIdAndHouseIdAtomReqBO);
        if (detailRspBO != null && !"0000".equals(detailRspBO.getRespCode())) {
            throw new SmcBusinessException(detailRspBO.getRespCode(), detailRspBO.getRespDesc());
        }
        StockChangeObjectBO stockChangeObjectBO = detailRspBO.getStockChangeObjectBO();
        rspBO.setObjectType(stockChangeObjectBO.getObjectType());
        rspBO.setObjectId(stockChangeObjectBO.getObjectId() + "");
        rspBO.setCreateNo(stockChangeObjectBO.getCreateOperId() + "");
        rspBO.setCreateName(stockChangeObjectBO.getCreateOperName());
        rspBO.setCreateTime(DateUtils.dateToStr((Date)stockChangeObjectBO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (stockChangeObjectBO.getInStoreNo() != null) {
            rspBO.setInStoreNo(stockChangeObjectBO.getInStoreNo() + "");
            rspBO.setInStoreName(this.qryStorehouseName(stockChangeObjectBO.getInStoreNo()));
        }
        if (stockChangeObjectBO.getOutStoreNo() != null) {
            rspBO.setOutStoreNo(stockChangeObjectBO.getOutStoreNo() + "");
            rspBO.setOutStoreName(this.qryStorehouseName(stockChangeObjectBO.getOutStoreNo()));
        }
        rspBO.setHandObjectId(stockChangeObjectBO.getHandObjectId());
        rspBO.setRemark(stockChangeObjectBO.getRemark());
        rspBO.setStatus(stockChangeObjectBO.getObjectState());
        String statusStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("OBJECT_STATUS", stockChangeObjectBO.getObjectState()).getStr();
        rspBO.setStatusStr(statusStr);
        rspBO.setMoveInOperId(stockChangeObjectBO.getUpdateOperId() + "");
        rspBO.setMoveInOperName(stockChangeObjectBO.getUpdateOperName());
        rspBO.setMoveInTime(DateUtils.dateToStr((Date)stockChangeObjectBO.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        BillExtendInfoBO billExtendInfoBO = detailRspBO.getBillExtendInfoBO();
        if (billExtendInfoBO.getMoveType() != null) {
            rspBO.setMoveType(billExtendInfoBO.getMoveType());
            String moveTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("MOVE_TYPE", billExtendInfoBO.getMoveType()).getStr();
            rspBO.setMoveTypeDesc(moveTypeStr);
        }
        if (billExtendInfoBO.getAllocateType() != null) {
            rspBO.setAllocateType(billExtendInfoBO.getAllocateType());
            String allocateTypeStr = this.smcDicDictionaryAtomService.queryDictByPcodeAndCode("ALLOCATE_TYPE", billExtendInfoBO.getAllocateType()).getStr();
            rspBO.setAllocateTypeDesc(allocateTypeStr);
        }
        if (!StringUtils.isEmpty((Object)billExtendInfoBO.getCustomerId())) {
            rspBO.setCustomerId(billExtendInfoBO.getCustomerId());
            rspBO.setCustomerName(billExtendInfoBO.getCustomerName());
        }
        if (!StringUtils.isEmpty((Object)billExtendInfoBO.getBusiStaff())) {
            rspBO.setBusiStaffId(billExtendInfoBO.getBusiStaff());
            rspBO.setBusiStaffName(billExtendInfoBO.getBusiStaffName());
        }
        if (detailRspBO.getBillLogisticsInfoBO() != null) {
            BillLogisticsInfoBO billLogisticsInfoBO = detailRspBO.getBillLogisticsInfoBO();
            rspBO.setWeight(billLogisticsInfoBO.getWeight());
            rspBO.setTransFee(billLogisticsInfoBO.getTransFee());
            rspBO.setLogisCompanyId(billLogisticsInfoBO.getLogisCompany());
            Map logisMap = this.smcDicDictionaryAtomService.queryDictByPcode("LOGIS_COMPANY").getStrMap();
            rspBO.setLogisCompanyName((String)logisMap.get(billLogisticsInfoBO.getLogisCompany()));
            rspBO.setExpressNo(billLogisticsInfoBO.getExpressNo());
            rspBO.setInsurePrice(billLogisticsInfoBO.getInsurePrice());
        }
        if (detailRspBO.getBillReparationInfoBO() != null) {
            ArrayList<SmcBillReparationBO> smcBillReparationBOList = new ArrayList<SmcBillReparationBO>();
            List billReparationInfoBOList = detailRspBO.getBillReparationInfoBO();
            Map ifMap = this.smcDicDictionaryAtomService.queryDictByPcode("IF_FLAG").getStrMap();
            Map reparationMap = this.smcDicDictionaryAtomService.queryDictByPcode("REPARATION_TYPE").getStrMap();
            BigDecimal totalReparationMoney = BigDecimal.ZERO;
            for (BillReparationInfoBO bo : billReparationInfoBOList) {
                SmcBillReparationBO smcBillReparationBO = new SmcBillReparationBO();
                if (bo.getCashFlag() != null) {
                    smcBillReparationBO.setCashFlag((String)ifMap.get(bo.getCashFlag()));
                }
                smcBillReparationBO.setReparationMoney(bo.getReparationMoney());
                smcBillReparationBO.setReparationRemark(bo.getReparationRemark());
                if (bo.getReparationType() != null) {
                    smcBillReparationBO.setReparationType((String)reparationMap.get(bo.getReparationType()));
                }
                smcBillReparationBOList.add(smcBillReparationBO);
                totalReparationMoney = totalReparationMoney.add(bo.getReparationMoney());
            }
            rspBO.setTotalReparationMoney(totalReparationMoney);
            rspBO.setReparationList(smcBillReparationBOList);
        }
        BillDetailInfoPO billDetailInfoPO = new BillDetailInfoPO();
        billDetailInfoPO.setObjectId(reqBO.getObjectId());
        billDetailInfoPO.setStorehouseId(reqBO.getStorehouseId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List billDetailInfoPOList = this.billDetailInfoMapper.getListPage(billDetailInfoPO, page);
        if (billDetailInfoPOList != null) {
            HashMap<Long, Long> skuIdMap = new HashMap<Long, Long>();
            ArrayList<SmcBillDetailSkuBO> smcBillDetailSkuBOList = new ArrayList<SmcBillDetailSkuBO>();
            for (BillReparationInfoBO bo : billDetailInfoPOList) {
                if (!skuIdMap.containsKey(bo.getSkuId())) {
                    skuIdMap.put(bo.getSkuId(), bo.getSkuId());
                }
                SmcBillDetailSkuBO smcBillDetailSkuBO = new SmcBillDetailSkuBO();
                smcBillDetailSkuBO.setSkuId(bo.getSkuId() + "");
                smcBillDetailSkuBO.setSkuNum(Integer.valueOf(bo.getBillDetailNum().intValue()));
                smcBillDetailSkuBO.setImsi(bo.getImsi());
                smcBillDetailSkuBO.setMaterialCode(bo.getMaterialCode());
                smcBillDetailSkuBOList.add(smcBillDetailSkuBO);
            }
            this.dealSkuInfo(smcBillDetailSkuBOList, new ArrayList<Long>(skuIdMap.keySet()));
            BigDecimal totalNum = BigDecimal.ZERO;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (SmcBillDetailSkuBO item : smcBillDetailSkuBOList) {
                if (item.getSkuNum() != null) {
                    totalNum = totalNum.add(new BigDecimal(item.getSkuNum()));
                }
                if (item.getPrice() == null) continue;
                totalPrice = totalPrice.add(item.getPrice());
            }
            Map statusMap = this.smcDicDictionaryAtomService.queryDictByPcode("PROV_APPROVAL_STATUS").getStrMap();
            statusMap.putAll(this.smcDicDictionaryAtomService.queryDictByPcode("CITY_APPROVAL_STATUS").getStrMap());
            rspBO.setApprovalStatus(stockChangeObjectBO.getAuditState());
            rspBO.setApprovalStatusDesc((String)statusMap.get(stockChangeObjectBO.getAuditState()));
            if (reqBO.getAuditOrderId() != null) {
                UacQryApprovalAuditRecordAbilityReqBO uacQryApprovalAuditRecordAbilityReqBO = new UacQryApprovalAuditRecordAbilityReqBO();
                uacQryApprovalAuditRecordAbilityReqBO.setAuditOrderId(reqBO.getAuditOrderId());
                uacQryApprovalAuditRecordAbilityReqBO.setShareId(reqBO.getStorehouseId());
                uacQryApprovalAuditRecordAbilityReqBO.setObjId(reqBO.getObjectId() + "");
                UacQryApprovalAuditRecordAbilityRspBO auditRspBO = this.uacQryApprovalAuditRecordAbilityService.qryApprovalAuditRecord(uacQryApprovalAuditRecordAbilityReqBO);
                if ("0000".equals(auditRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)auditRspBO.getRows())) {
                    ArrayList taskList = new ArrayList(auditRspBO.getRows().size());
                    rspBO.setTaskList(taskList);
                    auditRspBO.getRows().forEach(audit -> {
                        SmcApprovalTaskBO smcApprovalTaskBO = new SmcApprovalTaskBO();
                        BeanUtils.copyProperties((Object)audit, (Object)smcApprovalTaskBO);
                        taskList.add(smcApprovalTaskBO);
                        if ("provinceCode".equals(audit.getStepCode())) {
                            rspBO.setProvinceApprovalId(audit.getOperId());
                            rspBO.setProvinceApprovalName(audit.getOperName());
                            rspBO.setProvinceApprovalDesc(STATUS_MAP.get(audit.getTaskState()));
                            rspBO.setProvinceApprovalTime(audit.getOperTime());
                        } else if ("cityCode".equals(audit.getStepCode())) {
                            rspBO.setCityApprovalId(audit.getOperId());
                            rspBO.setCityApprovalName(audit.getOperName());
                            rspBO.setCityApprovalDesc(STATUS_MAP.get(audit.getTaskState()));
                            rspBO.setCityApprovalTime(audit.getOperTime());
                        }
                    });
                }
            }
            rspBO.setTotalNum(Integer.valueOf(totalNum.intValue()));
            rspBO.setTotalPrice(totalPrice);
            rspBO.setRows(smcBillDetailSkuBOList);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        }
        if (detailRspBO.getAccessoryBOList() != null) {
            ArrayList<SmcBillAttachmentBO> smcBillAttachmentBOS = new ArrayList<SmcBillAttachmentBO>();
            for (AccessoryBO bo : detailRspBO.getAccessoryBOList()) {
                SmcBillAttachmentBO smcBillAttachmentBO = new SmcBillAttachmentBO();
                smcBillAttachmentBO.setAccessoryName(bo.getAccessoryName());
                smcBillAttachmentBO.setAccessoryUrl(bo.getAccessoryUrl());
                smcBillAttachmentBOS.add(smcBillAttachmentBO);
            }
            rspBO.setBillAttachmentList(smcBillAttachmentBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }

    private void dealSkuInfo(List<SmcBillDetailSkuBO> smcBillDetailSkuBOList, List<Long> skuIds) {
        SmcIntfSelectSkuAndSupListReqBO reqBO = new SmcIntfSelectSkuAndSupListReqBO();
        reqBO.setSkuIds(skuIds);
        reqBO.setPageSize(skuIds.size());
        SmcIntfSelectSkuAndSupListRspBO rspBO = this.smcIntfSelectSkuAndSupListService.selectSkuAndSupList(reqBO);
        if (rspBO != null && rspBO.getRows() != null) {
            smcBillDetailSkuBOList.forEach(item -> rspBO.getRows().forEach(sku -> {
                if (item.getSkuId().equals(sku.getSkuId().toString())) {
                    item.setSkuName(sku.getSkuName());
                    item.setMaterialCode(sku.getMaterialId());
                    if (sku.getSkuPrice() != null) {
                        item.setUnitPrice(new BigDecimal(sku.getSkuPrice()).divide(new BigDecimal(10000)));
                        BigDecimal price = item.getUnitPrice().multiply(new BigDecimal(item.getSkuNum()));
                        item.setPrice(price.setScale(3, 4));
                    }
                    item.setConfigur(sku.getConfigName());
                }
            }));
        }
    }

    private static void initialize() {
        STATUS_MAP.put(WAIT_APRV, "\u5f85\u5ba1\u6279");
        STATUS_MAP.put(APRVED, "\u5ba1\u6838\u901a\u8fc7");
        STATUS_MAP.put(APRV_REJECT, "\u5ba1\u6838\u9a73\u56de");
        STATUS_MAP.put(PRV_CANCEL, "\u5ba1\u6838\u64a4\u9500");
    }

    static {
        SmcQryOutStockDetailBusiServiceImpl.initialize();
    }
}

