/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcQryOutStockListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcQryOutStockListAbilityRspBO;
import com.tydic.smc.ability.bo.StockBillObjectBO;
import com.tydic.smc.api.ability.bo.SmcQryStockChgAprvListAbilityReqBO;
import com.tydic.smc.dao.StockChangeObjectMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.StockChangeObjectPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.atom.SmcQryStoreByUserAuthAtomService;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomRspBO;
import com.tydic.smc.service.busi.SmcQryOutStockListBusiService;
import com.tydic.smc.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmcQryOutStockListBusiServiceImpl
implements SmcQryOutStockListBusiService {
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private StockChangeObjectMapper stockChangeObjectMapper;
    @Autowired
    private SmcQryStoreByUserAuthAtomService smcQryStoreByUserAuthAtomService;

    @Override
    public SmcQryOutStockListAbilityRspBO qryOutStockList(SmcQryOutStockListAbilityReqBO reqBO) {
        SmcQryOutStockListAbilityRspBO rspBO = new SmcQryOutStockListAbilityRspBO();
        SmcQryStoreByUserAuthAtomReqBO qryStoreByUserReqBO = new SmcQryStoreByUserAuthAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryStoreByUserReqBO);
        SmcQryStoreByUserAuthAtomRspBO qryStoreByUserRspBO = this.smcQryStoreByUserAuthAtomService.qryStorehouseListByUser(qryStoreByUserReqBO);
        if (qryStoreByUserRspBO != null && !"0000".equals(qryStoreByUserRspBO.getRespCode())) {
            throw new SmcBusinessException(qryStoreByUserRspBO.getRespCode(), qryStoreByUserRspBO.getRespDesc());
        }
        ArrayList<StockBillObjectBO> stockBillObjectBOS = new ArrayList<StockBillObjectBO>();
        StockChangeObjectPO po = new StockChangeObjectPO();
        if (reqBO.getOutStockDateStart() != null) {
            po.setBeginDate(DateUtils.strToDate((String)(reqBO.getOutStockDateStart() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            po.setBeginDate(DateUtil.getDateBeforeThree());
        }
        if (reqBO.getOutStockDateEnd() != null) {
            po.setEndDate(DateUtils.strToDate((String)(reqBO.getOutStockDateEnd() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            po.setEndDate(new Date());
        }
        if (reqBO.getInStoreNo() != null) {
            po.setInStoreNo(reqBO.getInStoreNo());
        }
        if (reqBO.getObjectType() != null) {
            if ("ALL".equals(reqBO.getObjectType())) {
                ArrayList<String> objectTypeList = new ArrayList<String>();
                objectTypeList.add("06");
                objectTypeList.add("08");
                objectTypeList.add("07");
                po.setObjectTypeList(objectTypeList);
            } else {
                po.setObjectType(reqBO.getObjectType());
            }
        }
        if (reqBO.getOutStoreNo() != null) {
            po.setOutStoreNo(reqBO.getOutStoreNo());
            po.setStorehouseId(reqBO.getOutStoreNo());
        } else if ("1".equals(reqBO.getQryFlag())) {
            po.setInStoreNos(qryStoreByUserRspBO.getStorehouseIdList());
        } else if (qryStoreByUserRspBO.getStorehouseIdList().size() > 0) {
            po.setStorehouseIds(qryStoreByUserRspBO.getStorehouseIdList());
        } else {
            rspBO.setRespDesc("\u67e5\u8be2\u65e0\u8bb0\u5f55");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getObjectId() != null) {
            po.setObjectId(reqBO.getObjectId());
        }
        if (reqBO.getObjectState() != null) {
            if ("ALL".equals(reqBO.getObjectState())) {
                ArrayList<String> objectStateList = new ArrayList<String>();
                objectStateList.add("02");
                objectStateList.add("01");
                objectStateList.add("03");
                objectStateList.add("04");
                po.setObjectStateList(objectStateList);
            } else {
                po.setObjectState(reqBO.getObjectState());
            }
        }
        if (reqBO.getApprovalStatus() != null) {
            if ("ALL".equals(reqBO.getApprovalStatus())) {
                ArrayList<String> approvalStatusList = new ArrayList<String>();
                approvalStatusList.add("03");
                approvalStatusList.add("04");
                approvalStatusList.add("01");
                approvalStatusList.add("02");
                approvalStatusList.add("05");
                po.setApprovalStatusList(approvalStatusList);
            } else {
                po.setApprovalStatus(reqBO.getApprovalStatus());
            }
        }
        po.setOrderBy(" create_time desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List stockChangeObjectPOS = this.stockChangeObjectMapper.getListPage(po, page);
        Map objStatusMap = this.smcDicDictionaryAtomService.queryDictByPcode("OBJECT_STATUS").getStrMap();
        Map objTypeMap = this.smcDicDictionaryAtomService.queryDictByPcode("OBJECT_TYPE").getStrMap();
        Map auditStateMap = this.smcDicDictionaryAtomService.queryDictByPcode("AUDIT_STATUS").getStrMap();
        for (StockChangeObjectPO stockChangeObjectPO : stockChangeObjectPOS) {
            StockBillObjectBO stockBillObjectBO = new StockBillObjectBO();
            stockBillObjectBO.setObjectId(stockChangeObjectPO.getObjectId().toString());
            stockBillObjectBO.setObjectType(stockChangeObjectPO.getObjectType());
            stockBillObjectBO.setObjectTypeStr((String)objTypeMap.get(stockChangeObjectPO.getObjectType()));
            stockBillObjectBO.setInStoreDate(DateUtils.dateToStr((Date)stockChangeObjectPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            stockBillObjectBO.setStorehouseId(stockChangeObjectPO.getStorehouseId() + "");
            if (stockChangeObjectPO.getInStoreNo() != null) {
                stockBillObjectBO.setInStoreNo(stockChangeObjectPO.getInStoreNo() + "");
                stockBillObjectBO.setInStoreName(this.qryStorehouseName(stockChangeObjectPO.getInStoreNo()));
            }
            if (stockChangeObjectPO.getOutStoreNo() != null) {
                stockBillObjectBO.setOutStoreNo(stockChangeObjectPO.getOutStoreNo() + "");
                stockBillObjectBO.setOutStoreName(this.qryStorehouseName(stockChangeObjectPO.getOutStoreNo()));
            }
            stockBillObjectBO.setCreateOperId(stockChangeObjectPO.getCreateOperId() + "");
            stockBillObjectBO.setCreateOperName(stockChangeObjectPO.getCreateOperName());
            if ("01".equals(stockChangeObjectPO.getObjectState()) || "02".equals(stockChangeObjectPO.getObjectState()) || "03".equals(stockChangeObjectPO.getObjectState())) {
                if (stockChangeObjectPO.getUpdateOperId() != null) {
                    stockBillObjectBO.setMoveInOperId(stockChangeObjectPO.getUpdateOperId() + "");
                }
                if (stockChangeObjectPO.getUpdateOperName() != null) {
                    stockBillObjectBO.setMoveInOperName(stockChangeObjectPO.getUpdateOperName());
                }
                if (stockChangeObjectPO.getUpdateTime() != null) {
                    stockBillObjectBO.setMoveInTime(DateUtils.dateToStr((Date)stockChangeObjectPO.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                stockBillObjectBO.setMoveInStatus(stockChangeObjectPO.getObjectState());
                stockBillObjectBO.setMoveInStatusDesc((String)objStatusMap.get(stockChangeObjectPO.getObjectState()));
            }
            if (stockChangeObjectPO.getAuditState() != null) {
                stockBillObjectBO.setApprovalStatus(stockChangeObjectPO.getAuditState());
                stockBillObjectBO.setApprovalStatusDesc((String)auditStateMap.get(stockChangeObjectPO.getAuditState()));
                SmcQryStockChgAprvListAbilityReqBO smcQryStockChgAprvListAbilityReqBO = new SmcQryStockChgAprvListAbilityReqBO();
                smcQryStockChgAprvListAbilityReqBO.setOutStoreNo(stockChangeObjectPO.getOutStoreNo());
                smcQryStockChgAprvListAbilityReqBO.setObjectId(stockChangeObjectPO.getObjectId());
                if (!CollectionUtils.isEmpty((Collection)reqBO.getmRole())) {
                    smcQryStockChgAprvListAbilityReqBO.setRangCodes(reqBO.getmRole());
                }
                Long auditOrderId = this.stockChangeObjectMapper.getAuditOrderId(smcQryStockChgAprvListAbilityReqBO);
                stockBillObjectBO.setAuditOrderId(auditOrderId);
            }
            if (reqBO.getmUserId().toString().equals(stockBillObjectBO.getCreateOperId()) && ("02".equals(stockBillObjectBO.getApprovalStatus()) || "05".equals(stockBillObjectBO.getApprovalStatus()) || "04".equals(stockChangeObjectPO.getObjectState()) && "0".equals(stockChangeObjectPO.getAuditFlag()))) {
                stockBillObjectBO.setOperFlag("1");
            } else {
                stockBillObjectBO.setOperFlag("0");
            }
            stockBillObjectBOS.add(stockBillObjectBO);
        }
        rspBO.setRows(stockBillObjectBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }
}

