/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityRspBO;
import com.tydic.smc.ability.bo.StockSkuBO;
import com.tydic.smc.api.commodity.SmcIntfSelectSkuAndSupListService;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListReqBO;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListRspBO;
import com.tydic.smc.dao.ShopStorehouseRelMapper;
import com.tydic.smc.dao.StockInfoMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.po.ShopStorehouseRelPO;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.busi.SmcStocktakeSkuQryListBusiService;
import com.tydic.smc.service.busi.bo.StockInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcStocktakeSkuQryListBusiServiceImpl
implements SmcStocktakeSkuQryListBusiService {
    @Autowired
    private StockInfoMapper stockInfoMapper;
    @Autowired
    private SmcIntfSelectSkuAndSupListService smcIntfSelectSkuAndSupListService;
    @Autowired
    private ShopStorehouseRelMapper shopStorehouseRelMapper;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SmcStoreSkuQryListAbilityRspBO qryStocktakeSkuList(SmcStoreSkuQryListAbilityReqBO reqBO) {
        List<Long> storehouseIdList;
        ArrayList<StockSkuBO> stockSkuBOList;
        SmcStoreSkuQryListAbilityRspBO rspBO;
        block10: {
            rspBO = new SmcStoreSkuQryListAbilityRspBO();
            stockSkuBOList = new ArrayList<StockSkuBO>();
            storehouseIdList = new ArrayList();
            if (reqBO.isQryAllFlag()) {
                ShopStorehouseRelPO shopStorehouseRelPO = new ShopStorehouseRelPO();
                shopStorehouseRelPO.setShopId(reqBO.getShopId());
                List shopStorehouseRelPOS = this.shopStorehouseRelMapper.getList(shopStorehouseRelPO);
                if (shopStorehouseRelPOS != null && shopStorehouseRelPOS.size() > 0) {
                    for (ShopStorehouseRelPO po : shopStorehouseRelPOS) {
                        storehouseIdList.add(po.getStorehouseId());
                    }
                    break block10;
                } else {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u8be5\u95e8\u5e97\u65e0\u5546\u54c1\u8bb0\u5f55");
                    return rspBO;
                }
            }
            if (reqBO.getStorehouseIds() == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u95e8\u5e97\u65e0\u5546\u54c1\u8bb0\u5f55");
                return rspBO;
            }
            storehouseIdList = reqBO.getStorehouseIds();
        }
        StockInfoBO stockInfoBO = new StockInfoBO();
        stockInfoBO.setStorehouseList(storehouseIdList);
        List stockInfoBOList = this.stockInfoMapper.qryStoreListPageByCondNoPage(stockInfoBO);
        if (stockInfoBOList != null) {
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (stockInfoBOList.size() > 0) {
                for (StockInfoBO bo : stockInfoBOList) {
                    StockSkuBO stockSkuBO = new StockSkuBO();
                    BeanUtils.copyProperties((Object)bo, (Object)stockSkuBO);
                    if (bo.getTransNum() == null) {
                        stockSkuBO.setTransNum(Long.valueOf(0L));
                    } else {
                        stockSkuBO.setTransNum(bo.getTransNum());
                    }
                    stockSkuBO.setStorehouseId(bo.getStorehouseId() + "");
                    stockSkuBO.setRemainNum(bo.getUnsaleTotalNum());
                    stockSkuBO.setStorehouseName(this.qryStorehouseName(bo.getStorehouseId()));
                    stockSkuBOList.add(stockSkuBO);
                    skuList.add(bo.getSkuId());
                }
            }
            this.dealSkuInfo(stockSkuBOList, skuList);
        }
        rspBO.setRows(stockSkuBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealSkuInfo(List<StockSkuBO> stockInfoBOList, List<Long> skuIdList) {
        SmcIntfSelectSkuAndSupListReqBO reqBO = new SmcIntfSelectSkuAndSupListReqBO();
        reqBO.setSkuIds(skuIdList);
        reqBO.setPageSize(skuIdList.size());
        SmcIntfSelectSkuAndSupListRspBO rspBO = this.smcIntfSelectSkuAndSupListService.selectSkuAndSupList(reqBO);
        if (rspBO != null && rspBO.getRows() != null) {
            stockInfoBOList.forEach(item -> rspBO.getRows().forEach(sku -> {
                if (item.getSkuId().equals(sku.getSkuId())) {
                    item.setMaterialCode(sku.getMaterialId());
                    item.setSkuName(sku.getSkuName());
                    if (sku.getSkuPrice() != null) {
                        item.setSalePrice(new BigDecimal(sku.getSkuPrice()).divide(new BigDecimal(10000)));
                    }
                    item.setMaterialCode(sku.getMaterialId());
                    item.setSkuName(sku.getSkuName());
                    item.setSkuFullName(sku.getSkuLongName());
                    item.setSkuType(sku.getPurchaseTypeStr());
                    item.setBrand(sku.getBrandName());
                    item.setColor(sku.getColor());
                    item.setMemory(sku.getRam());
                    item.setZjm(sku.getExtSkuId());
                    item.setImsiFlag(sku.getHasSerialNumber());
                }
            }));
        }
    }

    private String qryStorehouseName(Long storeId) {
        StockhouseInfoPO housePO = new StockhouseInfoPO();
        housePO.setStorehouseId(storeId);
        StockhouseInfoPO resultPO = this.stockhouseInfoMapper.getModelBy(housePO);
        if (resultPO != null) {
            return resultPO.getStorehouseName();
        }
        return storeId + "";
    }
}

