/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityReqBO;
import com.tydic.smc.ability.bo.SmcStoreSkuQryListAbilityRspBO;
import com.tydic.smc.ability.bo.StockSkuBO;
import com.tydic.smc.api.commodity.SmcIntfSelectSkuAndSupListService;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListReqBO;
import com.tydic.smc.bo.commodity.SmcIntfSelectSkuAndSupListRspBO;
import com.tydic.smc.dao.ShopStorehouseRelMapper;
import com.tydic.smc.dao.StockInfoMapper;
import com.tydic.smc.dao.StockhouseInfoMapper;
import com.tydic.smc.exception.SmcBusinessException;
import com.tydic.smc.po.StockhouseInfoPO;
import com.tydic.smc.service.atom.SmcDicDictionaryAtomService;
import com.tydic.smc.service.atom.SmcQryStoreByUserAuthAtomService;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomReqBO;
import com.tydic.smc.service.atom.bo.SmcQryStoreByUserAuthAtomRspBO;
import com.tydic.smc.service.busi.SmcStoreSkuQryListBusiService;
import com.tydic.smc.service.busi.bo.StockInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcStoreSkuQryListBusiServiceImpl
implements SmcStoreSkuQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SmcStoreSkuQryListBusiServiceImpl.class);
    @Autowired
    private StockInfoMapper stockInfoMapper;
    @Autowired
    private SmcQryStoreByUserAuthAtomService smcQryStoreByUserAuthAtomService;
    @Autowired
    private StockhouseInfoMapper stockhouseInfoMapper;
    @Autowired
    private SmcIntfSelectSkuAndSupListService smcIntfSelectSkuAndSupListService;
    @Autowired
    private ShopStorehouseRelMapper shopStorehouseRelMapper;
    @Autowired
    private SmcDicDictionaryAtomService smcDicDictionaryAtomService;

    @Override
    public SmcStoreSkuQryListAbilityRspBO qryStoreSkuList(SmcStoreSkuQryListAbilityReqBO reqBO) {
        SmcStoreSkuQryListAbilityRspBO rspBO = new SmcStoreSkuQryListAbilityRspBO();
        ArrayList<StockSkuBO> stockSkuBOList = new ArrayList<StockSkuBO>();
        List<Long> storehouseIdList = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)reqBO.getCompanyId())) {
            StockhouseInfoPO stockhouseInfoPO = new StockhouseInfoPO();
            stockhouseInfoPO.setCompanyId(reqBO.getCompanyId());
            List stockhouseInfoPOList = this.stockhouseInfoMapper.getList(stockhouseInfoPO);
            if (stockhouseInfoPOList != null && stockhouseInfoPOList.size() > 0) {
                for (StockhouseInfoPO po : stockhouseInfoPOList) {
                    storehouseIdList.add(po.getStorehouseId());
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCompanyId()) && reqBO.getStorehouseId() == null) {
            SmcQryStoreByUserAuthAtomReqBO qryStoreByUserReqBO = new SmcQryStoreByUserAuthAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)qryStoreByUserReqBO);
            SmcQryStoreByUserAuthAtomRspBO qryStoreByUserRspBO = this.smcQryStoreByUserAuthAtomService.qryStorehouseListByUser(qryStoreByUserReqBO);
            if (qryStoreByUserRspBO != null && !"0000".equals(qryStoreByUserRspBO.getRespCode())) {
                throw new SmcBusinessException(qryStoreByUserRspBO.getRespCode(), qryStoreByUserRspBO.getRespDesc());
            }
            if (qryStoreByUserRspBO.getStorehouseIdList() != null) {
                storehouseIdList = qryStoreByUserRspBO.getStorehouseIdList();
            }
        }
        StockInfoBO stockInfoBO = new StockInfoBO();
        if (reqBO.getSkuId() != null) {
            stockInfoBO.setSkuId(reqBO.getSkuId());
        }
        if (reqBO.getMaterialCode() != null) {
            stockInfoBO.setMaterialCode(reqBO.getMaterialCode());
        }
        if (reqBO.getStorehouseId() != null) {
            stockInfoBO.setStorehouseId(reqBO.getStorehouseId());
        }
        if (storehouseIdList.size() > 0) {
            stockInfoBO.setStorehouseList(storehouseIdList);
        }
        if (reqBO.getCompanyId() != null) {
            stockInfoBO.setCompanyId(reqBO.getCompanyId());
        }
        List stockInfoBOList = null;
        if (reqBO.isPageQueryFlag()) {
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            stockInfoBOList = this.stockInfoMapper.qryStoreListPageByCond(stockInfoBO, page);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        } else {
            stockInfoBOList = this.stockInfoMapper.qryStoreListPageByCondWithoutPage(stockInfoBO);
        }
        if (stockInfoBOList != null) {
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (stockInfoBOList.size() > 0) {
                for (StockInfoBO bo : stockInfoBOList) {
                    StockSkuBO stockSkuBO = new StockSkuBO();
                    BeanUtils.copyProperties((Object)bo, (Object)stockSkuBO);
                    if (bo.getTransNum() == null) {
                        stockSkuBO.setTransNum(Long.valueOf(0L));
                    } else {
                        stockSkuBO.setTransNum(bo.getTransNum());
                    }
                    stockSkuBO.setRemainNum(bo.getUnsaleTotalNum());
                    stockSkuBO.setStorehouseId(bo.getStorehouseId() + "");
                    stockSkuBOList.add(stockSkuBO);
                    skuList.add(bo.getSkuId());
                }
            }
            this.dealSkuInfo(stockSkuBOList, skuList);
        }
        rspBO.setRows(stockSkuBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealSkuInfo(List<StockSkuBO> stockInfoBOList, List<Long> skuIdList) {
        SmcIntfSelectSkuAndSupListReqBO reqBO = new SmcIntfSelectSkuAndSupListReqBO();
        reqBO.setSkuIds(skuIdList);
        reqBO.setPageSize(skuIdList.size());
        SmcIntfSelectSkuAndSupListRspBO rspBO = this.smcIntfSelectSkuAndSupListService.selectSkuAndSupList(reqBO);
        if (rspBO != null && rspBO.getRows() != null) {
            stockInfoBOList.forEach(item -> rspBO.getRows().forEach(sku -> {
                if (item.getSkuId().equals(sku.getSkuId())) {
                    item.setSkuName(sku.getSkuName());
                    item.setMaterialCode(sku.getMaterialId());
                    if (sku.getSkuPrice() != null) {
                        item.setSalePrice(new BigDecimal(sku.getSkuPrice()).divide(new BigDecimal(10000)));
                    }
                    item.setMaterialCode(sku.getMaterialId());
                    item.setSkuName(sku.getSkuName());
                    item.setSkuFullName(sku.getSkuLongName());
                    item.setSkuType(sku.getPurchaseTypeStr());
                    item.setBrand(sku.getBrandName());
                    item.setColor(sku.getColor());
                    item.setMemory(sku.getRam());
                    item.setZjm(sku.getExtSkuId());
                    item.setImsiFlag(sku.getHasSerialNumber());
                }
            }));
        }
    }
}

