/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.smcsdk.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.tydic.smcsdk.api.SmcsdkRefreshRedisService;
import com.tydic.smcsdk.api.bo.SmcsdkRefreshRedisReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkRefreshRedisRspBO;
import com.tydic.smcsdk.dao.SmcsdkSkuStockInfoMapper;
import com.tydic.smcsdk.dao.po.SmcsdkSkuStockInfoPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmcsdkRefreshRedisServiceImpl
implements SmcsdkRefreshRedisService {
    private static final Logger log = LoggerFactory.getLogger(SmcsdkRefreshRedisServiceImpl.class);
    @Autowired
    private SmcsdkSkuStockInfoMapper smcsdkSkuStockInfoMapper;
    @Autowired
    private CacheClient cacheClient;

    public SmcsdkRefreshRedisRspBO refreshRedis(SmcsdkRefreshRedisReqBO smcsdkRefreshRedisReqBO) {
        SmcsdkRefreshRedisRspBO refreshRedisRspBO = new SmcsdkRefreshRedisRspBO();
        Page page = new Page(1, 2000);
        List<SmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOs = this.smcsdkSkuStockInfoMapper.getListByPage(smcsdkRefreshRedisReqBO, (Page<SmcsdkSkuStockInfoPO>)page);
        if (page.getTotalPages() == 1) {
            this.operateRedis(smcsdkSkuStockInfoPOs);
        } else if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                Page page1 = new Page(i, 2000);
                List<SmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOs1 = this.smcsdkSkuStockInfoMapper.getListByPage(smcsdkRefreshRedisReqBO, (Page<SmcsdkSkuStockInfoPO>)page1);
                this.operateRedis(smcsdkSkuStockInfoPOs1);
            }
        }
        refreshRedisRspBO.setRespCode("0000");
        refreshRedisRspBO.setRespDesc("\u6210\u529f");
        return refreshRedisRspBO;
    }

    private void operateRedis(List<SmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOs) {
        for (SmcsdkSkuStockInfoPO po : smcsdkSkuStockInfoPOs) {
            if (po.getUnsaleNum() == null) continue;
            String redisKey = "STOCK_SALE_NUM_" + po.getStockhouseId() + "_" + po.getSkuId();
            Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
            Long currenNum1 = this.cacheClient.incrBy(redisKey, po.getUnsaleNum() - currenNum);
            log.debug("reidsKey=" + redisKey + "\u5237\u65b0\u540e\u6570\u636e\u4e3a\uff1a" + currenNum1);
        }
    }
}

