/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.spool.config;

import com.tydic.dyc.spool.utils.SpoolSequence;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SpoolNodeConfig {
    private static final Logger log = LoggerFactory.getLogger(SpoolNodeConfig.class);
    static String name;
    static String containerName;

    public static void initSpoolNodeConfig(Environment environment) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return;
        }
        String osName = environment.getProperty("spool.transaction.os", "linux");
        String osNameNow = System.getProperty("os.name").toLowerCase(Locale.US);
        String containerName = osNameNow.contains(osName) ? environment.getProperty("HOSTNAME", environment.getProperty("spring.application.name", "spool-container")) : environment.getProperty("USERDOMAIN_ROAMINGPROFILE", environment.getProperty("spring.application.name", "spool-container"));
        String serverPort = environment.getProperty("server.port");
        String containerId = String.valueOf(SpoolSequence.nextId());
        String name = containerName + "-" + serverPort + "-" + containerId;
        SpoolNodeConfig.setName(name);
        SpoolNodeConfig.setContainerName(containerName);
        log.info("\u6d88\u606f\u6c60\u8282\u70b9\u4fe1\u606f\u521d\u59cb\u5316\uff1a{}", (Object)name);
    }

    public static void setName(String name) {
        SpoolNodeConfig.name = name;
    }

    public static String getName() {
        return name;
    }

    public static void setContainerName(String containerName) {
        SpoolNodeConfig.containerName = containerName;
    }

    public static String getContainerName() {
        return containerName;
    }
}

