/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.spool.subscribe;

import com.tydic.dyc.spool.config.SpoolNodeConfig;
import com.tydic.dyc.spool.subscribe.SpoolSubscribeFactoryBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SpoolSubscribeBeanRegistry
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpoolSubscribeBeanRegistry.class);
    private ApplicationContext applicationContext;
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        SpoolNodeConfig.initSpoolNodeConfig(this.environment);
        String types = this.environment.getProperty("spool.subscribe.types");
        if (StringUtils.isNotBlank((CharSequence)types)) {
            for (String type : types.split(",")) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SpoolSubscribeFactoryBean.class);
                AbstractBeanDefinition definition = builder.getRawBeanDefinition();
                definition.getPropertyValues().addPropertyValue("type", (Object)type);
                definition.setAutowireMode(2);
                registry.registerBeanDefinition(String.format("exteriorType%sMqConsumer", type), (BeanDefinition)definition);
            }
        } else {
            log.info("Spool types null");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

