/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.spool.model.rsp;

import com.tydic.dyc.spool.constant.SpoolCodeMsg;
import java.io.Serializable;

public class SpoolRspBo<T>
implements Serializable {
    private static final long serialVersionUID = -7205679255293823214L;
    private String respCode;
    private String respDesc;
    private T result;

    private SpoolRspBo(SpoolCodeMsg spoolCodeMsg, T data) {
        if (spoolCodeMsg != null) {
            this.setRespCode(spoolCodeMsg.getCode());
            this.setRespDesc(spoolCodeMsg.getMessage());
        }
        this.result = data;
    }

    public static <T> SpoolRspBo<T> success(T data) {
        return new SpoolRspBo<T>(SpoolCodeMsg.SUCCESS, data);
    }

    public static <T> SpoolRspBo<T> error(T data) {
        return new SpoolRspBo<T>(SpoolCodeMsg.ERROR, data);
    }

    public static <T> SpoolRspBo<T> notStart() {
        return new SpoolRspBo<T>(SpoolCodeMsg.NOT_START);
    }

    public static <T> SpoolRspBo<T> isStart() {
        return new SpoolRspBo<T>(SpoolCodeMsg.IS_START);
    }

    public static <T> SpoolRspBo<T> isStart(String msg) {
        return new SpoolRspBo<T>(msg + " " + SpoolCodeMsg.IS_START.getMessage());
    }

    public static SpoolRspBo<String> alreadyExists(String data) {
        return new SpoolRspBo<String>(SpoolCodeMsg.ALREADY_EXISTS, data + " " + SpoolCodeMsg.ALREADY_EXISTS.getMessage());
    }

    public static SpoolRspBo<String> notExists(String data) {
        return new SpoolRspBo<String>(SpoolCodeMsg.NOT_EXISTS, data + " " + SpoolCodeMsg.NOT_EXISTS.getMessage());
    }

    public static SpoolRspBo<String> creationFailed(String ex) {
        return new SpoolRspBo<String>(SpoolCodeMsg.CREATION_FAILED, ex);
    }

    public static SpoolRspBo<String> changeFailed(String ex) {
        return new SpoolRspBo<String>(SpoolCodeMsg.CHANGE_FAILED, ex);
    }

    public static <T> SpoolRspBo<T> error(SpoolCodeMsg spoolCodeMsg) {
        return new SpoolRspBo<T>(spoolCodeMsg);
    }

    public static <T> SpoolRspBo<T> error(SpoolCodeMsg spoolCodeMsg, T data) {
        return new SpoolRspBo<T>(spoolCodeMsg, data);
    }

    private SpoolRspBo(T data) {
        this.result = data;
    }

    private SpoolRspBo(String code, String message) {
        this.setRespCode(code);
        this.setRespDesc(message);
    }

    private SpoolRspBo(SpoolCodeMsg spoolCodeMsg) {
        if (spoolCodeMsg != null) {
            this.setRespCode(spoolCodeMsg.getCode());
            this.setRespDesc(spoolCodeMsg.getMessage());
        }
    }

    private SpoolRspBo(String message) {
        this.setRespCode(SpoolCodeMsg.ERROR.getCode());
        this.setRespDesc(message);
    }

    public String getRespCode() {
        return this.respCode;
    }

    public String getRespDesc() {
        return this.respDesc;
    }

    public T getResult() {
        return this.result;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public void setRespDesc(String respDesc) {
        this.respDesc = respDesc;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpoolRspBo)) {
            return false;
        }
        SpoolRspBo other = (SpoolRspBo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$respCode = this.getRespCode();
        String other$respCode = other.getRespCode();
        if (this$respCode == null ? other$respCode != null : !this$respCode.equals(other$respCode)) {
            return false;
        }
        String this$respDesc = this.getRespDesc();
        String other$respDesc = other.getRespDesc();
        if (this$respDesc == null ? other$respDesc != null : !this$respDesc.equals(other$respDesc)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpoolRspBo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $respCode = this.getRespCode();
        result = result * 59 + ($respCode == null ? 43 : $respCode.hashCode());
        String $respDesc = this.getRespDesc();
        result = result * 59 + ($respDesc == null ? 43 : $respDesc.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "SpoolRspBo(respCode=" + this.getRespCode() + ", respDesc=" + this.getRespDesc() + ", result=" + this.getResult() + ")";
    }

    public SpoolRspBo() {
    }
}

