/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.busi.SscCreateProjectNoBusiService;
import com.tydic.ssc.service.busi.bo.SscCreateProjectNoBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscCreateProjectNoBusiRspBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscCreateProjectNoBusiServiceImpl
implements SscCreateProjectNoBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscCreateProjectNoBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    private static int retryNum = 0;

    @Override
    public SscCreateProjectNoBusiRspBO createProjectNo(SscCreateProjectNoBusiReqBO reqBO) {
        SscCreateProjectNoBusiRspBO rspBO;
        block4: {
            rspBO = new SscCreateProjectNoBusiRspBO();
            String projectNo = this.sscProjectDAO.getMaxProjectNo();
            String maxProjectNo = "";
            if (StringUtils.isEmpty((Object)projectNo)) {
                maxProjectNo = "001";
            } else {
                String currentNo = projectNo.substring(projectNo.length() - 3, projectNo.length());
                Integer intNO = Integer.valueOf(currentNo);
                maxProjectNo = (intNO = Integer.valueOf(intNO + 1)) < 999 ? (intNO < 10 ? "00" + intNO : (intNO < 100 ? "0" + intNO : "" + intNO)) : "001";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("YYMMDDHHmm");
            String dateStr = dateFormat.format(new Date());
            dateStr = "ZTB" + dateStr + maxProjectNo;
            SscProjectPO sscProjectPO = new SscProjectPO();
            sscProjectPO.setProjectProducerId(reqBO.getMemId());
            sscProjectPO.setProjectProducerName(reqBO.getMemName() == null ? null : reqBO.getMemName().toString());
            sscProjectPO.setProjectProducerUnitId(reqBO.getCompanyId());
            sscProjectPO.setProjectProducerUnitName(reqBO.getCompanyName());
            sscProjectPO.setProjectProducerDepartmentId(reqBO.getOrgId());
            sscProjectPO.setProjectProducerDepartmentName(reqBO.getOrgName());
            sscProjectPO.setProjectNo(dateStr);
            sscProjectPO.setProjectId(Sequence.getInstance().nextId());
            try {
                this.sscProjectDAO.insertSelective(sscProjectPO);
            }
            catch (Exception e) {
                if (retryNum >= 10) break block4;
                ++retryNum;
                this.createProjectNo(reqBO);
            }
        }
        rspBO.setProjectId(rspBO.getProjectId());
        rspBO.setProjectNo(rspBO.getProjectNo());
        rspBO.setRespDesc("\u9879\u76ee\u7f16\u53f7\u751f\u6210\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

