/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectNoticeInfoBO;
import com.tydic.ssc.dao.SscProjectNoticeDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryNoticeListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryNoticeListBusiRspBO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryNoticeListBusiServiceImpl
implements SscQryNoticeListBusiService {
    @Autowired
    private SscProjectNoticeDAO sscProjectNoticeDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryNoticeListBusiRspBO qryNoticeList(SscQryNoticeListBusiReqBO reqBO) {
        SscQryNoticeListBusiRspBO rspBO = new SscQryNoticeListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectNoticeInfoBO> sscProjectNoticeInfoBOS = this.sscProjectNoticeDAO.getNoticeList(reqBO, (Page<SscProjectNoticeInfoBO>)page);
        if (CollectionUtils.isEmpty(sscProjectNoticeInfoBOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u516c\u544a\u5217\u8868\u4e3a\u7a7a");
            return rspBO;
        }
        this.translateField(sscProjectNoticeInfoBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProjectNoticeInfoBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u516c\u544a\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void translateField(List<SscProjectNoticeInfoBO> sscProjectNoticeInfoBOS) {
        Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_MODE");
        Map<String, String> noticeModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "NOTICE_TYPE");
        for (SscProjectNoticeInfoBO sscProjectNoticeInfoBO : sscProjectNoticeInfoBOS) {
            if (StringUtils.isNotBlank((CharSequence)sscProjectNoticeInfoBO.getNoticeType())) {
                sscProjectNoticeInfoBO.setNoticeTypeStr(noticeModeMap.get(sscProjectNoticeInfoBO.getNoticeType()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectNoticeInfoBO.getPurchaseMode())) {
                sscProjectNoticeInfoBO.setPurchaseModeStr(purchaseModeMap.get(sscProjectNoticeInfoBO.getPurchaseMode()));
            }
            if (!StringUtils.isNotBlank((CharSequence)sscProjectNoticeInfoBO.getTenderMode())) continue;
            sscProjectNoticeInfoBO.setTenderModeStr(tenderModeMap.get(sscProjectNoticeInfoBO.getTenderMode()));
        }
    }
}

