/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscScoreItemCodeBO;
import com.tydic.ssc.common.SscScoreItemTypeBO;
import com.tydic.ssc.common.SscScoreRuleTemplateDetailBO;
import com.tydic.ssc.dao.SscScoreRuleTemplateDetailDAO;
import com.tydic.ssc.dao.po.SscScoreRuleTemplateDetailPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQryScoreRuleTemplateDetailAbilityBusiService;
import com.tydic.ssc.service.busi.bo.SscQryScoreRuleTemplateDetailAbilityBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryScoreRuleTemplateDetailAbilityBusiRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryScoreRuleTemplateDetailAbilityBusiServiceImpl
implements SscQryScoreRuleTemplateDetailAbilityBusiService {
    @Autowired
    private SscScoreRuleTemplateDetailDAO sscScoreRuleTemplateDetailDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;
    private List<SscScoreItemTypeBO> typeBOS = new ArrayList<SscScoreItemTypeBO>(10);
    private Map<String, List<SscScoreItemCodeBO>> codeBOMap = new HashMap<String, List<SscScoreItemCodeBO>>(16);
    private Map<String, List<SscScoreRuleTemplateDetailBO>> detailBOMap = new HashMap<String, List<SscScoreRuleTemplateDetailBO>>(16);

    @Override
    public SscQryScoreRuleTemplateDetailAbilityBusiRspBO qryScoreRuleTemplateDetail(SscQryScoreRuleTemplateDetailAbilityBusiReqBO reqBO) {
        List<SscScoreRuleTemplateDetailPO> listResult = this.sscScoreRuleTemplateDetailDAO.listByScoreRuleTemplateId(reqBO.getScoreRuleTemplateId());
        if (CollectionUtils.isEmpty(listResult)) {
            throw new BusinessException("8888", "\u8bc4\u5206\u89c4\u5219\u6a21\u677f\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 - \u6a21\u677f\u660e\u7ec6\u4e3a\u7a7a");
        }
        this.typeBOS.clear();
        this.codeBOMap.clear();
        this.detailBOMap.clear();
        Map<String, String> map = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "Score_Item_Type");
        this.format(listResult, map);
        SscQryScoreRuleTemplateDetailAbilityBusiRspBO rspBO = new SscQryScoreRuleTemplateDetailAbilityBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(this.typeBOS);
        return rspBO;
    }

    private void format(List<SscScoreRuleTemplateDetailPO> listResult, Map<String, String> map) {
        for (SscScoreRuleTemplateDetailPO bo : listResult) {
            if (this.codeBOMap.containsKey(bo.getScoreItemType())) {
                SscScoreItemCodeBO codeBO = new SscScoreItemCodeBO();
                codeBO.setScoreItemCode(bo.getScoreItemCode());
                codeBO.setScoreItemName(bo.getScoreItemName());
                codeBO.setScoreItemWeight(bo.getScoreItemWeight());
                this.addDetailBOSMap(bo, codeBO);
                continue;
            }
            ArrayList<SscScoreItemCodeBO> codeBOS = new ArrayList<SscScoreItemCodeBO>(10);
            ArrayList<SscScoreRuleTemplateDetailBO> detailBOS = new ArrayList<SscScoreRuleTemplateDetailBO>();
            SscScoreItemTypeBO typeBO = new SscScoreItemTypeBO();
            typeBO.setScoreItemType(bo.getScoreItemType());
            typeBO.setScoreItemTypeStr(map.get(bo.getScoreItemType()));
            typeBO.setSscScoreItemCodeBOs(codeBOS);
            SscScoreItemCodeBO codeBO = new SscScoreItemCodeBO();
            codeBO.setScoreItemCode(bo.getScoreItemCode());
            codeBO.setScoreItemName(bo.getScoreItemName());
            codeBO.setScoreItemWeight(bo.getScoreItemWeight());
            codeBO.setSscScoreRuleTemplateDetailBOs(detailBOS);
            SscScoreRuleTemplateDetailBO detailBO = (SscScoreRuleTemplateDetailBO)JSON.parseObject((String)JSON.toJSONString((Object)bo), SscScoreRuleTemplateDetailBO.class);
            detailBOS.add(detailBO);
            codeBOS.add(codeBO);
            this.typeBOS.add(typeBO);
            this.codeBOMap.put(bo.getScoreItemType(), codeBOS);
            this.detailBOMap.put(bo.getScoreItemName(), detailBOS);
        }
    }

    private void addDetailBOSMap(SscScoreRuleTemplateDetailPO bo, SscScoreItemCodeBO codeBO) {
        if (this.detailBOMap.containsKey(bo.getScoreItemName())) {
            String reqJson = JSON.toJSONString((Object)bo);
            SscScoreRuleTemplateDetailBO detailBO = (SscScoreRuleTemplateDetailBO)JSON.parseObject((String)reqJson, SscScoreRuleTemplateDetailBO.class);
            this.detailBOMap.get(bo.getScoreItemName()).add(detailBO);
        } else {
            ArrayList<SscScoreRuleTemplateDetailBO> detailBOS = new ArrayList<SscScoreRuleTemplateDetailBO>(10);
            codeBO.setSscScoreRuleTemplateDetailBOs(detailBOS);
            this.codeBOMap.get(bo.getScoreItemType()).add(codeBO);
            this.detailBOMap.put(bo.getScoreItemName(), detailBOS);
            String reqJson = JSON.toJSONString((Object)bo);
            SscScoreRuleTemplateDetailBO detailBO = (SscScoreRuleTemplateDetailBO)JSON.parseObject((String)reqJson, SscScoreRuleTemplateDetailBO.class);
            detailBOS.add(detailBO);
        }
    }
}

