/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAndSupplierStageBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQrySupplierStageListBusiService;
import com.tydic.ssc.service.busi.bo.SscQrySupplierStageListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQrySupplierStageListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQrySupplierStageListBusiServiceImpl
implements SscQrySupplierStageListBusiService {
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;

    @Override
    public SscQrySupplierStageListBusiRspBO qrySupplierStageList(SscQrySupplierStageListBusiReqBO reqBO) {
        SscQrySupplierStageListBusiRspBO rspBO = new SscQrySupplierStageListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectAndSupplierStageBO> sscProjectAndSupplierStageBOS = this.sscSupplierStageDAO.getSupplierStageList(reqBO, (Page<SscProjectAndSupplierStageBO>)page);
        if (CollectionUtils.isEmpty(sscProjectAndSupplierStageBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u6807\u6bb5\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getProjectId).collect(Collectors.toList());
            List<Long> stageIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getStageId).collect(Collectors.toList());
            List<Long> supplierStageIds = sscProjectAndSupplierStageBOS.stream().map(SscProjectAndSupplierStageBO::getSupplierStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            SscQryProjectExtAtomReqBO sscQryProjectStageExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectStageExtAtomReqBO.setProjectObjectType("2");
            sscQryProjectStageExtAtomReqBO.setProjectObjectIds(stageIds);
            SscQryProjectExtAtomRspBO sscQryProjectStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectStageExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectStageExtMap = sscQryProjectStageExtAtomRspBO.getSscProjectExtMap();
            SscQryProjectExtAtomReqBO sscQryProjectSupStageExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectSupStageExtAtomReqBO.setProjectObjectType("6");
            sscQryProjectSupStageExtAtomReqBO.setProjectObjectIds(supplierStageIds);
            SscQryProjectExtAtomRspBO sscQryProjectSupStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectSupStageExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectSupStageExtMap = sscQryProjectSupStageExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectSupStageExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setStageSupplierExtMap(sscProjectSupStageExtMap.get(supplierStageBO.getSupplierStageId()));
                }
            }
            if (null != sscProjectStageExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setProjectStageExtMap(sscProjectStageExtMap.get(supplierStageBO.getStageId()));
                }
            }
            if (null != sscProjectExtMap) {
                for (SscProjectAndSupplierStageBO supplierStageBO : sscProjectAndSupplierStageBOS) {
                    supplierStageBO.setSscProjectExtMap(sscProjectSupStageExtMap.get(supplierStageBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectAndSupplierStageBOS);
        }
        rspBO.setRows(sscProjectAndSupplierStageBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u6807\u6bb5\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectAndSupplierStageBO> supplierStageBOS) {
        for (SscProjectAndSupplierStageBO supplierStageBO : supplierStageBOS) {
            String purchaseMode;
            String projectStatus = supplierStageBO.getProjectStatus();
            if ("1".equals(projectStatus)) {
                supplierStageBO.setProjectStatusStr("\u6709\u6548");
            }
            if ("1".equals(purchaseMode = supplierStageBO.getPurchaseMode())) {
                supplierStageBO.setPurchaseModeStr("\u62db\u6295\u6807");
            } else if ("2".equals(purchaseMode)) {
                supplierStageBO.setPurchaseModeStr("\u8be2\u6bd4\u4ef7");
            } else if ("3".equals(purchaseMode)) {
                supplierStageBO.setPurchaseModeStr("\u7ade\u4ef7");
            } else if ("4".equals(purchaseMode)) {
                supplierStageBO.setPurchaseModeStr("\u8bae\u4ef7");
            }
            String tenderMode = supplierStageBO.getTenderMode();
            if ("1".equals(tenderMode)) {
                supplierStageBO.setTenderModeStr("\u516c\u5f00");
            } else if ("2".equals(tenderMode)) {
                supplierStageBO.setTenderModeStr("\u9080\u8bf7");
            }
            String quotationMode = supplierStageBO.getQuotationMode();
            if ("1".equals(quotationMode)) {
                supplierStageBO.setQuotationModeStr("\u6574\u5355");
            } else if ("2".equals(quotationMode)) {
                supplierStageBO.setQuotationModeStr("\u5355\u9879");
            }
            String isNeedMargin = supplierStageBO.getIsNeedMargin();
            if ("0".equals(isNeedMargin)) {
                supplierStageBO.setIsNeedMarginStr("\u5426");
            } else if ("1".equals(isNeedMargin)) {
                supplierStageBO.setIsNeedMarginStr("\u662f");
            }
            String budgetPublic = supplierStageBO.getBudgetPublic();
            if ("1".equals(budgetPublic)) {
                supplierStageBO.setBudgetPublicStr("\u4eba\u6c11\u5e01");
            } else if ("2".equals(budgetPublic)) {
                supplierStageBO.setBudgetPublicStr("\u7f8e\u5143");
            }
            String stageSupplierStatus = supplierStageBO.getStageSupplierStatus();
            if ("1".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u9080\u8bf7");
            } else if ("2".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u62a5\u540d");
            } else if ("3".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u672a\u5165\u56f4");
            } else if ("4".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u5165\u56f4");
            } else if ("5".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u6295\u6807");
            } else if ("6".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u62a5\u4ef7");
            } else if ("7".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u5df2\u4e2d\u6807");
            } else if ("8".equals(stageSupplierStatus)) {
                supplierStageBO.setStageSupplierStatusStr("\u672a\u4e2d\u6807");
            }
            String stageMarginStatus = supplierStageBO.getStageMarginStatus();
            if ("1".equals(stageMarginStatus)) {
                supplierStageBO.setStageMarginStatusStr("\u5df2\u7f34\u7eb3");
                continue;
            }
            if ("2".equals(stageMarginStatus)) {
                supplierStageBO.setStageMarginStatusStr("\u672a\u7f34\u7eb3");
                continue;
            }
            if (!"3".equals(stageMarginStatus)) continue;
            supplierStageBO.setStageMarginStatusStr("\u5df2\u9000\u8fd8");
        }
    }
}

