/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryToSignUpProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpProjectListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryToSignUpProjectListBusiServiceImpl
implements SscQryToSignUpProjectListBusiService {
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;

    @Override
    public SscQryToSignUpProjectListBusiRspBO qryToSignUpProjectList(SscQryToSignUpProjectListBusiReqBO reqBO) {
        SscQryToSignUpProjectListBusiRspBO rspBO = new SscQryToSignUpProjectListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectBO> sscProjectBOS = this.sscSupplierStageDAO.getToSignUpProjectList(reqBO, (Page<SscProjectBO>)page);
        if (CollectionUtils.isEmpty(sscProjectBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u9879\u76ee\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectBOS.stream().map(SscProjectBO::getProjectId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProjectBO sscProjectBO : sscProjectBOS) {
                    sscProjectBO.setSscProjectExtMap(sscProjectExtMap.get(sscProjectBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectBOS);
        }
        rspBO.setRows(sscProjectBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u9879\u76ee\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectBO> sscProjectBOS) {
        for (SscProjectBO sscProjectBO : sscProjectBOS) {
            String purchaseMode;
            String projectStatus = sscProjectBO.getProjectStatus();
            if ("1".equals(projectStatus)) {
                sscProjectBO.setProjectStatusStr("\u6709\u6548");
            }
            if ("1".equals(purchaseMode = sscProjectBO.getPurchaseMode())) {
                sscProjectBO.setPurchaseModeStr("\u62db\u6295\u6807");
            } else if ("2".equals(purchaseMode)) {
                sscProjectBO.setPurchaseModeStr("\u8be2\u6bd4\u4ef7");
            } else if ("3".equals(purchaseMode)) {
                sscProjectBO.setPurchaseModeStr("\u7ade\u4ef7");
            } else if ("4".equals(purchaseMode)) {
                sscProjectBO.setPurchaseModeStr("\u8bae\u4ef7");
            }
            String tenderMode = sscProjectBO.getTenderMode();
            if ("1".equals(tenderMode)) {
                sscProjectBO.setTenderModeStr("\u516c\u5f00");
            } else if ("2".equals(tenderMode)) {
                sscProjectBO.setTenderModeStr("\u9080\u8bf7");
            }
            String quotationMode = sscProjectBO.getQuotationMode();
            if ("1".equals(quotationMode)) {
                sscProjectBO.setQuotationModeStr("\u6574\u5355");
            } else if ("2".equals(quotationMode)) {
                sscProjectBO.setQuotationModeStr("\u5355\u9879");
            }
            String isNeedMargin = sscProjectBO.getIsNeedMargin();
            if ("0".equals(isNeedMargin)) {
                sscProjectBO.setIsNeedMarginStr("\u5426");
            } else if ("1".equals(isNeedMargin)) {
                sscProjectBO.setIsNeedMarginStr("\u662f");
            }
            String budgetPublic = sscProjectBO.getBudgetPublic();
            if ("1".equals(budgetPublic)) {
                sscProjectBO.setBudgetPublicStr("\u4eba\u6c11\u5e01");
                continue;
            }
            if (!"2".equals(budgetPublic)) continue;
            sscProjectBO.setBudgetPublicStr("\u7f8e\u5143");
        }
    }
}

