/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAndStageBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryToSignUpStageListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpStageListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpStageListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryToSignUpStageListBusiServiceImpl
implements SscQryToSignUpStageListBusiService {
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;

    @Override
    public SscQryToSignUpStageListBusiRspBO qryToSignUpStageList(SscQryToSignUpStageListBusiReqBO reqBO) {
        SscQryToSignUpStageListBusiRspBO rspBO = new SscQryToSignUpStageListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectAndStageBO> sscProjectAndStageBOS = this.sscSupplierStageDAO.getToSignUpStageList(reqBO, (Page<SscProjectAndStageBO>)page);
        if (CollectionUtils.isEmpty(sscProjectAndStageBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u6807\u6bb5\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectAndStageBOS.stream().map(SscProjectAndStageBO::getProjectId).collect(Collectors.toList());
            List<Long> stageIds = sscProjectAndStageBOS.stream().map(SscProjectAndStageBO::getStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
                    sscProjectAndStageBO.setSscProjectExtMap(sscProjectExtMap.get(sscProjectAndStageBO.getProjectId()));
                }
            }
            sscQryProjectExtAtomReqBO.setProjectObjectType("2");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(stageIds);
            SscQryProjectExtAtomRspBO sscQryStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscStageExtMap = sscQryStageExtAtomRspBO.getSscProjectExtMap();
            if (null != sscStageExtMap) {
                for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
                    sscProjectAndStageBO.setProjectStageExtMap(sscProjectExtMap.get(sscProjectAndStageBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectAndStageBOS);
        }
        rspBO.setRows(sscProjectAndStageBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u6807\u6bb5\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectAndStageBO> sscProjectAndStageBOS) {
        for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
            String tenderMode;
            String purchaseMode = sscProjectAndStageBO.getPurchaseMode();
            if ("1".equals(purchaseMode)) {
                sscProjectAndStageBO.setPurchaseModeStr("\u62db\u6295\u6807");
            } else if ("2".equals(purchaseMode)) {
                sscProjectAndStageBO.setPurchaseModeStr("\u8be2\u6bd4\u4ef7");
            } else if ("3".equals(purchaseMode)) {
                sscProjectAndStageBO.setPurchaseModeStr("\u7ade\u4ef7");
            } else if ("4".equals(purchaseMode)) {
                sscProjectAndStageBO.setPurchaseModeStr("\u8bae\u4ef7");
            }
            String projectStatus = sscProjectAndStageBO.getProjectStatus();
            if ("1".equals(projectStatus)) {
                sscProjectAndStageBO.setProjectStatusStr("\u6709\u6548");
            }
            if ("1".equals(tenderMode = sscProjectAndStageBO.getTenderMode())) {
                sscProjectAndStageBO.setTenderModeStr("\u516c\u5f00");
            } else if ("2".equals(tenderMode)) {
                sscProjectAndStageBO.setTenderModeStr("\u9080\u8bf7");
            }
            String quotationMode = sscProjectAndStageBO.getQuotationMode();
            if ("1".equals(quotationMode)) {
                sscProjectAndStageBO.setQuotationModeStr("\u6574\u5355");
            } else if ("2".equals(quotationMode)) {
                sscProjectAndStageBO.setQuotationModeStr("\u5355\u9879");
            }
            String isNeedMargin = sscProjectAndStageBO.getIsNeedMargin();
            if ("0".equals(isNeedMargin)) {
                sscProjectAndStageBO.setIsNeedMarginStr("\u5426");
            } else if ("1".equals(isNeedMargin)) {
                sscProjectAndStageBO.setIsNeedMarginStr("\u662f");
            }
            String budgetPublic = sscProjectAndStageBO.getBudgetPublic();
            if ("1".equals(budgetPublic)) {
                sscProjectAndStageBO.setBudgetPublicStr("\u4eba\u6c11\u5e01");
                continue;
            }
            if (!"2".equals(budgetPublic)) continue;
            sscProjectAndStageBO.setBudgetPublicStr("\u7f8e\u5143");
        }
    }
}

