/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscAuditBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscAuditDAO;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.po.SscAuditPO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscSelectSupplierApprovalBusiService;
import com.tydic.ssc.service.busi.bo.SscSelectSupplierApprovalBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSelectSupplierApprovalBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscSelectSupplierApprovalBusiServiceImpl
implements SscSelectSupplierApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscSelectSupplierApprovalBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;
    @Autowired
    private SscAuditDAO sscAuditDAO;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;

    @Override
    public SscSelectSupplierApprovalBusiRspBO dealSelectSupplierApproval(SscSelectSupplierApprovalBusiReqBO busiReqBO) {
        SscSelectSupplierApprovalBusiRspBO rsp = new SscSelectSupplierApprovalBusiRspBO();
        Map<Long, Long> auditProjectMap = this.getToAudiId(busiReqBO.getProjectIds());
        Map<String, Set<Long>> stepProjectIdMap = this.validProjectInfo(busiReqBO, auditProjectMap.keySet());
        for (String stepId : stepProjectIdMap.keySet()) {
            busiReqBO.setToApprovalIds(new ArrayList<Long>((Collection)stepProjectIdMap.get(stepId)));
            Boolean processEndFlag = this.invokeProcess(busiReqBO, stepId);
            if (!processEndFlag.booleanValue()) continue;
            for (Long toApprovalId : busiReqBO.getToApprovalIds()) {
                SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
                sscDealStatusCirculationConfAtomReqBO.setProjectId(auditProjectMap.get(toApprovalId));
                sscDealStatusCirculationConfAtomReqBO.setId(auditProjectMap.get(toApprovalId));
                sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
                SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
                if ("0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) continue;
                throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5165\u56f4\u4f9b\u5e94\u5546\u5ba1\u6279\u6210\u529f\uff01");
        return rsp;
    }

    private Map<Long, Long> getToAudiId(List<Long> projectIds) {
        HashMap<Long, Long> auditProjectMap = new HashMap<Long, Long>();
        SscProjectApprovalPO wherePO = new SscProjectApprovalPO();
        wherePO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        wherePO.setProjectIds(projectIds);
        List<SscProjectApprovalPO> toApprovalIds = this.sscProjectApprovalDAO.getToApprovalIds(wherePO);
        if (toApprovalIds.size() != projectIds.size()) {
            throw new BusinessException("8888", "\u5b58\u5728\u9879\u76eeId\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u5355\u5173\u8054Id!");
        }
        for (SscProjectApprovalPO po : toApprovalIds) {
            auditProjectMap.put(po.getToApprovalId(), po.getProjectId());
        }
        return auditProjectMap;
    }

    private Boolean invokeProcess(SscSelectSupplierApprovalBusiReqBO busiReqBO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setObjId(busiReqBO.getToApprovalIds());
        uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(busiReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(busiReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditOrderAuditReqBO.setUsername(busiReqBO.getOperName());
        uacNoTaskAuditOrderAuditReqBO.setOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditOrderAuditReqBO.setObjType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
        if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private Map<String, Set<Long>> validProjectInfo(SscSelectSupplierApprovalBusiReqBO busiReqBO, Set<Long> toApprovalIds) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectIds(busiReqBO.getProjectIds());
        List<SscProjectPO> sscProjectPOs = this.sscProjectDAO.getList(whereProjectPO);
        if (CollectionUtils.isEmpty(sscProjectPOs)) {
            throw new BusinessException("8888", "\u9879\u76ee\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> statusErrors = new HashSet<Long>();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (SscProjectPO po : sscProjectPOs) {
            if (!"7".equals(po.getProjectStatus())) {
                statusErrors.add(po.getProjectId());
            }
            projectIds.add(po.getProjectId());
        }
        if (statusErrors.size() > 0) {
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + ((Object)statusErrors).toString() + "\u3011\u72b6\u6001\u4e0d\u662f\u5ba1\u6838\u4e2d");
        }
        if (projectIds.size() < busiReqBO.getProjectIds().size()) {
            busiReqBO.getProjectIds().removeAll(projectIds);
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + busiReqBO.getProjectIds() + "\u3011\u4e0d\u5b58\u5728");
        }
        SscAuditPO sscAuditPO = new SscAuditPO();
        sscAuditPO.setObjType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        sscAuditPO.setObjIds(toApprovalIds);
        sscAuditPO.setTabValue(1);
        sscAuditPO.setStationCodes(busiReqBO.getStationCodes());
        List<SscAuditBO> sscAuditBOs = this.sscAuditDAO.getAuditInfoByObjIds(sscAuditPO);
        if (CollectionUtils.isEmpty(sscAuditBOs)) {
            throw new BusinessException("8888", "\u9879\u76ee\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        HashSet stepIds = new HashSet();
        HashSet<Long> auditSize = new HashSet<Long>();
        Object stepId = null;
        for (SscAuditBO bo : sscAuditBOs) {
            HashSet<Long> projectIdSet = (HashSet<Long>)result.get(bo.getStepId());
            if (null == projectIdSet) {
                projectIdSet = new HashSet<Long>();
            }
            projectIdSet.add(bo.getObjId());
            result.put(bo.getStepId(), projectIdSet);
            auditSize.add(bo.getObjId());
        }
        if (auditSize.size() < busiReqBO.getProjectIds().size()) {
            busiReqBO.getProjectIds().removeAll(auditSize);
            throw new BusinessException("8888", "\u9879\u76ee\u3010" + busiReqBO.getProjectIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
        }
        return result;
    }
}

