/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.ssc.ability.SscQryNoticeIsSubscribeAbilityService;
import com.tydic.ssc.ability.bo.SscQryNoticeIsSubscribeAbilityReqBO;
import com.tydic.ssc.ability.bo.SscQryNoticeIsSubscribeAbilityRspBO;
import com.tydic.ssc.dao.SscSupplierCollectionDAO;
import com.tydic.ssc.dao.po.SscQryNoticeIsSubscribePO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="SSC_GROUP_PROD", serviceInterface=SscQryNoticeIsSubscribeAbilityService.class)
public class SscQryNoticeIsSubscribeAbilityServiceImpl
implements SscQryNoticeIsSubscribeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SscQryNoticeIsSubscribeAbilityServiceImpl.class);
    @Autowired
    private SscSupplierCollectionDAO sscSupplierCollectionDAO;

    public SscQryNoticeIsSubscribeAbilityRspBO querySubNoticeList(SscQryNoticeIsSubscribeAbilityReqBO reqBO) {
        this.validate(reqBO);
        SscQryNoticeIsSubscribePO po = new SscQryNoticeIsSubscribePO();
        po.setNoticeIds(reqBO.getNoticeIds());
        po.setSupplierId(reqBO.getSupplierId());
        po.setType("10");
        List<Long> subNoticeIdList = this.sscSupplierCollectionDAO.getSubNoticeIdList(po);
        log.info("\u5df2\u7ecf\u6536\u85cf\u7684noticeId\uff1a" + subNoticeIdList);
        List<Long> supplierCollectionIdList = this.sscSupplierCollectionDAO.getSupplierCollectionIdList(po);
        log.info("\u5bf9\u5e94\u7684supplierCollectionId\uff1a" + supplierCollectionIdList);
        SscQryNoticeIsSubscribeAbilityRspBO rspBO = new SscQryNoticeIsSubscribeAbilityRspBO();
        rspBO.setNoticeIds(subNoticeIdList);
        rspBO.setSupplierCollectionIds(supplierCollectionIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5df2\u6536\u85cf\u7684\u516c\u544aid\u6210\u529f");
        return rspBO;
    }

    public void validate(SscQryNoticeIsSubscribeAbilityReqBO reqBO) {
        if (reqBO.getSupplierId() == null) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
        }
        if (reqBO.getNoticeIds() == null || reqBO.getNoticeIds().size() == 0) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165NoticeId");
        }
    }
}

