/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityReqBO;
import com.tydic.ssc.ability.bo.SscDicDictionaryAbilityRspBO;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscDicDictionaryBO;
import com.tydic.ssc.dao.SscDicDictionaryDAO;
import com.tydic.ssc.dao.po.SscDicDictionaryPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscDicDictionaryAtomServiceImpl
implements SscDicDictionaryAtomService {
    @Autowired
    private SscDicDictionaryDAO sscDicDictionaryDAO;
    @Autowired
    private CacheClient cacheService;

    @Override
    public Map<String, String> queryDictBySysCodeAndPcode(String sysCode, String pCode) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = sysCode + "_" + pCode + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            if (!CollectionUtils.isEmpty((Collection)dicDictionary)) {
                for (SscDicDictionaryBO bo : dicDictionary) {
                    result.put(bo.getCode(), bo.getTitle());
                }
            }
        } else {
            SscDicDictionaryPO dictionaryPO = new SscDicDictionaryPO();
            dictionaryPO.setpCode(pCode);
            dictionaryPO.setSysCode(sysCode);
            List<SscDicDictionaryPO> SscDicDictionaryPOList = this.sscDicDictionaryDAO.getListByCondition(dictionaryPO);
            if (!CollectionUtils.isEmpty(SscDicDictionaryPOList)) {
                ArrayList<SscDicDictionaryBO> temp = new ArrayList<SscDicDictionaryBO>();
                for (SscDicDictionaryPO dicPO : SscDicDictionaryPOList) {
                    SscDicDictionaryBO bo = new SscDicDictionaryBO();
                    BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                    temp.add(bo);
                    result.put(dicPO.getCode(), dicPO.getTitle());
                }
                this.cacheService.set(redisKey, temp);
            }
        }
        return result;
    }

    @Override
    public SscDicDictionaryAbilityRspBO queryDictBOBySysCodeAndPcode(SscDicDictionaryAbilityReqBO abilityReqBO) {
        SscDicDictionaryAbilityRspBO rsp = new SscDicDictionaryAbilityRspBO();
        ArrayList<SscDicDictionaryBO> result = new ArrayList<SscDicDictionaryBO>();
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getSysCode())) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getPCode())) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String redisKey = abilityReqBO.getSysCode() + "_" + abilityReqBO.getPCode() + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            rsp.setRows(dicDictionary);
            return rsp;
        }
        SscDicDictionaryPO dictionaryPO = new SscDicDictionaryPO();
        dictionaryPO.setpCode(abilityReqBO.getPCode());
        dictionaryPO.setSysCode(abilityReqBO.getSysCode());
        List<SscDicDictionaryPO> SscDicDictionaryPOList = this.sscDicDictionaryDAO.getListByCondition(dictionaryPO);
        if (!CollectionUtils.isEmpty(SscDicDictionaryPOList)) {
            for (SscDicDictionaryPO dicPO : SscDicDictionaryPOList) {
                SscDicDictionaryBO bo = new SscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                result.add(bo);
            }
            this.cacheService.set(redisKey, result);
        }
        rsp.setRows(result);
        return rsp;
    }

    @Override
    public String queryDictBySysCodeAndPcodeAndCode(String sysCode, String pCode, String code) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)sysCode)) {
            throw new BusinessException("0001", "sysCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)pCode)) {
            throw new BusinessException("0001", "pCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException("0001", "code\uff01");
        }
        String redisKey = sysCode + "_" + pCode + "_";
        Object object = this.cacheService.get(redisKey);
        if (object != null) {
            List dicDictionary = (List)object;
            if (!CollectionUtils.isEmpty((Collection)dicDictionary)) {
                for (SscDicDictionaryBO bo : dicDictionary) {
                    if (!code.equals(bo.getCode())) continue;
                    return bo.getTitle();
                }
            }
        } else {
            SscDicDictionaryPO dictionaryPO = new SscDicDictionaryPO();
            dictionaryPO.setpCode(pCode);
            dictionaryPO.setSysCode(sysCode);
            List<SscDicDictionaryPO> SscDicDictionaryPOList = this.sscDicDictionaryDAO.getListByCondition(dictionaryPO);
            if (!CollectionUtils.isEmpty(SscDicDictionaryPOList)) {
                ArrayList<SscDicDictionaryBO> bos = new ArrayList<SscDicDictionaryBO>();
                for (SscDicDictionaryPO dicPO : SscDicDictionaryPOList) {
                    SscDicDictionaryBO bo = new SscDicDictionaryBO();
                    BeanUtils.copyProperties((Object)dicPO, (Object)bo);
                    if (code.equals(bo.getCode())) {
                        result = bo.getTitle();
                    }
                    bos.add(bo);
                }
                this.cacheService.set(redisKey, bos);
            }
        }
        return result;
    }
}

