/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.common.SscProjectExtBO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectExtDAO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.atom.SscOperProjectAttachAtomService;
import com.tydic.ssc.service.atom.SscOperProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomRspBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscAddProjectDetailBusiService;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddProjectDetailBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscAddProjectDetailBusiServiceImpl
implements SscAddProjectDetailBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProjectExtDAO sscProjectExtDAO;
    @Autowired
    private SscOperProjectAttachAtomService sscOperProjectAttachAtomService;
    @Autowired
    private SscOperProjectExtAtomService sscOperProjectExtAtomService;

    @Override
    public SscAddProjectDetailBusiRspBO addProjectDetail(SscAddProjectDetailBusiReqBO busiReqBO) {
        SscAddProjectDetailBusiRspBO rspBO = new SscAddProjectDetailBusiRspBO();
        this.addProject(busiReqBO);
        if (null != busiReqBO.getSscProjectDetailBOs()) {
            this.addProjectDetailInfo(busiReqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u521b\u5efa\u6210\u529f\uff01");
        return rspBO;
    }

    private void addProject(SscAddProjectDetailBusiReqBO busiReqBO) {
        SscProjectPO insertProjectPO = new SscProjectPO();
        insertProjectPO.setProjectId(busiReqBO.getProjectId());
        insertProjectPO.setPlanId(busiReqBO.getPlanId());
        insertProjectPO.setProjectUpdateId(busiReqBO.getOperId());
        insertProjectPO.setProjectUpdateName(busiReqBO.getOperName());
        int isInsert = this.sscProjectDAO.insert(insertProjectPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8868\u5931\u8d25\uff01");
        }
    }

    private void addProjectDetailInfo(SscAddProjectDetailBusiReqBO busiReqBO) {
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectDetailBOs())) {
            ArrayList<SscProjectDetailPO> sscProjectDetailPOs = new ArrayList<SscProjectDetailPO>();
            for (SscProjectDetailBO bo : busiReqBO.getSscProjectDetailBOs()) {
                SscProjectDetailPO insertProjectDetailPO = new SscProjectDetailPO();
                BeanUtils.copyProperties((Object)bo, (Object)insertProjectDetailPO);
                insertProjectDetailPO.setProjectDetailId(Sequence.getInstance().nextId());
                insertProjectDetailPO.setProjectId(busiReqBO.getProjectId());
                insertProjectDetailPO.setPlanId(busiReqBO.getPlanId());
                insertProjectDetailPO.setOperId(busiReqBO.getOperId());
                insertProjectDetailPO.setOperName(busiReqBO.getOperName());
                insertProjectDetailPO.setOperTime(new Date());
                sscProjectDetailPOs.add(insertProjectDetailPO);
                if (!CollectionUtils.isEmpty((Collection)bo.getSscProjectAttachBOs())) {
                    this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectAttachBOs(), "8", insertProjectDetailPO.getProjectDetailId());
                }
                if (CollectionUtils.isEmpty((Collection)bo.getSscProjectExtBOs())) continue;
                this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectExtBOs(), "8", insertProjectDetailPO.getProjectDetailId());
            }
            int isInsrt = this.sscProjectDetailDAO.insertBatch(sscProjectDetailPOs);
            if (isInsrt != busiReqBO.getSscProjectDetailBOs().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u660e\u7ec6\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void operProjectExt(Long projectId, Long planId, List<SscProjectExtBO> sscProjectExtBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectExtBO bo : sscProjectExtBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectExtAtomReqBO sscOperProjectExtAtomReqBO = new SscOperProjectExtAtomReqBO();
        sscOperProjectExtAtomReqBO.setOperType("1");
        sscOperProjectExtAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectExtAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectExtAtomReqBO.setSscProjectExtBOs(sscProjectExtBOs);
        SscOperProjectExtAtomRspBO sscOperProjectExtAtomRspBO = this.sscOperProjectExtAtomService.operProjectExt(sscOperProjectExtAtomReqBO);
        if (!"0000".equals(sscOperProjectExtAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectExtAtomRspBO.getRespCode(), sscOperProjectExtAtomRspBO.getRespDesc());
        }
    }

    private void operProjectAttach(Long projectId, Long planId, List<SscProjectAttachBO> projectAttachBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectAttachBO bo : projectAttachBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectAttachAtomReqBO sscOperProjectAttachAtomReqBO = new SscOperProjectAttachAtomReqBO();
        sscOperProjectAttachAtomReqBO.setOperType("1");
        sscOperProjectAttachAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectAttachAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectAttachAtomReqBO.setSscProjectAttachBOs(projectAttachBOs);
        SscOperProjectAttachAtomRspBO sscOperProjectAttachAtomRspBO = this.sscOperProjectAttachAtomService.operProjectAttach(sscOperProjectAttachAtomReqBO);
        if (!"0000".equals(sscOperProjectAttachAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectAttachAtomRspBO.getRespCode(), sscOperProjectAttachAtomRspBO.getRespDesc());
        }
    }
}

