/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAndProfessorStageBO;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryProfessorStageListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProfessorStageListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProfessorStageListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryProfessorStageListBusiServiceImpl
implements SscQryProfessorStageListBusiService {
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProfessorStageListBusiRspBO qryProfessorStageList(SscQryProfessorStageListBusiReqBO reqBO) {
        SscQryProfessorStageListBusiRspBO rspBO = new SscQryProfessorStageListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectAndProfessorStageBO> sscProjectAndProfessorStageBOS = this.sscProfessorStageDAO.getProfessorStageListPage(reqBO, (Page<SscProjectAndProfessorStageBO>)page);
        if (CollectionUtils.isEmpty(sscProjectAndProfessorStageBOS)) {
            rspBO.setRespDesc("\u4e13\u5bb6\u8bc4\u6807\u6807\u6bb5\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectAndProfessorStageBOS.stream().map(SscProjectAndProfessorStageBO::getProjectId).collect(Collectors.toList());
            List<Long> stageIds = sscProjectAndProfessorStageBOS.stream().map(SscProjectAndProfessorStageBO::getStageId).collect(Collectors.toList());
            List professsorStageIds = sscProjectAndProfessorStageBOS.stream().map(SscProjectAndProfessorStageBO::getProfessorStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            SscQryProjectExtAtomReqBO sscQryProjectStageExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectStageExtAtomReqBO.setProjectObjectType("2");
            sscQryProjectStageExtAtomReqBO.setProjectObjectIds(stageIds);
            SscQryProjectExtAtomRspBO sscQryProjectStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectStageExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectStageExtMap = sscQryProjectStageExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProjectAndProfessorStageBO sscProjectAndProfessorStageBO : sscProjectAndProfessorStageBOS) {
                    sscProjectAndProfessorStageBO.setSscProjectExtMap(sscProjectExtMap.get(sscProjectAndProfessorStageBO.getProjectId()));
                }
            }
            if (null != sscProjectStageExtMap) {
                for (SscProjectAndProfessorStageBO sscProjectAndProfessorStageBO : sscProjectAndProfessorStageBOS) {
                    sscProjectAndProfessorStageBO.setProjectStageExtMap(sscProjectStageExtMap.get(sscProjectAndProfessorStageBO.getStageId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateField(sscProjectAndProfessorStageBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProjectAndProfessorStageBOS);
        rspBO.setRespDesc("\u4e13\u5bb6\u8bc4\u6807\u6807\u6bb5\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateField(List<SscProjectAndProfessorStageBO> sscProjectAndProfessorStageBOS) {
        Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
        Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_MODE");
        Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
        Map<String, String> commonMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
        for (SscProjectAndProfessorStageBO sscProjectAndProfessorStageBO : sscProjectAndProfessorStageBOS) {
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getProjectStatus())) {
                sscProjectAndProfessorStageBO.setProjectStatusStr(projectStatusMap.get(sscProjectAndProfessorStageBO.getProjectStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getPurchaseMode())) {
                sscProjectAndProfessorStageBO.setPurchaseModeStr(purchaseModeMap.get(sscProjectAndProfessorStageBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getTenderMode())) {
                sscProjectAndProfessorStageBO.setTenderModeStr(tenderModeMap.get(sscProjectAndProfessorStageBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getQuotationMode())) {
                sscProjectAndProfessorStageBO.setQuotationModeStr(quotationModeMap.get(sscProjectAndProfessorStageBO.getQuotationMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getIsNeedMargin())) {
                sscProjectAndProfessorStageBO.setIsNeedMarginStr(commonMap.get(sscProjectAndProfessorStageBO.getIsNeedMargin()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getBudgetPublic())) {
                sscProjectAndProfessorStageBO.setBudgetPublicStr(commonMap.get(sscProjectAndProfessorStageBO.getBudgetPublic()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getIsAttend())) {
                sscProjectAndProfessorStageBO.setIsAttendStr(commonMap.get(sscProjectAndProfessorStageBO.getIsAttend()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getIsSign())) {
                sscProjectAndProfessorStageBO.setIsSignStr(commonMap.get(sscProjectAndProfessorStageBO.getIsSign()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getIsSignCommit())) {
                sscProjectAndProfessorStageBO.setIsSignCommitStr(commonMap.get(sscProjectAndProfessorStageBO.getIsSignCommit()));
            }
            if (!StringUtils.isNotBlank((CharSequence)sscProjectAndProfessorStageBO.getIsEvaBid())) continue;
            sscProjectAndProfessorStageBO.setIsEvaBidStr(commonMap.get(sscProjectAndProfessorStageBO.getIsEvaBid()));
        }
    }
}

