/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscSupplierCollectionNoticeInfoBO;
import com.tydic.ssc.dao.SscSupplierCollectionDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.busi.SscQrySupCollectionNoticeListBusiService;
import com.tydic.ssc.service.busi.bo.SscQrySupCollectionNoticeListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQrySupCollectionNoticeListBusiRspBO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQrySupCollectionNoticeListBusiServiceImpl
implements SscQrySupCollectionNoticeListBusiService {
    @Autowired
    private SscSupplierCollectionDAO sscSupplierCollectionDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQrySupCollectionNoticeListBusiRspBO qrySupCollectionNoticeList(SscQrySupCollectionNoticeListBusiReqBO reqBO) {
        SscQrySupCollectionNoticeListBusiRspBO rspBO = new SscQrySupCollectionNoticeListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscSupplierCollectionNoticeInfoBO> supCollectionNoticeList = this.sscSupplierCollectionDAO.getSupCollectionNoticeList(reqBO, (Page<SscSupplierCollectionNoticeInfoBO>)page);
        if (!CollectionUtils.isEmpty(supCollectionNoticeList)) {
            this.translateField(supCollectionNoticeList);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(supCollectionNoticeList);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u6536\u85cf\u516c\u544a\u5217\u8868\u67e5\u8be2");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateField(List<SscSupplierCollectionNoticeInfoBO> supCollectionNoticeList) {
        Map<String, String> purchaseModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_MODE");
        Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_MODE");
        Map<String, String> noticeTypeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "NOTICE_TYPE");
        for (SscSupplierCollectionNoticeInfoBO noticeInfoBO : supCollectionNoticeList) {
            if (StringUtils.isNotBlank((CharSequence)noticeInfoBO.getPurchaseMode())) {
                noticeInfoBO.setPurchaseModeStr(purchaseModeMap.get(noticeInfoBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)noticeInfoBO.getTenderMode())) {
                noticeInfoBO.setTenderModeStr(tenderModeMap.get(noticeInfoBO.getTenderMode()));
            }
            if (!StringUtils.isNotBlank((CharSequence)noticeInfoBO.getNoticeType())) continue;
            noticeInfoBO.setNoticeTypeStr(noticeTypeMap.get(noticeInfoBO.getNoticeType()));
        }
    }
}

