/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryToSignUpProjectListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpProjectListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpProjectListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryToSignUpProjectListBusiServiceImpl
implements SscQryToSignUpProjectListBusiService {
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryToSignUpProjectListBusiRspBO qryToSignUpProjectList(SscQryToSignUpProjectListBusiReqBO reqBO) {
        SscQryToSignUpProjectListBusiRspBO rspBO = new SscQryToSignUpProjectListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectBO> sscProjectBOS = this.sscSupplierStageDAO.getToSignUpProjectList(reqBO, (Page<SscProjectBO>)page);
        if (CollectionUtils.isEmpty(sscProjectBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u9879\u76ee\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectBOS.stream().map(SscProjectBO::getProjectId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProjectBO sscProjectBO : sscProjectBOS) {
                    sscProjectBO.setSscProjectExtMap(sscProjectExtMap.get(sscProjectBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProjectBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u9879\u76ee\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectBO> sscProjectBOS) {
        for (SscProjectBO sscProjectBO : sscProjectBOS) {
            Map<String, String> purchaseCategoryMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_CATEGORY");
            Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
            Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_MODE");
            Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
            Map<String, String> commonStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            if (StringUtils.isNotBlank((CharSequence)sscProjectBO.getPurchaseMode())) {
                sscProjectBO.setPurchaseModeStr(purchaseCategoryMap.get(sscProjectBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectBO.getProjectStatus())) {
                sscProjectBO.setProjectStatusStr(projectStatusMap.get(sscProjectBO.getProjectStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectBO.getTenderMode())) {
                sscProjectBO.setTenderModeStr(tenderModeMap.get(sscProjectBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectBO.getQuotationMode())) {
                sscProjectBO.setQuotationModeStr(quotationModeMap.get(sscProjectBO.getQuotationMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectBO.getIsNeedMargin())) {
                sscProjectBO.setIsNeedMarginStr(commonStatusMap.get(sscProjectBO.getIsNeedMargin()));
            }
            if (!StringUtils.isNotBlank((CharSequence)sscProjectBO.getBudgetPublic())) continue;
            sscProjectBO.setBudgetPublicStr(commonStatusMap.get(sscProjectBO.getBudgetPublic()));
        }
    }
}

