/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProjectAndStageBO;
import com.tydic.ssc.dao.SscSupplierStageDAO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryToSignUpStageListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpStageListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryToSignUpStageListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryToSignUpStageListBusiServiceImpl
implements SscQryToSignUpStageListBusiService {
    @Autowired
    private SscSupplierStageDAO sscSupplierStageDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryToSignUpStageListBusiRspBO qryToSignUpStageList(SscQryToSignUpStageListBusiReqBO reqBO) {
        SscQryToSignUpStageListBusiRspBO rspBO = new SscQryToSignUpStageListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectAndStageBO> sscProjectAndStageBOS = this.sscSupplierStageDAO.getToSignUpStageList(reqBO, (Page<SscProjectAndStageBO>)page);
        if (CollectionUtils.isEmpty(sscProjectAndStageBOS)) {
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u6807\u6bb5\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> projectIds = sscProjectAndStageBOS.stream().map(SscProjectAndStageBO::getProjectId).collect(Collectors.toList());
            List<Long> stageIds = sscProjectAndStageBOS.stream().map(SscProjectAndStageBO::getStageId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(projectIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
                    sscProjectAndStageBO.setSscProjectExtMap(sscProjectExtMap.get(sscProjectAndStageBO.getProjectId()));
                }
            }
            sscQryProjectExtAtomReqBO.setProjectObjectType("2");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(stageIds);
            SscQryProjectExtAtomRspBO sscQryStageExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscStageExtMap = sscQryStageExtAtomRspBO.getSscProjectExtMap();
            if (null != sscStageExtMap) {
                for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
                    sscProjectAndStageBO.setProjectStageExtMap(sscProjectExtMap.get(sscProjectAndStageBO.getProjectId()));
                }
            }
        }
        if (reqBO.getTranslateFlag().booleanValue()) {
            this.translateFiled(sscProjectAndStageBOS);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProjectAndStageBOS);
        rspBO.setRespDesc("\u4f9b\u5e94\u5546\u5f85\u62a5\u540d\u6807\u6bb5\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void translateFiled(List<SscProjectAndStageBO> sscProjectAndStageBOS) {
        for (SscProjectAndStageBO sscProjectAndStageBO : sscProjectAndStageBOS) {
            Map<String, String> purchaseCategoryMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PURCHASE_CATEGORY");
            Map<String, String> projectStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_STATUS");
            Map<String, String> tenderModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TENDER_MODE");
            Map<String, String> quotationModeMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUOTATION_MODE");
            Map<String, String> commonStatusMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "YES_OR_NO");
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getPurchaseMode())) {
                sscProjectAndStageBO.setPurchaseModeStr(purchaseCategoryMap.get(sscProjectAndStageBO.getPurchaseMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getProjectStatus())) {
                sscProjectAndStageBO.setProjectStatusStr(projectStatusMap.get(sscProjectAndStageBO.getProjectStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getTenderMode())) {
                sscProjectAndStageBO.setTenderModeStr(tenderModeMap.get(sscProjectAndStageBO.getTenderMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getQuotationMode())) {
                sscProjectAndStageBO.setQuotationModeStr(quotationModeMap.get(sscProjectAndStageBO.getQuotationMode()));
            }
            if (StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getIsNeedMargin())) {
                sscProjectAndStageBO.setIsNeedMarginStr(commonStatusMap.get(sscProjectAndStageBO.getIsNeedMargin()));
            }
            if (!StringUtils.isNotBlank((CharSequence)sscProjectAndStageBO.getBudgetPublic())) continue;
            sscProjectAndStageBO.setBudgetPublicStr(commonStatusMap.get(sscProjectAndStageBO.getBudgetPublic()));
        }
    }
}

