/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.atom.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscStatusCirculationConfDAO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscStatusCirculationConfPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscDealStatusCirculationConfAtomServiceImpl
implements SscDealStatusCirculationConfAtomService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscStatusCirculationConfDAO sscStatusCirculationConfDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;

    @Override
    public SscDealStatusCirculationConfAtomRspBO dealStatusCirculationConf(SscDealStatusCirculationConfAtomReqBO atomReqBO) {
        SscDealStatusCirculationConfAtomRspBO rsp = new SscDealStatusCirculationConfAtomRspBO();
        if (null == atomReqBO.getProjectId()) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010projectId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == atomReqBO.getId()) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010id\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)atomReqBO.getStatusChangeOperCode())) {
            throw new BusinessException("0001", "\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010statusChangeOperCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SscStatusCirculationConfPO whereStatusCirculationConfPO = new SscStatusCirculationConfPO();
        whereStatusCirculationConfPO.setStatusChangeOperCode(atomReqBO.getStatusChangeOperCode());
        List<SscStatusCirculationConfPO> sscStatusCirculationConfPOs = this.sscStatusCirculationConfDAO.getList(whereStatusCirculationConfPO);
        if (CollectionUtils.isEmpty(sscStatusCirculationConfPOs)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u72b6\u6001\u6d41\u8f6c\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        block8: for (SscStatusCirculationConfPO po : sscStatusCirculationConfPOs) {
            switch (po.getChangeTable()) {
                case "1": {
                    this.dealProjectStatus(atomReqBO, po);
                    continue block8;
                }
                case "3": {
                    this.dealProjectSupplierStatus(atomReqBO, po);
                    continue block8;
                }
            }
            throw new BusinessException("8888", "\u672a\u77e5\u7684\u53d8\u66f4\u8868\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u72b6\u6001\u53d8\u66f4\u6210\u529f\uff01");
        return rsp;
    }

    private void dealProjectSupplierStatus(SscDealStatusCirculationConfAtomReqBO atomReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        SscProjectSupplierPO whwereProjectSupplierPO = new SscProjectSupplierPO();
        whwereProjectSupplierPO.setProjectId(atomReqBO.getProjectId());
        whwereProjectSupplierPO.setPlanId(atomReqBO.getPlanId());
        List<SscProjectSupplierPO> sscProjectSupplierPOs = this.sscProjectSupplierDAO.getList(whwereProjectSupplierPO);
        if (!CollectionUtils.isEmpty(sscProjectSupplierPOs)) {
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (SscProjectSupplierPO po : sscProjectSupplierPOs) {
                List<String> oldStatuss;
                if (sscStatusCirculationConfPO.getOldStatus().contains(",") ? !(oldStatuss = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","))).contains(po.getSupplierStatus()) : !sscStatusCirculationConfPO.getOldStatus().equals(po.getSupplierStatus())) continue;
                supplierIds.add(po.getSupplierId());
            }
            if (!CollectionUtils.isEmpty(supplierIds)) {
                SscProjectSupplierPO updatePO = new SscProjectSupplierPO();
                updatePO.setProjectId(atomReqBO.getProjectId());
                updatePO.setPlanId(atomReqBO.getPlanId());
                updatePO.setSupplierIds(supplierIds);
                updatePO.setSupplierStatus(sscStatusCirculationConfPO.getNewStatus());
                int isUpdate = this.sscProjectSupplierDAO.updateByCondition(updatePO);
                if (isUpdate != supplierIds.size()) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01\uff01");
                }
            }
        }
    }

    private void dealProjectStatus(SscDealStatusCirculationConfAtomReqBO atomReqBO, SscStatusCirculationConfPO sscStatusCirculationConfPO) {
        List<String> oldStatuss;
        SscProjectPO whereProjectPO = new SscProjectPO();
        whereProjectPO.setProjectId(atomReqBO.getProjectId());
        whereProjectPO.setPlanId(atomReqBO.getPlanId());
        SscProjectPO sscProjectPO = this.sscProjectDAO.getModelBy(whereProjectPO);
        if (null == sscProjectPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        if (sscStatusCirculationConfPO.getOldStatus().contains(",") ? !(oldStatuss = Arrays.asList(sscStatusCirculationConfPO.getOldStatus().split(","))).contains(sscProjectPO.getProjectStatus()) : !sscStatusCirculationConfPO.getOldStatus().equals(sscProjectPO.getProjectStatus())) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u5f53\u524d\u72b6\u6001\u4e0d\u5339\u914d\uff01");
        }
        whereProjectPO.setProjectStatus(sscStatusCirculationConfPO.getNewStatus());
        int isUpdate = this.sscProjectDAO.updateByPrimaryKeySelective(whereProjectPO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01\uff01");
        }
    }
}

