/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.common.SscProjectExtBO;
import com.tydic.ssc.common.SscProjectStageBO;
import com.tydic.ssc.common.SscProjectStageScoreItemBO;
import com.tydic.ssc.common.SscProjectSupplierBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectExtDAO;
import com.tydic.ssc.dao.SscProjectQuotationRoundDAO;
import com.tydic.ssc.dao.SscProjectStageDAO;
import com.tydic.ssc.dao.SscProjectStageScoreItemDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectExtPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectQuotationRoundPO;
import com.tydic.ssc.dao.po.SscProjectStagePO;
import com.tydic.ssc.dao.po.SscProjectStageScoreItemPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.SscOperProjectAttachAtomService;
import com.tydic.ssc.service.atom.SscOperProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectAttachAtomRspBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscOperProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscProjectCreateBusiService;
import com.tydic.ssc.service.busi.bo.SscProjectCreateBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProjectCreateBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscProjectCreateBusiServiceImpl
implements SscProjectCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProjectCreateBusiServiceImpl.class);
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;
    @Autowired
    private SscProjectStageDAO sscProjectStageDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectStageScoreItemDAO sscProjectStageScoreItemDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProjectExtDAO sscProjectExtDAO;
    @Autowired
    private SscOperProjectAttachAtomService sscOperProjectAttachAtomService;
    @Autowired
    private SscOperProjectExtAtomService sscOperProjectExtAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscProjectQuotationRoundDAO sscProjectQuotationRoundDAO;

    @Override
    public SscProjectCreateBusiRspBO dealSscProjectCreate(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectCreateBusiRspBO rsp = new SscProjectCreateBusiRspBO();
        if (null != busiReqBO.getSscProjectBO()) {
            this.dealProject(busiReqBO);
        }
        if (busiReqBO.getSetProjectStageFlag().booleanValue()) {
            this.dealProjectStage(busiReqBO);
        }
        if (busiReqBO.getSetProjectDetailFlag().booleanValue()) {
            this.dealProjectDetail(busiReqBO);
        }
        if (busiReqBO.getSetProjectInvitationSupplierFlag().booleanValue()) {
            this.dealProjectSupplier(busiReqBO);
        }
        if (busiReqBO.getSetProjectStageScoreItemFlag().booleanValue()) {
            this.dealProjectStageScoreItem(busiReqBO);
        }
        if (busiReqBO.getSubmitFlag().booleanValue()) {
            this.deleteProjectApproval(busiReqBO.getProjectId());
            if (StringUtils.isNotBlank((CharSequence)busiReqBO.getProcessKey())) {
                Long projectAuditOrderId = Sequence.getInstance().nextId();
                Long auditOrderId = this.createProcess(busiReqBO, projectAuditOrderId);
                this.updateProjectApproal(busiReqBO, projectAuditOrderId, auditOrderId);
            }
            SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
            sscDealStatusCirculationConfAtomReqBO.setProjectId(busiReqBO.getProjectId());
            sscDealStatusCirculationConfAtomReqBO.setPlanId(busiReqBO.getPlanId());
            sscDealStatusCirculationConfAtomReqBO.setId(busiReqBO.getProjectId());
            sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
            if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
                throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((CharSequence)busiReqBO.getProcessKey())) {
                this.insertQutationAndBidRound(busiReqBO);
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    private void insertQutationAndBidRound(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectPO checkExeistPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        SscProjectQuotationRoundPO insertProjectQuotationRoundPO = new SscProjectQuotationRoundPO();
        insertProjectQuotationRoundPO.setQuotationRoundId(Sequence.getInstance().nextId());
        insertProjectQuotationRoundPO.setProjectId(busiReqBO.getProjectId());
        insertProjectQuotationRoundPO.setPlanId(busiReqBO.getPlanId());
        insertProjectQuotationRoundPO.setQuotationRound(1);
        if ("1".equals(checkExeistPO.getProjectComparisonPriceModel())) {
            insertProjectQuotationRoundPO.setIsLastQuotation("1");
        } else {
            insertProjectQuotationRoundPO.setIsLastQuotation("0");
        }
        int isInsert = this.sscProjectQuotationRoundDAO.insert(insertProjectQuotationRoundPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u8f6e\u6b21\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        SscProjectBidRoundPO inertProjectBidRoundPO = new SscProjectBidRoundPO();
        inertProjectBidRoundPO.setBidRoundId(Sequence.getInstance().nextId());
        inertProjectBidRoundPO.setProjectId(busiReqBO.getProjectId());
        inertProjectBidRoundPO.setBidStatus("2");
        inertProjectBidRoundPO.setScoreRound(1);
        inertProjectBidRoundPO.setQuotationRound(1);
        inertProjectBidRoundPO.setOperNo(busiReqBO.getOperId());
        inertProjectBidRoundPO.setOperName(busiReqBO.getOperName());
        inertProjectBidRoundPO.setOperTime(new Date());
        int isInsert2 = this.sscProjectBidRoundDAO.insert(inertProjectBidRoundPO);
        if (isInsert2 < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateProjectApproal(SscProjectCreateBusiReqBO busiReqBO, Long projectAuditOrderId, Long auditOrderId) {
        SscProjectApprovalPO insertPO = new SscProjectApprovalPO();
        insertPO.setProjectApprovalId(Sequence.getInstance().nextId());
        insertPO.setProjectId(busiReqBO.getProjectId());
        insertPO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_CREATE_AUDIT);
        insertPO.setApprovalId(auditOrderId);
        insertPO.setToApprovalId(projectAuditOrderId);
        insertPO.setOperId(busiReqBO.getOperId());
        insertPO.setOperName(busiReqBO.getOperName());
        insertPO.setOperTime(new Date());
        int isInsert = this.sscProjectApprovalDAO.insert(insertPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u5ba1\u6279\u8868\u5931\u8d25\uff01");
        }
    }

    private void deleteProjectApproval(Long projectId) {
        SscProjectApprovalPO deleteWherePO = new SscProjectApprovalPO();
        deleteWherePO.setProjectId(projectId);
        deleteWherePO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_CREATE_AUDIT);
        this.sscProjectApprovalDAO.deleteBy(deleteWherePO);
    }

    private Long createProcess(SscProjectCreateBusiReqBO busiReqBO, Long projectAuditOrderId) {
        SscProjectPO checkExeistBO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null == checkExeistBO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(SscCommConstant.AuditObjType.PROJECT_CREATE_AUDIT);
        approvalObjBO.setObjId(projectAuditOrderId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(SscCommConstant.AuditObjType.PROJECT_CREATE_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(projectAuditOrderId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u9879\u76ee\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setProcDefKey(busiReqBO.getProcessKey());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getOperName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return (Long)uacNoTaskAuditCreateRspBO.getAuditOrderId().get(0);
    }

    private void dealProjectStageScoreItem(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectStageScoreItemPO sscProjectStageScoreItemPO = new SscProjectStageScoreItemPO();
        sscProjectStageScoreItemPO.setPlanId(busiReqBO.getPlanId());
        sscProjectStageScoreItemPO.setProjectId(busiReqBO.getProjectId());
        this.sscProjectStageScoreItemDAO.deleteBy(sscProjectStageScoreItemPO);
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectStageScoreItemBOs())) {
            ArrayList<SscProjectStageScoreItemPO> sscProjectStageScoreItemPOs = new ArrayList<SscProjectStageScoreItemPO>();
            for (SscProjectStageScoreItemBO bo : busiReqBO.getSscProjectStageScoreItemBOs()) {
                SscProjectStageScoreItemPO insertProjectStageScoreItemPO = new SscProjectStageScoreItemPO();
                BeanUtils.copyProperties((Object)bo, (Object)insertProjectStageScoreItemPO);
                insertProjectStageScoreItemPO.setScoreItemId(Sequence.getInstance().nextId());
                insertProjectStageScoreItemPO.setProjectId(busiReqBO.getProjectId());
                insertProjectStageScoreItemPO.setPlanId(busiReqBO.getPlanId());
                insertProjectStageScoreItemPO.setOperId(busiReqBO.getOperId());
                insertProjectStageScoreItemPO.setOperName(busiReqBO.getOperName());
                insertProjectStageScoreItemPO.setOperTime(new Date());
                sscProjectStageScoreItemPOs.add(insertProjectStageScoreItemPO);
            }
            int isInsrt = this.sscProjectStageScoreItemDAO.insertBatch(sscProjectStageScoreItemPOs);
            if (isInsrt != busiReqBO.getSscProjectStageScoreItemBOs().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u6807\u6bb5\u8bc4\u5206\u9879\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void dealProjectSupplier(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectSupplierPO sscProjectSupplierPO = new SscProjectSupplierPO();
        sscProjectSupplierPO.setPlanId(busiReqBO.getPlanId());
        sscProjectSupplierPO.setProjectId(busiReqBO.getProjectId());
        this.sscProjectSupplierDAO.deleteBy(sscProjectSupplierPO);
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectSupplierBOs())) {
            ArrayList<SscProjectSupplierPO> sscProjectSupplierPOs = new ArrayList<SscProjectSupplierPO>();
            for (SscProjectSupplierBO bo : busiReqBO.getSscProjectSupplierBOs()) {
                SscProjectSupplierPO insertProjectSupplierPO = new SscProjectSupplierPO();
                BeanUtils.copyProperties((Object)bo, (Object)insertProjectSupplierPO);
                insertProjectSupplierPO.setProjectSupplierId(Sequence.getInstance().nextId());
                insertProjectSupplierPO.setProjectId(busiReqBO.getProjectId());
                insertProjectSupplierPO.setPlanId(busiReqBO.getPlanId());
                insertProjectSupplierPO.setInvitationId(busiReqBO.getOperId());
                insertProjectSupplierPO.setInvitationName(busiReqBO.getOperName());
                insertProjectSupplierPO.setInvitationTime(new Date());
                sscProjectSupplierPOs.add(insertProjectSupplierPO);
            }
            int isInsrt = this.sscProjectSupplierDAO.insertBatch(sscProjectSupplierPOs);
            if (isInsrt != busiReqBO.getSscProjectSupplierBOs().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u9080\u8bf7\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void dealProjectDetail(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectDetailPO sscProjectDetailPO = new SscProjectDetailPO();
        sscProjectDetailPO.setPlanId(busiReqBO.getPlanId());
        sscProjectDetailPO.setProjectId(busiReqBO.getProjectId());
        this.sscProjectDetailDAO.deleteBy(sscProjectDetailPO);
        this.deleteAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "8", null);
        this.deleteExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "8", null);
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectDetailBOs())) {
            ArrayList<SscProjectDetailPO> sscProjectDetailPOs = new ArrayList<SscProjectDetailPO>();
            for (SscProjectDetailBO bo : busiReqBO.getSscProjectDetailBOs()) {
                SscProjectDetailPO insertProjectDetailPO = new SscProjectDetailPO();
                BeanUtils.copyProperties((Object)bo, (Object)insertProjectDetailPO);
                insertProjectDetailPO.setProjectDetailId(Sequence.getInstance().nextId());
                insertProjectDetailPO.setProjectId(busiReqBO.getProjectId());
                if (null != busiReqBO.getPlanId()) {
                    insertProjectDetailPO.setPlanId(busiReqBO.getPlanId());
                }
                insertProjectDetailPO.setOperId(busiReqBO.getOperId());
                insertProjectDetailPO.setOperName(busiReqBO.getOperName());
                insertProjectDetailPO.setOperTime(new Date());
                sscProjectDetailPOs.add(insertProjectDetailPO);
                if (!CollectionUtils.isEmpty((Collection)bo.getSscProjectAttachBOs())) {
                    this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectAttachBOs(), "8", insertProjectDetailPO.getProjectDetailId());
                }
                if (CollectionUtils.isEmpty((Collection)bo.getSscProjectExtBOs())) continue;
                this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectExtBOs(), "8", insertProjectDetailPO.getProjectDetailId());
            }
            int isInsrt = this.sscProjectDetailDAO.insertBatch(sscProjectDetailPOs);
            if (isInsrt != busiReqBO.getSscProjectDetailBOs().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u660e\u7ec6\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void dealProjectStage(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectStagePO sscProjectStagePO = new SscProjectStagePO();
        sscProjectStagePO.setPlanId(busiReqBO.getPlanId());
        sscProjectStagePO.setProjectId(busiReqBO.getProjectId());
        this.sscProjectStageDAO.deleteBy(sscProjectStagePO);
        this.deleteAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "2", null);
        this.deleteExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "2", null);
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectStageBOs())) {
            ArrayList<SscProjectStagePO> sscProjectStagePOs = new ArrayList<SscProjectStagePO>();
            for (SscProjectStageBO bo : busiReqBO.getSscProjectStageBOs()) {
                SscProjectStagePO insertProjectStagePO = new SscProjectStagePO();
                BeanUtils.copyProperties((Object)bo, (Object)insertProjectStagePO);
                insertProjectStagePO.setProjectId(busiReqBO.getProjectId());
                insertProjectStagePO.setPlanId(busiReqBO.getPlanId());
                sscProjectStagePOs.add(insertProjectStagePO);
                if (!CollectionUtils.isEmpty((Collection)bo.getSscProjectAttachBOs())) {
                    this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectAttachBOs(), "2", bo.getStageId());
                }
                if (CollectionUtils.isEmpty((Collection)bo.getSscProjectExtBOs())) continue;
                this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), bo.getSscProjectExtBOs(), "2", bo.getStageId());
            }
            int isInsrt = this.sscProjectStageDAO.insertBatch(sscProjectStagePOs);
            if (isInsrt != busiReqBO.getSscProjectStageBOs().size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u6807\u6bb5\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void dealProject(SscProjectCreateBusiReqBO busiReqBO) {
        SscProjectPO checkExeistPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null != checkExeistPO) {
            if (StringUtils.isNotBlank((CharSequence)checkExeistPO.getProjectStatus()) && !"1".equals(checkExeistPO.getProjectStatus())) {
                throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
            }
            SscProjectPO updateProjectPO = new SscProjectPO();
            BeanUtils.copyProperties((Object)busiReqBO.getSscProjectBO(), (Object)updateProjectPO);
            updateProjectPO.setProjectId(busiReqBO.getProjectId());
            updateProjectPO.setPlanId(busiReqBO.getPlanId());
            updateProjectPO.setProjectUpdateId(busiReqBO.getOperId());
            updateProjectPO.setProjectUpdateName(busiReqBO.getOperName());
            updateProjectPO.setProjectUpdateTime(new Date());
            int isUpdate = this.sscProjectDAO.updateByPrimaryKey(updateProjectPO);
            if (isUpdate < 1) {
                throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
        } else {
            SscProjectPO insertProjectPO = new SscProjectPO();
            BeanUtils.copyProperties((Object)busiReqBO.getSscProjectBO(), (Object)insertProjectPO);
            insertProjectPO.setProjectId(busiReqBO.getProjectId());
            insertProjectPO.setPlanId(busiReqBO.getPlanId());
            insertProjectPO.setProjectProducerId(busiReqBO.getOperId());
            insertProjectPO.setProjectProducerName(busiReqBO.getOperName());
            insertProjectPO.setProjectProducerTime(new Date());
            int isInsert = this.sscProjectDAO.insert(insertProjectPO);
            if (isInsert < 1) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8868\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getSscProjectBO().getDeleteProjectAttachTypes())) {
            this.deleteAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "1", busiReqBO.getSscProjectBO().getDeleteProjectAttachTypes());
        }
        if (null != busiReqBO.getSscProjectBO().getSscProjectAttachBOs()) {
            this.operProjectAttach(busiReqBO.getProjectId(), busiReqBO.getPlanId(), busiReqBO.getSscProjectBO().getSscProjectAttachBOs(), "1", busiReqBO.getProjectId());
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getSscProjectBO().getDeleteProjectExtCodes())) {
            this.deleteExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), "1", busiReqBO.getSscProjectBO().getDeleteProjectExtCodes());
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getSscProjectBO().getSscProjectExtBOs())) {
            this.operProjectExt(busiReqBO.getProjectId(), busiReqBO.getPlanId(), busiReqBO.getSscProjectBO().getSscProjectExtBOs(), "1", busiReqBO.getProjectId());
        }
    }

    private void operProjectExt(Long projectId, Long planId, List<SscProjectExtBO> sscProjectExtBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectExtBO bo : sscProjectExtBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectExtAtomReqBO sscOperProjectExtAtomReqBO = new SscOperProjectExtAtomReqBO();
        sscOperProjectExtAtomReqBO.setOperType("1");
        sscOperProjectExtAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectExtAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectExtAtomReqBO.setSscProjectExtBOs(sscProjectExtBOs);
        SscOperProjectExtAtomRspBO sscOperProjectExtAtomRspBO = this.sscOperProjectExtAtomService.operProjectExt(sscOperProjectExtAtomReqBO);
        if (!"0000".equals(sscOperProjectExtAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectExtAtomRspBO.getRespCode(), sscOperProjectExtAtomRspBO.getRespDesc());
        }
    }

    private void operProjectAttach(Long projectId, Long planId, List<SscProjectAttachBO> projectAttachBOs, String projectObjectType, Long projectObjectId) {
        for (SscProjectAttachBO bo : projectAttachBOs) {
            bo.setProjectId(projectId);
            bo.setPlanId(planId);
            bo.setProjectObjectId(projectObjectId);
            bo.setProjectObjectType(projectObjectType);
        }
        SscOperProjectAttachAtomReqBO sscOperProjectAttachAtomReqBO = new SscOperProjectAttachAtomReqBO();
        sscOperProjectAttachAtomReqBO.setOperType("1");
        sscOperProjectAttachAtomReqBO.setProjectObjectId(projectObjectId);
        sscOperProjectAttachAtomReqBO.setProjectObjectType(projectObjectType);
        sscOperProjectAttachAtomReqBO.setSscProjectAttachBOs(projectAttachBOs);
        SscOperProjectAttachAtomRspBO sscOperProjectAttachAtomRspBO = this.sscOperProjectAttachAtomService.operProjectAttach(sscOperProjectAttachAtomReqBO);
        if (!"0000".equals(sscOperProjectAttachAtomRspBO.getRespCode())) {
            throw new BusinessException(sscOperProjectAttachAtomRspBO.getRespCode(), sscOperProjectAttachAtomRspBO.getRespDesc());
        }
    }

    private void deleteExt(Long projectId, Long planId, String projectObjectType, List<String> deleteProjectExtCodes) {
        SscProjectExtPO deleteProjectExtPO = new SscProjectExtPO();
        deleteProjectExtPO.setProjectId(projectId);
        deleteProjectExtPO.setPlanId(planId);
        deleteProjectExtPO.setProjectObjectType(projectObjectType);
        deleteProjectExtPO.setExtCodes(deleteProjectExtCodes);
        this.sscProjectExtDAO.deleteBy(deleteProjectExtPO);
    }

    private void deleteAttach(Long projectId, Long planId, String projectObjectType, List<String> deleteProjectAttachTypes) {
        SscProjectAttachPO deleteProjectAttachPO = new SscProjectAttachPO();
        deleteProjectAttachPO.setProjectId(projectId);
        deleteProjectAttachPO.setPlanId(planId);
        deleteProjectAttachPO.setProjectObjectType(projectObjectType);
        deleteProjectAttachPO.setProjectAttachTypes(deleteProjectAttachTypes);
        this.sscProjectAttachDAO.deleteBy(deleteProjectAttachPO);
    }
}

