/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectAttachBO;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.po.SscProfessorStagePO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscProjectOpenBidBusiService;
import com.tydic.ssc.service.busi.bo.SscProjectOpenBidBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscProjectOpenBidBusiRspBO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscProjectOpenBidBusiServiceImpl
implements SscProjectOpenBidBusiService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;

    @Override
    public SscProjectOpenBidBusiRspBO dealProjectOpenBid(SscProjectOpenBidBusiReqBO busiReqBO) {
        SscProjectOpenBidBusiRspBO rsp = new SscProjectOpenBidBusiRspBO();
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        if (null == sscProjectPO) {
            throw new BusinessException("8888", "\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        this.checkOpenNoAndPassword(busiReqBO, sscProjectPO);
        SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
        sscDealStatusCirculationConfAtomReqBO.setProjectId(busiReqBO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setId(busiReqBO.getProjectId());
        sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
        SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
        if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
            throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
        }
        SscProjectSupplierPO setPO = new SscProjectSupplierPO();
        setPO.setSupplierStatus("9");
        SscProjectSupplierPO wherePO = new SscProjectSupplierPO();
        wherePO.setProjectId(busiReqBO.getProjectId());
        wherePO.setSupplierStatus("8");
        this.sscProjectSupplierDAO.updateBy(setPO, wherePO);
        SscProfessorStagePO updateProfessorStagePO = new SscProfessorStagePO();
        updateProfessorStagePO.setProjectId(busiReqBO.getProjectId());
        updateProfessorStagePO.setProfessorStatus("2");
        this.sscProfessorStageDAO.updateByCondition(updateProfessorStagePO);
        if (!CollectionUtils.isEmpty(busiReqBO.getProjectAttachBOs())) {
            List<SscProjectAttachBO> projectAttachBOs = busiReqBO.getProjectAttachBOs();
            for (SscProjectAttachBO bo : projectAttachBOs) {
                SscProjectAttachPO insertParam = new SscProjectAttachPO();
                BeanUtils.copyProperties((Object)bo, (Object)insertParam);
                int insertResult = this.sscProjectAttachDAO.insert(insertParam);
                if (insertResult >= 1) continue;
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u9879\u76ee\u5f00\u6807\u6210\u529f\uff01");
        return rsp;
    }

    private void checkOpenNoAndPassword(SscProjectOpenBidBusiReqBO busiReqBO, SscProjectPO sscProjectPO) {
        String openNo = sscProjectPO.getBidOpenNo();
        if (!openNo.equals(busiReqBO.getOperId().toString())) {
            throw new BusinessException("8888", "\u5f53\u524d\u767b\u9646\u4eba\u975e\u9879\u76ee\u5f00\u6807\u4eba\uff0c\u4e0d\u80fd\u5f00\u6807\uff01");
        }
        if ("1".equals(sscProjectPO.getIsNeedOpenPassword())) {
            if (StringUtils.isBlank((CharSequence)busiReqBO.getOpenPassword())) {
                throw new BusinessException("8888", "\u9879\u76ee\u5f00\u6807\u5bc6\u7801\u4e3a\u7a7a\uff01");
            }
            if (!sscProjectPO.getOpenPassword().equals(busiReqBO.getOpenPassword())) {
                throw new BusinessException("8888", "\u5f00\u6807\u5bc6\u7801\u9519\u8bef\uff01");
            }
        }
    }
}

