/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.common.SscProfessorBO;
import com.tydic.ssc.dao.SscProfessorDAO;
import com.tydic.ssc.dao.SscProfessorStageDAO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.po.SscProfessorPO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.atom.SscQryProjectExtAtomService;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscQryProjectExtAtomRspBO;
import com.tydic.ssc.service.busi.SscQryProfessorListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProfessorListBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscQryProfessorListBusiRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscQryProfessorListBusiServiceImpl
implements SscQryProfessorListBusiService {
    @Autowired
    private SscProfessorDAO sscProfessorDAO;
    @Autowired
    private SscQryProjectExtAtomService sscQryProjectExtAtomService;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;
    @Autowired
    private SscProfessorStageDAO sscProfessorStageDAO;
    @Autowired
    private SscDicDictionaryAtomService sscDicDictionaryAtomService;

    @Override
    public SscQryProfessorListBusiRspBO qryProfessorList(SscQryProfessorListBusiReqBO reqBO) {
        Page page;
        List<SscProfessorBO> sscProfessorBOS;
        SscQryProfessorListBusiRspBO rspBO = new SscQryProfessorListBusiRspBO();
        SscProfessorPO sscProfessorPO = new SscProfessorPO();
        if (null != reqBO.getProjectId() && StringUtils.isNotBlank((CharSequence)reqBO.getProfessorClassify())) {
            List<Long> professIds = this.sscProfessorStageDAO.getDeduplicationProfessor(reqBO.getProfessorClassify(), reqBO.getProjectId());
            reqBO.setProfessorList(professIds);
        }
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)sscProfessorPO);
        if (!reqBO.getQueryPageFlag().booleanValue()) {
            reqBO.setPageNo(-1);
            reqBO.setPageSize(-1);
        }
        if (CollectionUtils.isEmpty(sscProfessorBOS = this.sscProfessorDAO.getListPage(sscProfessorPO, (Page<SscProfessorBO>)(page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue()))))) {
            rspBO.setRespDesc("\u4e13\u5bb6\u5217\u8868\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        if (reqBO.getQueryExtInfo().booleanValue()) {
            List<Long> professorIds = sscProfessorBOS.stream().map(SscProfessorBO::getProfessorId).collect(Collectors.toList());
            SscQryProjectExtAtomReqBO sscQryProjectExtAtomReqBO = new SscQryProjectExtAtomReqBO();
            sscQryProjectExtAtomReqBO.setProjectObjectType("1");
            sscQryProjectExtAtomReqBO.setProjectObjectIds(professorIds);
            SscQryProjectExtAtomRspBO sscQryProjectExtAtomRspBO = this.sscQryProjectExtAtomService.qryProjectExt(sscQryProjectExtAtomReqBO);
            Map<Long, Map<String, String>> sscProjectExtMap = sscQryProjectExtAtomRspBO.getSscProjectExtMap();
            if (null != sscProjectExtMap) {
                for (SscProfessorBO sscProfessorBO : sscProfessorBOS) {
                    sscProfessorBO.setSscProfessorExtMap(sscProjectExtMap.get(sscProfessorBO.getProfessorId()));
                }
            }
        }
        Map<String, String> map1 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "PROJECT_TYPE_EXP");
        Map<String, String> map2 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "TITLE");
        Map<String, String> map3 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "QUALIFICATION");
        Map<String, String> map4 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "EXPERT_FACTORY");
        Map<String, String> map5 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "EDUCATIONAL_BACKGROUND");
        Map<String, String> map6 = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "IS_EXTERNAL_PROFESSOR");
        for (SscProfessorBO bo : sscProfessorBOS) {
            if (StringUtils.isNotBlank((CharSequence)bo.getProjectType())) {
                bo.setProjectType(map1.get(bo.getProjectType()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTitle())) {
                bo.setTitleName(map2.get(bo.getTitle()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getQualification())) {
                bo.setQualificationName(map3.get(bo.getQualification()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getDepartmentName())) {
                bo.setDepartmentName(map4.get(bo.getDepartmentName()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getEducationalBackground())) {
                bo.setEducationalBackgroundName(map5.get(bo.getEducationalBackground()));
            }
            if (!StringUtils.isNotBlank((CharSequence)bo.getIsExternalProfessor())) continue;
            bo.setIsExternalProfessorName(map6.get(bo.getIsExternalProfessor()));
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(sscProfessorBOS);
        rspBO.setRespDesc("\u4e13\u5bb6\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

