/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectTempAttachBO;
import com.tydic.ssc.common.SscSelectSupplierInfoBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempAttachDAO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempAttachPO;
import com.tydic.ssc.service.atom.SscDealStatusCirculationConfAtomService;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomReqBO;
import com.tydic.ssc.service.atom.bo.SscDealStatusCirculationConfAtomRspBO;
import com.tydic.ssc.service.busi.SscSelectSupplierBusiService;
import com.tydic.ssc.service.busi.bo.SscSelectSupplierBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSelectSupplierBusiRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSelectSupplierBusiServiceImpl
implements SscSelectSupplierBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscSelectSupplierBusiServiceImpl.class);
    @Autowired
    private SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private SscDealStatusCirculationConfAtomService sscDealStatusCirculationConfAtomService;
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectTempAttachDAO sscProjectTempAttachDAO;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;

    @Override
    public SscSelectSupplierBusiRspBO dealSelectSupplier(SscSelectSupplierBusiReqBO busiReqBO) {
        SscSelectSupplierBusiRspBO rsp = new SscSelectSupplierBusiRspBO();
        if (!CollectionUtils.isEmpty(busiReqBO.getSscProjectTempAttachBOs())) {
            this.updateProjectTempAttach(busiReqBO);
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getSscSelectSupplierInfoBOs())) {
            this.updateProjectSupplier(busiReqBO);
        }
        if (busiReqBO.getSubmitFlag().booleanValue()) {
            this.deleteProjectApproval(busiReqBO.getProjectId());
            if (StringUtils.isNotBlank((CharSequence)busiReqBO.getProcessKey())) {
                Long projectAuditOrderId = Sequence.getInstance().nextId();
                Long auditOrderId = this.createApprovalOrder(busiReqBO, projectAuditOrderId);
                this.updateProjectApproal(busiReqBO, projectAuditOrderId, auditOrderId);
            }
            SscDealStatusCirculationConfAtomReqBO sscDealStatusCirculationConfAtomReqBO = new SscDealStatusCirculationConfAtomReqBO();
            sscDealStatusCirculationConfAtomReqBO.setProjectId(busiReqBO.getProjectId());
            sscDealStatusCirculationConfAtomReqBO.setPlanId(busiReqBO.getPlanId());
            sscDealStatusCirculationConfAtomReqBO.setId(busiReqBO.getProjectId());
            sscDealStatusCirculationConfAtomReqBO.setStatusChangeOperCode(busiReqBO.getStatusChangeOperCode());
            SscDealStatusCirculationConfAtomRspBO sscDealStatusCirculationConfAtomRspBO = this.sscDealStatusCirculationConfAtomService.dealStatusCirculationConf(sscDealStatusCirculationConfAtomReqBO);
            if (!"0000".equals(sscDealStatusCirculationConfAtomRspBO.getRespCode())) {
                throw new BusinessException(sscDealStatusCirculationConfAtomRspBO.getRespCode(), sscDealStatusCirculationConfAtomRspBO.getRespDesc());
            }
            if ("select_supplier_no_approval".equals(busiReqBO.getStatusChangeOperCode())) {
                this.updateProjectSupplierStatus(busiReqBO);
                if (busiReqBO.getIsOperAttach().booleanValue()) {
                    this.updateAttachToProject(busiReqBO.getProjectId());
                }
            }
        }
        rsp.setRespDesc("\u4f9b\u5e94\u5546\u5165\u56f4\u9009\u62e9\u6210\u529f");
        rsp.setRespCode("0000");
        return rsp;
    }

    private void updateAttachToProject(Long projectId) {
        SscProjectAttachPO deletePO = new SscProjectAttachPO();
        deletePO.setProjectId(projectId);
        deletePO.setProjectObjectId(projectId);
        deletePO.setProjectObjectType("1");
        deletePO.setProjectAttachType("3");
        this.sscProjectAttachDAO.deleteBy(deletePO);
        SscProjectTempAttachPO wherePO = new SscProjectTempAttachPO();
        wherePO.setProjectId(projectId);
        wherePO.setTacheCode("1");
        wherePO.setProjectObjectType("1");
        wherePO.setProjectObjectId(projectId);
        List<SscProjectTempAttachPO> sscProjectTempAttachPOs = this.sscProjectTempAttachDAO.getList(wherePO);
        if (!CollectionUtils.isEmpty(sscProjectTempAttachPOs)) {
            ArrayList<SscProjectAttachPO> insertPOs = new ArrayList<SscProjectAttachPO>();
            for (SscProjectTempAttachPO po : sscProjectTempAttachPOs) {
                SscProjectAttachPO sscProjectAttachPO = new SscProjectAttachPO();
                sscProjectAttachPO.setProjectAttachId(Sequence.getInstance().nextId());
                sscProjectAttachPO.setProjectId(projectId);
                sscProjectAttachPO.setProjectAttachAddress(po.getProjectAttachAddress());
                sscProjectAttachPO.setProjectAttachName(po.getProjectAttachName());
                sscProjectAttachPO.setProjectAttachType("3");
                sscProjectAttachPO.setSupplierVisitFlag(po.getSupplierVisitFlag());
                sscProjectAttachPO.setProjectObjectType("1");
                sscProjectAttachPO.setProjectObjectId(projectId);
                insertPOs.add(sscProjectAttachPO);
            }
            int isInsert = this.sscProjectAttachDAO.insertBatch(insertPOs);
            if (isInsert != insertPOs.size()) {
                throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
        this.sscProjectTempAttachDAO.deleteBy(wherePO);
    }

    private void updateProjectTempAttach(SscSelectSupplierBusiReqBO busiReqBO) {
        SscProjectTempAttachPO deletePO = new SscProjectTempAttachPO();
        deletePO.setProjectId(busiReqBO.getProjectId());
        deletePO.setTacheCode("1");
        deletePO.setProjectObjectType("1");
        deletePO.setProjectObjectId(busiReqBO.getProjectId());
        this.sscProjectTempAttachDAO.deleteBy(deletePO);
        ArrayList<SscProjectTempAttachPO> insertPOs = new ArrayList<SscProjectTempAttachPO>();
        for (SscProjectTempAttachBO bo : busiReqBO.getSscProjectTempAttachBOs()) {
            SscProjectTempAttachPO sscProjectTempAttachPO = new SscProjectTempAttachPO();
            BeanUtils.copyProperties((Object)bo, (Object)sscProjectTempAttachPO);
            sscProjectTempAttachPO.setProjectTempAttachId(Sequence.getInstance().nextId());
            sscProjectTempAttachPO.setProjectId(busiReqBO.getProjectId());
            sscProjectTempAttachPO.setProjectObjectType("1");
            sscProjectTempAttachPO.setProjectObjectId(busiReqBO.getProjectId());
            sscProjectTempAttachPO.setTacheCode("1");
            insertPOs.add(sscProjectTempAttachPO);
        }
        int isInsrt = this.sscProjectTempAttachDAO.insertBatch(insertPOs);
        if (isInsrt != insertPOs.size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u4e34\u65f6\u9644\u4ef6\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateProjectSupplierStatus(SscSelectSupplierBusiReqBO busiReqBO) {
        SscProjectPO sscProjectPO = this.sscProjectDAO.selectByPrimaryKey(busiReqBO.getProjectId());
        SscProjectSupplierPO wherePO = new SscProjectSupplierPO();
        wherePO.setProjectId(busiReqBO.getProjectId());
        wherePO.setPlanId(busiReqBO.getPlanId());
        SscProjectSupplierPO setPO = new SscProjectSupplierPO();
        if ("1".equals(sscProjectPO.getPurchaseMode())) {
            wherePO.setSupplierStatus("2");
            wherePO.setSelectStatus("2");
            setPO.setSupplierStatus("3");
        }
        int isUpdate = this.sscProjectSupplierDAO.updateBy(setPO, wherePO);
        if ("1".equals(sscProjectPO.getPurchaseMode())) {
            wherePO.setSupplierStatus("2");
            wherePO.setSelectStatus("1");
            setPO.setSupplierStatus("4");
        }
        int isUpdate2 = this.sscProjectSupplierDAO.updateBy(setPO, wherePO);
    }

    private void deleteProjectApproval(Long projectId) {
        SscProjectApprovalPO deleteWherePO = new SscProjectApprovalPO();
        deleteWherePO.setProjectId(projectId);
        deleteWherePO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        this.sscProjectApprovalDAO.deleteBy(deleteWherePO);
    }

    private void updateProjectApproal(SscSelectSupplierBusiReqBO busiReqBO, Long projectAuditOrderId, Long auditOrderId) {
        SscProjectApprovalPO insertPO = new SscProjectApprovalPO();
        insertPO.setProjectApprovalId(Sequence.getInstance().nextId());
        insertPO.setProjectId(busiReqBO.getProjectId());
        insertPO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        insertPO.setApprovalId(auditOrderId);
        insertPO.setToApprovalId(projectAuditOrderId);
        insertPO.setOperId(busiReqBO.getOperId());
        insertPO.setOperName(busiReqBO.getOperName());
        insertPO.setOperTime(new Date());
        int isInsert = this.sscProjectApprovalDAO.insert(insertPO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u5ba1\u6279\u8868\u5931\u8d25\uff01");
        }
    }

    private Long createApprovalOrder(SscSelectSupplierBusiReqBO busiReqBO, Long projectAuditOrderId) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        approvalObjBO.setObjId(projectAuditOrderId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(SscCommConstant.AuditObjType.PROJECT_SELECT_SUPPLIER_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(projectAuditOrderId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u9879\u76ee\u4f9b\u5e94\u5546\u5165\u56f4\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setProcDefKey(busiReqBO.getProcessKey());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getOperId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getOperName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return (Long)uacNoTaskAuditCreateRspBO.getAuditOrderId().get(0);
    }

    private void updateProjectSupplier(SscSelectSupplierBusiReqBO busiReqBO) {
        for (SscSelectSupplierInfoBO bo : busiReqBO.getSscSelectSupplierInfoBOs()) {
            SscProjectSupplierPO updatePO = new SscProjectSupplierPO();
            updatePO.setProjectId(busiReqBO.getProjectId());
            updatePO.setPlanId(busiReqBO.getPlanId());
            updatePO.setStageId(bo.getStageId());
            updatePO.setSupplierId(bo.getSupplierId());
            if ("1".equals(bo.getSelectStatus())) {
                updatePO.setSelectStatus("1");
            } else {
                updatePO.setSelectStatus("2");
            }
            updatePO.setSelectReason(bo.getSelectReason());
            int isUpdate = this.sscProjectSupplierDAO.updateByCondition(updatePO);
            if (isUpdate >= 1) continue;
            throw new BusinessException("8888", "\u66f4\u65b0\u5165\u56f4\u4f9b\u5e94\u5546\u5931\u8d25\uff01");
        }
    }
}

